/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.model.serial.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.reviews.r4e.core.Activator;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.IModelWriter;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.SerializeFactory;
import org.eclipse.mylyn.reviews.r4e.core.utils.filePermission.FileSupportCommandFactory;

public class ChangeResController
implements Persistence.ResourceUpdater {
    private static final String LOCK_EXT = ".lck";
    protected static final Long INACTIVE_BOOKING = -1L;
    protected final Map<Long, UpdateContext> checkedOutMap = new HashMap<Long, UpdateContext>();
    protected Long fcount = 0L;
    protected IModelWriter fWriter = SerializeFactory.getWriter();
    protected Persistence.IResSerializationState fResState = null;

    public ChangeResController(Persistence.IResSerializationState aResState) {
        this.fResState = aResState;
    }

    public Long checkOut(EObject aEObject, String usrLoginID) throws ResourceHandlingException {
        if (aEObject == null || aEObject.eResource() == null || aEObject.eResource().getURI() == null) {
            StringBuilder sb = new StringBuilder("Unable to update/save Element");
            if (aEObject == null) {
                sb.append(", Element is null");
            } else if (aEObject.eResource() == null) {
                sb.append(", The Resource associated to the Element is null, Element: " + aEObject.toString());
            } else if (aEObject.eResource().getURI() == null) {
                sb.append(", The URI associated to the Element's Resource is null, Element: " + aEObject.toString());
            }
            throw new ResourceHandlingException(sb.toString());
        }
        if (this.fResState.isSerializationInactive(aEObject.eResource())) {
            return INACTIVE_BOOKING;
        }
        UpdateContext newContext = new UpdateContext(aEObject, usrLoginID);
        Collection<UpdateContext> checkedOutContextList = this.checkedOutMap.values();
        for (UpdateContext updateContext : checkedOutContextList) {
            if (!updateContext.equals(newContext)) continue;
            return updateContext.getBookingNum();
        }
        this.lockResource(aEObject.eResource(), usrLoginID);
        this.fcount = this.fcount + 1L;
        newContext.setBookingNum(this.fcount);
        this.checkedOutMap.put(this.fcount, newContext);
        Activator.fTracer.traceDebug("Checkout Num: " + this.fcount + ", Object: " + aEObject.toString());
        return this.fcount;
    }

    public void undoCheckOut(Long aBookingNumber) throws ResourceHandlingException {
        if (aBookingNumber.equals(INACTIVE_BOOKING)) {
            return;
        }
        UpdateContext context = this.checkedOutMap.remove(aBookingNumber);
        if (context != null) {
            this.unlockResource(context.getResource());
        } else {
            Activator.fTracer.traceError("UndoCheckOut failed: booking number is not active: " + aBookingNumber);
        }
    }

    public void checkIn(Long aBookingNumber) throws ResourceHandlingException {
        if (aBookingNumber == null) {
            Activator.fTracer.traceDebug("CheckIn with booking number set to null");
            return;
        }
        if (aBookingNumber.equals(INACTIVE_BOOKING)) {
            return;
        }
        UpdateContext context = this.checkedOutMap.remove(aBookingNumber);
        if (context != null) {
            Resource resource = context.getResource();
            this.fWriter.saveResource(resource);
            this.unlockResource(resource);
            Activator.fTracer.traceDebug("CheckIn: " + aBookingNumber);
        } else {
            Activator.fTracer.traceError("CheckIn failed: booking number is not active: " + aBookingNumber);
        }
    }

    protected void lockResource(Resource aResource, String usrLoginID) throws ResourceHandlingException {
        if (aResource == null || aResource.getURI() == null) {
            return;
        }
        URI resUri = aResource.getURI();
        File file = new File(URI.decode((String)resUri.devicePath()));
        if (!file.exists()) {
            throw new ResourceHandlingException("Not able to lock file: " + file.getAbsolutePath() + ". file does not exist");
        }
        file = new File(String.valueOf(resUri.toFileString()) + LOCK_EXT);
        if (file.exists()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                Activator.fTracer.traceDebug("Interrupter exception while waiting to lock resource");
            }
            if (file.exists()) {
                try {
                    StringBuilder sb;
                    block30: {
                        FileReader reader = new FileReader(file);
                        BufferedReader breader = new BufferedReader(reader);
                        sb = new StringBuilder();
                        try {
                            try {
                                String line = breader.readLine();
                                while (line != null) {
                                    sb.append(String.valueOf(line) + "\n");
                                    line = breader.readLine();
                                }
                            }
                            catch (IOException iOException) {
                                Activator.fTracer.traceDebug("IOException while reading lock file");
                                if (breader != null) {
                                    try {
                                        breader.close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                                break block30;
                            }
                        }
                        catch (Throwable throwable) {
                            if (breader != null) {
                                try {
                                    breader.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            throw throwable;
                        }
                        if (breader != null) {
                            try {
                                breader.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    throw new ResourceHandlingException("The Resource is locked: " + file.getAbsolutePath() + "\nLock Information:\n" + sb.toString());
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        try {
            file.createNewFile();
            FileSupportCommandFactory.getInstance().grantWritePermission(file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ResourceHandlingException(e);
        }
        PrintWriter writer = null;
        try {
            try {
                writer = new PrintWriter(file);
                writer.println("user: " + usrLoginID);
                writer.println("Date: " + new Date().toString());
            }
            catch (FileNotFoundException e) {
                throw new ResourceHandlingException(e);
            }
        }
        finally {
            writer.close();
        }
        Activator.fTracer.traceDebug("Checkout lock created " + file.getAbsolutePath());
    }

    protected void unlockResource(Resource aResource) throws ResourceHandlingException {
        if (aResource == null || aResource.getURI() == null) {
            return;
        }
        URI resUri = aResource.getURI();
        File file = new File(URI.decode((String)resUri.devicePath()));
        if (!file.exists()) {
            throw new ResourceHandlingException("Not able to unlock Resource file: " + file.getAbsolutePath() + ". File does not exist");
        }
        String fileStr = String.valueOf(resUri.toFileString()) + LOCK_EXT;
        file = new File(fileStr);
        if (file.exists()) {
            file.delete();
            Activator.fTracer.traceDebug("CheckIn, Lock file removed: " + fileStr);
        } else {
            StringBuilder message = new StringBuilder("Lock to remove does not exist");
            String absPath = file.getAbsolutePath();
            if (absPath != null) {
                message.append(": " + absPath);
            }
            Activator.fTracer.traceError(message.toString());
        }
    }

    static class UpdateContext {
        private String fUser;
        private EObject fEObject;
        private Long fBookingNum = null;

        UpdateContext(EObject aEObject, String aUser) {
            this.fEObject = aEObject;
            this.fUser = aUser;
        }

        public Resource getResource() {
            return this.fEObject.eResource();
        }

        public String getUser() {
            return this.fUser;
        }

        public Long getBookingNum() {
            return this.fBookingNum;
        }

        public void setBookingNum(Long aBookingNum) {
            this.fBookingNum = aBookingNum;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof UpdateContext) {
                URI tURI;
                URI otherURI;
                UpdateContext otherContext = (UpdateContext)o;
                Resource otherResource = otherContext.getResource();
                if (otherResource != this.fEObject.eResource() && !(otherURI = otherResource.getURI()).equals((Object)(tURI = this.fEObject.eResource().getURI()))) {
                    return false;
                }
                String oUserId = otherContext.getUser();
                if (oUserId.equals(this.fUser)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            String toHash = String.valueOf(this.fEObject.eResource().getURI().toString()) + this.fUser;
            return toHash.hashCode();
        }
    }
}

