/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.report.internal.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.reviews.r4e.report.internal.util.R4EReportString;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Popup {
    private static final String[] FWarningButtonLabels = new String[]{"Continue"};

    public static void info(Shell aParent, String aMessage) {
        MessageDialog.openInformation((Shell)aParent, (String)R4EReportString.getString("Popup.infoTitle"), (String)aMessage);
    }

    public static void error(final Shell aParent, final String aMessage) {
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)aParent, (String)R4EReportString.getString("Popup.errorTitle"), (String)aMessage);
            }
        };
        Display.getDefault().asyncExec(runnable);
    }

    public static void warning(Shell aParent, String aMessage) {
        MessageDialog.openWarning((Shell)aParent, (String)R4EReportString.getString("Popup.warningTitle"), (String)aMessage);
    }

    public static void displayMessage(Shell aParent, String aMessage) {
        MessageDialog.openInformation((Shell)aParent, (String)R4EReportString.getString("Popup.messageTitle"), (String)aMessage);
    }

    public static final int displayWarningMessageDialog(String aTitle, String aMessage) {
        MessageDialog dialog = new MessageDialog(null, aTitle, null, aMessage, 4, FWarningButtonLabels, 0);
        return dialog.open();
    }

    public static final int displayErrorDialogWithDetails(String aPluginID, String aDialogTitle, String aDialogMessage, String[] aStatusMessages, int aStatusType) {
        MultiStatus info = new MultiStatus(aPluginID, 1, aDialogMessage, null);
        String[] stringArray = aStatusMessages;
        int n = aStatusMessages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            info.add((IStatus)new Status(aStatusType, aPluginID, 1, message, null));
            ++n2;
        }
        return ErrorDialog.openError(null, (String)aDialogTitle, null, (IStatus)info);
    }

    public static void warningRunnable(final Shell aParent, final String aMessage) {
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDialog.openWarning((Shell)aParent, (String)R4EReportString.getString("Popup.warningTitle"), (String)aMessage);
            }
        };
        Display.getDefault().asyncExec(runnable);
    }
}

