/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.IEditableListListener;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditableListWidget {
    protected Composite fMainComposite = null;
    protected Table fMainTable = null;
    protected Button fAddButton = null;
    protected Button fRemoveButton = null;
    protected IEditableListListener fListener = null;
    protected int fInstanceId = 0;
    protected String[] fValues = null;
    Control fEditableControl = null;
    protected boolean fEnabled;

    public EditableListWidget(FormToolkit aToolkit, Composite aParent, Object aLayoutData, IEditableListListener aListener, int aInstanceId, Class<?> aEditableWidgetClass, String[] aEditableValues) {
        this.fMainComposite = aToolkit != null ? aToolkit.createComposite(aParent) : new Composite(aParent, 0);
        this.fMainComposite.setLayoutData(aLayoutData);
        this.fMainComposite.setLayout((Layout)new GridLayout(4, false));
        this.fListener = aListener;
        this.fInstanceId = aInstanceId;
        this.fValues = aEditableValues;
        this.createEditableListFromTable(aToolkit, aEditableWidgetClass);
    }

    public void dispose() {
        this.fMainTable.dispose();
        this.fMainComposite.dispose();
    }

    public void createEditableListFromTable(FormToolkit aToolkit, final Class<?> aEditableWidgetClass) {
        TableColumn tableColumn2;
        final Composite tableComposite = aToolkit != null ? aToolkit.createComposite(this.fMainComposite) : new Composite(this.fMainComposite, 0);
        this.fMainTable = aToolkit != null ? aToolkit.createTable(tableComposite, 67584) : new Table(tableComposite, 67584);
        GridData tableCompositeData = new GridData(4, 4, true, true);
        tableCompositeData.horizontalSpan = aEditableWidgetClass.equals(Date.class) || aEditableWidgetClass.equals(Label.class) ? 1 : 2;
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        final TableColumn tableColumn = new TableColumn(this.fMainTable, 0, 0);
        this.fMainTable.setLinesVisible(true);
        if (aEditableWidgetClass.equals(Date.class) || aEditableWidgetClass.equals(Label.class)) {
            this.fMainTable.setHeaderVisible(true);
            tableColumn2 = new TableColumn(this.fMainTable, 0, 1);
            if (aEditableWidgetClass.equals(Date.class)) {
                tableColumn.setText("Time spent (minutes)");
                tableColumn2.setText("Time of entry");
            } else if (aEditableWidgetClass.equals(Label.class)) {
                tableColumn.setText("Id: ");
                tableColumn2.setText("Email: ");
            }
            tableColumn.pack();
            tableColumn2.pack();
            tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(50, tableColumn.getWidth() * 2, true));
            tableColumnLayout.setColumnData((Widget)tableColumn2, (ColumnLayoutData)new ColumnWeightData(50, tableColumn.getWidth(), true));
        } else {
            tableColumn2 = null;
            tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(10, 100, true));
        }
        tableComposite.setLayoutData((Object)tableCompositeData);
        this.fMainComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle area = EditableListWidget.this.fMainTable.getClientArea();
                Point size = tableComposite.computeSize(-1, -1);
                ScrollBar vBar = EditableListWidget.this.fMainTable.getVerticalBar();
                int vBarWidth = vBar.getSize().x;
                int width = area.width - vBarWidth * 3;
                if (width < 0) {
                    return;
                }
                if (size.y > area.height + EditableListWidget.this.fMainTable.getHeaderHeight()) {
                    width -= vBarWidth;
                }
                if (tableColumn2 != null) {
                    tableColumn.setWidth(width / 2);
                    tableColumn2.setWidth(width - tableColumn.getWidth());
                } else {
                    tableColumn.setWidth(width);
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.fMainTable.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (EditableListWidget.this.fEnabled && EditableListWidget.this.fListener != null) {
                    TableItem[] items = EditableListWidget.this.fMainTable.getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].getText().trim().length() < 1) {
                            EditableListWidget.this.fMainTable.remove(i);
                        }
                        ++i;
                    }
                    EditableListWidget.this.fListener.itemsUpdated((Item[])EditableListWidget.this.fMainTable.getItems(), EditableListWidget.this.fInstanceId);
                }
            }
        });
        this.fMainTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (EditableListWidget.this.fListener != null) {
                    EditableListWidget.this.fListener.itemSelected((Item)EditableListWidget.this.fMainTable.getSelection()[0], EditableListWidget.this.fInstanceId);
                }
            }
        });
        Composite buttonsComposite = aToolkit != null ? aToolkit.createComposite(this.fMainComposite) : new Composite(this.fMainComposite, 0);
        buttonsComposite.setLayout((Layout)new GridLayout());
        buttonsComposite.setLayoutData((Object)new GridData(2, 128, false, false));
        this.fAddButton = aToolkit != null ? aToolkit.createButton(buttonsComposite, "Add", 0) : new Button(buttonsComposite, 0);
        this.fAddButton.setText("Add");
        if (aEditableWidgetClass.equals(CCombo.class) && (this.fValues == null || this.fValues.length == 0)) {
            this.fAddButton.setEnabled(false);
        }
        this.fRemoveButton = aToolkit != null ? aToolkit.createButton(buttonsComposite, "Remove", 0) : new Button(buttonsComposite, 0);
        this.fRemoveButton.setText("Remove");
        if (this.fMainTable.getItemCount() == 0) {
            this.fRemoveButton.setEnabled(false);
        } else {
            this.fRemoveButton.setEnabled(true);
        }
        this.fAddButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fAddButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (aEditableWidgetClass.equals(Label.class)) {
                    List<R4EParticipant> participants = UIUtils.getAssignParticipants();
                    TableItem newItem = null;
                    for (R4EParticipant participant : participants) {
                        newItem = null;
                        String[] tableStrs = new String[]{participant.getId(), participant.getEmail()};
                        TableItem[] tableItemArray = EditableListWidget.this.fMainTable.getItems();
                        int n = tableItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem item = tableItemArray[n2];
                            if (item.getText(0).equals(tableStrs[0])) {
                                newItem = item;
                            }
                            ++n2;
                        }
                        if (newItem == null) {
                            newItem = new TableItem(EditableListWidget.this.fMainTable, 0);
                        }
                        EditableListWidget.this.fMainTable.showItem(newItem);
                        newItem.setText(tableStrs);
                    }
                    if (newItem != null) {
                        EditableListWidget.this.fMainTable.showItem(newItem);
                    }
                    if (EditableListWidget.this.fListener != null) {
                        EditableListWidget.this.fListener.itemsUpdated((Item[])EditableListWidget.this.fMainTable.getItems(), EditableListWidget.this.fInstanceId);
                    }
                    return;
                }
                final TableItem newItem = new TableItem(EditableListWidget.this.fMainTable, 0);
                EditableListWidget.this.fMainTable.showItem(newItem);
                if (aEditableWidgetClass.equals(Text.class)) {
                    EditableListWidget.this.fEditableControl = new Text((Composite)EditableListWidget.this.fMainTable, 2052);
                    ((Text)EditableListWidget.this.fEditableControl).addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent me) {
                            newItem.setText(((Text)(this).EditableListWidget.this.fEditableControl).getText());
                        }
                    });
                    ((Text)EditableListWidget.this.fEditableControl).addKeyListener(new KeyListener(){

                        public void keyReleased(KeyEvent ke) {
                            if (ke.keyCode == 13) {
                                return;
                            }
                        }

                        public void keyPressed(KeyEvent ke) {
                        }
                    });
                } else if (aEditableWidgetClass.equals(CCombo.class)) {
                    TableItem[] currentItems;
                    EditableListWidget.this.fEditableControl = new CCombo((Composite)EditableListWidget.this.fMainTable, 2056);
                    ArrayList<String> currentValues = new ArrayList<String>();
                    String[] stringArray = EditableListWidget.this.fValues;
                    int n = EditableListWidget.this.fValues.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String currentValue = stringArray[n3];
                        currentValues.add(currentValue);
                        ++n3;
                    }
                    TableItem[] tableItemArray = currentItems = EditableListWidget.this.fMainTable.getItems();
                    int n4 = currentItems.length;
                    n = 0;
                    while (n < n4) {
                        TableItem currentItem = tableItemArray[n];
                        if (currentValues.contains(currentItem.getText())) {
                            currentValues.remove(currentItem.getText());
                        }
                        ++n;
                    }
                    ((CCombo)EditableListWidget.this.fEditableControl).setItems(currentValues.toArray(new String[currentValues.size()]));
                    ((CCombo)EditableListWidget.this.fEditableControl).addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent me) {
                            newItem.setText(((CCombo)(this).EditableListWidget.this.fEditableControl).getText());
                        }
                    });
                } else if (aEditableWidgetClass.equals(Date.class)) {
                    EditableListWidget.this.fEditableControl = new Text((Composite)EditableListWidget.this.fMainTable, 0);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
                    String[] data = new String[]{((Text)EditableListWidget.this.fEditableControl).getText(), dateFormat.format(Calendar.getInstance().getTime())};
                    newItem.setText(data);
                    ((Text)EditableListWidget.this.fEditableControl).addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent me) {
                            String newText;
                            block2: {
                                newText = ((Text)(this).EditableListWidget.this.fEditableControl).getText();
                                try {
                                    Integer.valueOf(newText);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (newText.length() <= 0) break block2;
                                    newText = newText.substring(0, newText.length() - 1);
                                    ((Text)(this).EditableListWidget.this.fEditableControl).setText(newText);
                                    ((Text)(this).EditableListWidget.this.fEditableControl).setSelection(newText.length());
                                }
                            }
                            newItem.setText(0, newText);
                        }
                    });
                } else {
                    return;
                }
                EditableListWidget.this.fEditableControl.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent fe) {
                        ((Control)fe.getSource()).dispose();
                        if ((this).EditableListWidget.this.fListener != null) {
                            TableItem[] items = (this).EditableListWidget.this.fMainTable.getItems();
                            int numColumns = (this).EditableListWidget.this.fMainTable.getColumnCount();
                            boolean isSameItem = false;
                            int i = 0;
                            while (i < items.length) {
                                if (items[i].getText().trim().length() < 1) {
                                    (this).EditableListWidget.this.fMainTable.remove(i);
                                    return;
                                }
                                ++i;
                            }
                            if (items.length > 1) {
                                i = 0;
                                while (i < items.length) {
                                    int j = i + 1;
                                    while (j < items.length) {
                                        isSameItem = true;
                                        int k = 0;
                                        while (k < numColumns) {
                                            if (!items[i].getText(k).equals(items[j].getText(k))) {
                                                isSameItem = false;
                                                break;
                                            }
                                            ++k;
                                        }
                                        if (isSameItem) {
                                            (this).EditableListWidget.this.fMainTable.remove(j);
                                            return;
                                        }
                                        ++j;
                                    }
                                    ++i;
                                }
                            }
                            (this).EditableListWidget.this.fListener.itemsUpdated((Item[])(this).EditableListWidget.this.fMainTable.getItems(), (this).EditableListWidget.this.fInstanceId);
                        }
                    }

                    public void focusGained(FocusEvent fe) {
                    }
                });
                EditableListWidget.this.fEditableControl.setFocus();
                TableEditor editor = new TableEditor(EditableListWidget.this.fMainTable);
                editor.grabHorizontal = true;
                editor.grabVertical = true;
                editor.setEditor(EditableListWidget.this.fEditableControl, newItem, 0);
                EditableListWidget.this.fRemoveButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fRemoveButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int numItems = EditableListWidget.this.fMainTable.getItemCount();
                if (numItems > 0) {
                    Control[] controls = EditableListWidget.this.fMainTable.getChildren();
                    int firstControlIndex = numItems - controls.length;
                    int tableItemIndex = EditableListWidget.this.fMainTable.getSelectionIndex();
                    if (-1 == tableItemIndex) {
                        tableItemIndex = numItems - 1;
                    }
                    if (tableItemIndex >= firstControlIndex) {
                        controls[tableItemIndex - firstControlIndex].dispose();
                    }
                    EditableListWidget.this.fMainTable.getItem(tableItemIndex).dispose();
                }
                if (EditableListWidget.this.fMainTable.getItemCount() == 0) {
                    EditableListWidget.this.fRemoveButton.setEnabled(false);
                } else {
                    EditableListWidget.this.fRemoveButton.setEnabled(true);
                }
                if (EditableListWidget.this.fListener != null) {
                    EditableListWidget.this.fListener.itemsUpdated((Item[])EditableListWidget.this.fMainTable.getItems(), EditableListWidget.this.fInstanceId);
                }
                EditableListWidget.this.fMainTable.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void removeAll() {
        this.fMainTable.removeAll();
    }

    public Item addItem() {
        return new TableItem(this.fMainTable, 0);
    }

    public Item getItem(int aIndex) {
        return this.fMainTable.getItem(aIndex);
    }

    public Item getSelectedItem() {
        if (this.fMainTable.getSelection().length == 0) {
            return null;
        }
        return this.fMainTable.getSelection()[0];
    }

    public Item[] getItems() {
        return this.fMainTable.getItems();
    }

    public int getItemCount() {
        return this.fMainTable.getItemCount();
    }

    public void setEnabled(boolean aEnabled) {
        this.fEnabled = aEnabled;
        TableItem[] tableItemArray = this.fMainTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (aEnabled) {
                item.setForeground(UIUtils.ENABLED_FONT_COLOR);
            } else {
                item.setForeground(UIUtils.DISABLED_FONT_COLOR);
            }
            ++n2;
        }
        if (!aEnabled) {
            this.fAddButton.setEnabled(aEnabled);
            this.fRemoveButton.setEnabled(aEnabled);
        } else {
            this.updateButtons();
        }
    }

    public void setVisible(boolean aVisible) {
        this.fMainComposite.setVisible(aVisible);
        this.fMainTable.setVisible(aVisible);
        this.fAddButton.setVisible(aVisible);
        this.fRemoveButton.setVisible(aVisible);
    }

    public Composite getComposite() {
        return this.fMainComposite;
    }

    public void setEditableValues(String[] aValues) {
        this.fValues = aValues;
        if (this.fValues == null || this.fValues.length == 0) {
            this.fAddButton.setEnabled(false);
        } else {
            this.fAddButton.setEnabled(true);
        }
        if (this.fMainTable.getItemCount() == 0) {
            this.fRemoveButton.setEnabled(false);
        } else {
            this.fRemoveButton.setEnabled(true);
        }
    }

    public void setTableHeader(int aIndex, String aText) {
        try {
            TableColumn column = this.fMainTable.getColumn(aIndex);
            column.setText(aText);
            this.updateTable();
        }
        catch (IllegalArgumentException e) {
            R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logWarning("Exception: " + e.toString(), e);
        }
    }

    public void setToolTipText(String aTooltip) {
        this.fMainComposite.setToolTipText(aTooltip);
    }

    public void updateButtons() {
        if (this.fMainTable.getItemCount() == 0) {
            this.fRemoveButton.setEnabled(false);
        } else {
            this.fRemoveButton.setEnabled(true);
        }
        this.fAddButton.setEnabled(true);
    }

    public void updateTable() {
        TableColumn[] tableColumnArray = this.fMainTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    public void remove(String removeStr) {
        TableItem[] tableItemArray = this.fMainTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText().equals(removeStr)) {
                this.fMainTable.setSelection(item);
            }
            ++n2;
        }
        this.fRemoveButton.notifyListeners(13, null);
    }

    public void add(String addStr) {
        this.fAddButton.notifyListeners(13, null);
        if (this.fEditableControl != null) {
            if (this.fEditableControl instanceof Text) {
                ((Text)this.fEditableControl).setText(addStr);
            } else if (this.fEditableControl instanceof CCombo) {
                String[] items = ((CCombo)this.fEditableControl).getItems();
                int index = 0;
                while (index < items.length) {
                    if (items[index].equals(addStr)) {
                        ((CCombo)this.fEditableControl).select(index);
                    }
                    ++index;
                }
            }
        }
    }
}

