/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDelta;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.R4ETextPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContentsContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUISelection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;

public class R4EUISelectionContainer
extends R4EUIContentsContainer {
    public static final String SELECTION_CONTAINER_ICON_FILE = "icons/obj16/selcont_obj.gif";

    public R4EUISelectionContainer(IR4EUIModelElement aParent, String aName) {
        super(aParent, aName);
    }

    public String getImageLocation() {
        return SELECTION_CONTAINER_ICON_FILE;
    }

    public R4EUISelection createSelection(R4EUITextPosition aUiPosition) throws ResourceHandlingException, OutOfSyncException {
        R4EDelta selection = R4EUIModelController.FModelExt.createR4EDelta(((R4EUIFileContext)this.getParent()).getFileContext());
        R4ETextPosition position = R4EUIModelController.FModelExt.createR4ETextPosition(R4EUIModelController.FModelExt.createR4ETargetTextContent(selection));
        aUiPosition.setPositionInModel((R4EPosition)position);
        R4EUISelection uiSelection = new R4EUISelection(this, selection, aUiPosition);
        this.addChildren(uiSelection);
        EList parentAssignedParticipants = ((R4EUIFileContext)this.getParent()).getFileContext().getAssignedTo();
        ArrayList<R4EParticipant> participantsToAssign = new ArrayList<R4EParticipant>();
        for (String parentAssignedParticipant : parentAssignedParticipants) {
            R4EParticipant participant = R4EUIModelController.getActiveReview().getParticipant(parentAssignedParticipant, false);
            if (participant == null) continue;
            participantsToAssign.add(participant);
        }
        uiSelection.addAssignees(participantsToAssign);
        return uiSelection;
    }

    public void open() {
        EList selections = ((R4EUIFileContext)this.getParent()).getFileContext().getDeltas();
        if (selections != null) {
            R4EUITextPosition position = null;
            R4EUISelection newSelection = null;
            int selectionsSize = selections.size();
            R4EDelta selection = null;
            int i = 0;
            while (i < selectionsSize) {
                selection = (R4EDelta)selections.get(i);
                if (selection.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                    position = new R4EUITextPosition(((R4EDelta)selections.get(i)).getTarget().getLocation());
                    newSelection = new R4EUISelection(this, (R4EDelta)selections.get(i), position);
                    this.addChildren(newSelection);
                }
                ++i;
            }
        }
        this.fOpen = true;
    }
}

