/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IParticipantInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIParticipant;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIParticipantContainer
extends R4EUIModelElement {
    public static final String PARTICIPANT_CONTAINER_ICON_FILE = "icons/obj16/partcont_obj.png";
    private static final String NEW_CHILD_ELEMENT_COMMAND_NAME = "New Participants...";
    private static final String NEW_CHILD_ELEMENT_COMMAND_TOOLTIP = "Add a New Participant to the Current Review";
    private final List<R4EUIParticipant> fParticipants;

    public R4EUIParticipantContainer(IR4EUIModelElement aParent, String aName) {
        super(aParent, aName);
        this.fReadOnly = aParent.isReadOnly();
        this.fParticipants = new ArrayList<R4EUIParticipant>();
    }

    @Override
    public String getImageLocation() {
        return PARTICIPANT_CONTAINER_ICON_FILE;
    }

    @Override
    public List<ReviewComponent> createChildModelDataElement() {
        ArrayList<ReviewComponent> tempParticipants = new ArrayList<ReviewComponent>();
        IParticipantInputDialog dialog = R4EUIDialogFactory.getInstance().getParticipantInputDialog(true);
        int result = dialog.open();
        if (result == 0) {
            for (R4EParticipant participant : dialog.getParticipants()) {
                tempParticipants.add((ReviewComponent)participant);
            }
        }
        R4EUIDialogFactory.getInstance().removeParticipantInputDialog();
        return tempParticipants;
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        return this.fParticipants.toArray(new R4EUIParticipant[this.fParticipants.size()]);
    }

    public List<R4EUIParticipant> getParticipantList() {
        return this.fParticipants;
    }

    public R4EUIParticipant getParticipant(R4EParticipant aParticipant) {
        for (R4EUIParticipant participant : this.fParticipants) {
            if (!participant.getParticipant().equals(aParticipant)) continue;
            return participant;
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return this.fParticipants.size() > 0;
    }

    @Override
    public void close() {
        R4EUIParticipant participant = null;
        int participantsSize = this.fParticipants.size();
        int i = 0;
        while (i < participantsSize) {
            participant = this.fParticipants.get(i);
            participant.close();
            ++i;
        }
        this.fParticipants.clear();
        this.fOpen = false;
    }

    @Override
    public void open() {
        List<R4EParticipant> participants = ((R4EUIReviewBasic)this.getParent()).getParticipants();
        if (participants != null) {
            int participantsSize = participants.size();
            int i = 0;
            while (i < participantsSize) {
                if (participants.get(i).isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                    this.addChildren(new R4EUIParticipant(this, participants.get(i), ((R4EUIReviewBasic)this.getParent()).getReview().getType()));
                }
                ++i;
            }
        }
        this.fOpen = true;
    }

    @Override
    public boolean isEnabled() {
        return this.getParent().isEnabled();
    }

    public void setReadOnly(boolean aReadOnly) {
        this.fReadOnly = aReadOnly;
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        this.fParticipants.add((R4EUIParticipant)aChildToAdd);
        ((R4EUIParticipant)aChildToAdd).setParticipantDetails();
    }

    @Override
    public IR4EUIModelElement createChildren(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        R4EUIParticipant addedChild = null;
        R4EParticipant participant = ((R4EUIReviewBasic)this.getParent()).getParticipant(((R4EParticipant)aModelComponent).getId(), true);
        if (participant != null) {
            addedChild = this.getParticipant(participant);
            addedChild.setModelData(aModelComponent);
        }
        return addedChild;
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        R4EUIParticipant removedElement = this.fParticipants.get(this.fParticipants.indexOf(aChildToRemove));
        R4EParticipant modelParticipant = removedElement.getParticipant();
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelParticipant, R4EUIModelController.getReviewer());
        modelParticipant.setEnabled(false);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            this.fParticipants.remove(removedElement);
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        for (R4EUIParticipant participant : this.fParticipants) {
            this.removeChildren(participant, aFileRemove);
        }
    }

    @Override
    public boolean isNewChildElementCmd() {
        R4EReviewPhase phase;
        return !this.isReadOnly() && this.getParent().isEnabled() && !(phase = ((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState()).equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public String getNewChildElementCmdName() {
        return NEW_CHILD_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getNewChildElementCmdTooltip() {
        return NEW_CHILD_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isShowPropertiesCmd() {
        return false;
    }
}

