/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final String PI_AUTHENTICATION_SERVLETS = "org.eclipse.orion.server.authentication";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
    private static volatile BundleContext bundleContext;
    public static Activator singleton;

    public static Activator getDefault() {
        return singleton;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public void start(BundleContext context) throws Exception {
        singleton = this;
        bundleContext = context;
        AuthenticationMetaStoreJob job = new AuthenticationMetaStoreJob();
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        bundleContext = null;
    }

    class AuthenticationMetaStoreJob
    extends Job {
        public AuthenticationMetaStoreJob() {
            super("AuthenticationMetaStoreJob");
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IMetaStore metastore = OrionConfiguration.getMetaStore();
                if (metastore == null) {
                    String msg = "Error starting Orion authentication service. Server metastore is unavailable! Checking again in 5 seconds";
                    logger.error(msg);
                    this.schedule(5000L);
                    return Status.OK_STATUS;
                }
                ArrayList<String> keys = new ArrayList<String>();
                keys.add("Email");
                keys.add("OAuth");
                keys.add("OpenId");
                metastore.registerUserProperties(keys);
                logger.info("Started Orion server authentication successfully.");
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                String msg = "Error starting Orion server authentication service.";
                logger.error(msg, (Throwable)e);
                return new Status(4, Activator.PI_AUTHENTICATION_SERVLETS, msg, (Throwable)e);
            }
        }
    }
}

