/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.AuthorRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitterRevFilter;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.revwalk.filter.MessageRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.revwalk.filter.SkipRevFilter;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.orion.server.git.jobs.SHA1RevFilter;

public class LogCommand
extends GitCommand<Iterable<RevCommit>> {
    private RevWalk walk;
    private boolean startSpecified = false;
    private final List<PathFilter> pathFilters = new ArrayList<PathFilter>();
    private int maxCount = -1;
    private int skip = -1;
    private RevFilter msgFilter;
    private RevFilter authorFilter;
    private RevFilter committerFilter;
    private RevFilter sha1Filter;
    private RevFilter dateFilter;

    protected LogCommand(Repository repo) {
        super(repo);
        this.walk = new RevWalk(repo);
    }

    public Iterable<RevCommit> call() throws GitAPIException, NoHeadException {
        this.checkCallable();
        ArrayList<RevFilter> filters = new ArrayList<RevFilter>();
        if (this.pathFilters.size() > 0) {
            this.walk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.create(this.pathFilters), (TreeFilter)TreeFilter.ANY_DIFF));
        }
        if (this.msgFilter != null) {
            filters.add(this.msgFilter);
        }
        if (this.authorFilter != null) {
            filters.add(this.authorFilter);
        }
        if (this.committerFilter != null) {
            filters.add(this.committerFilter);
        }
        if (this.sha1Filter != null) {
            filters.add(this.sha1Filter);
        }
        if (this.dateFilter != null) {
            filters.add(this.dateFilter);
        }
        if (this.skip > -1) {
            filters.add(SkipRevFilter.create((int)this.skip));
        }
        if (this.maxCount > -1) {
            filters.add(MaxCountRevFilter.create((int)this.maxCount));
        }
        RevFilter filter = null;
        if (filters.size() > 1) {
            filter = AndRevFilter.create(filters);
        } else if (filters.size() == 1) {
            filter = (RevFilter)filters.get(0);
        }
        if (filter != null) {
            this.walk.setRevFilter(filter);
        }
        if (!this.startSpecified) {
            try {
                ObjectId headId = this.repo.resolve("HEAD");
                if (headId == null) {
                    throw new NoHeadException(JGitText.get().noHEADExistsAndNoExplicitStartingRevisionWasSpecified);
                }
                this.add((AnyObjectId)headId);
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().anExceptionOccurredWhileTryingToAddTheIdOfHEAD, (Throwable)e);
            }
        }
        this.setCallable(false);
        return this.walk;
    }

    public LogCommand add(AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException {
        return this.add(true, start);
    }

    public LogCommand not(AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException {
        return this.add(false, start);
    }

    public LogCommand addRange(AnyObjectId since, AnyObjectId until) throws MissingObjectException, IncorrectObjectTypeException {
        return this.not(since).add(until);
    }

    public LogCommand all() throws IOException {
        Map refs = this.getRepository().getRefDatabase().getRefs("");
        for (Ref ref : refs.values()) {
            ObjectId objectId;
            if (!ref.isPeeled()) {
                ref = this.getRepository().peel(ref);
            }
            if ((objectId = ref.getPeeledObjectId()) == null) {
                objectId = ref.getObjectId();
            }
            RevCommit commit = null;
            try {
                commit = this.walk.parseCommit((AnyObjectId)objectId);
            }
            catch (MissingObjectException missingObjectException) {
            }
            catch (IncorrectObjectTypeException incorrectObjectTypeException) {}
            if (commit == null) continue;
            this.add((AnyObjectId)commit);
        }
        return this;
    }

    public LogCommand addPath(String path) {
        this.checkCallable();
        this.pathFilters.add(PathFilter.create((String)path));
        return this;
    }

    public LogCommand setMessageFilter(String filter) {
        this.checkCallable();
        this.msgFilter = MessageRevFilter.create((String)filter);
        return this;
    }

    public LogCommand setAuthFilter(String filter) {
        this.checkCallable();
        this.authorFilter = AuthorRevFilter.create((String)filter);
        return this;
    }

    public LogCommand setCommitterFilter(String filter) {
        this.checkCallable();
        this.committerFilter = CommitterRevFilter.create((String)filter);
        return this;
    }

    public LogCommand setSHA1Filter(String filter) {
        this.checkCallable();
        this.sha1Filter = SHA1RevFilter.create(filter);
        return this;
    }

    public LogCommand setDateFilter(String fromDate, String toDate) {
        this.checkCallable();
        try {
            Long toD;
            if (fromDate != null) {
                long fromD = Long.parseLong(fromDate);
                if (toDate != null) {
                    long toD2 = Long.parseLong(toDate);
                    this.dateFilter = CommitTimeRevFilter.between((long)fromD, (long)toD2);
                } else {
                    this.dateFilter = CommitTimeRevFilter.after((long)fromD);
                }
            } else if (toDate != null && (toD = Long.valueOf(Long.parseLong(toDate))) != null) {
                this.dateFilter = CommitTimeRevFilter.before((long)toD);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return this;
    }

    public LogCommand setSkip(int skip) {
        this.checkCallable();
        this.skip = skip;
        return this;
    }

    public LogCommand setMaxCount(int maxCount) {
        this.checkCallable();
        this.maxCount = maxCount;
        return this;
    }

    private LogCommand add(boolean include, AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException, JGitInternalException {
        this.checkCallable();
        try {
            if (include) {
                this.walk.markStart(this.walk.lookupCommit(start));
                this.startSpecified = true;
            } else {
                this.walk.markUninteresting(this.walk.lookupCommit(start));
            }
            return this;
        }
        catch (MissingObjectException e) {
            throw e;
        }
        catch (IncorrectObjectTypeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringAddingOfOptionToALogCommand, start), (Throwable)e);
        }
    }
}

