/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.ITriggerPointManager;
import org.eclipse.ui.internal.activities.Persistence;
import org.eclipse.ui.internal.activities.ws.AbstractTriggerPoint;
import org.eclipse.ui.internal.activities.ws.RegistryTriggerPoint;

public class TriggerPointManager
implements ITriggerPointManager,
IExtensionChangeHandler {
    private HashMap triggerMap = new HashMap();

    public TriggerPointManager() {
        IExtension[] extensions;
        this.triggerMap.put("org.eclipse.ui.internal.UnknownTriggerPoint", new AbstractTriggerPoint(){

            @Override
            public String getId() {
                return "org.eclipse.ui.internal.UnknownTriggerPoint";
            }

            @Override
            public String getStringHint(String key) {
                if ("interactive".equals(key)) {
                    return Boolean.TRUE.toString();
                }
                return null;
            }

            @Override
            public boolean getBooleanHint(String key) {
                return "interactive".equals(key);
            }
        });
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
        IExtensionPoint point = this.getExtensionPointFilter();
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.addExtension(tracker, extension);
            ++n2;
        }
    }

    @Override
    public ITriggerPoint getTriggerPoint(String id) {
        return (ITriggerPoint)this.triggerMap.get(id);
    }

    @Override
    public Set getDefinedTriggerPointIds() {
        return this.triggerMap.entrySet();
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof RegistryTriggerPoint) {
                this.triggerMap.remove(((RegistryTriggerPoint)object).getId());
            }
            ++n2;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("triggerPoint")) {
                String id = element.getAttribute("id");
                if (id == null) {
                    Persistence.log(element, "Invalid trigger point", "missing a unique identifier");
                } else {
                    RegistryTriggerPoint triggerPoint = new RegistryTriggerPoint(id, element);
                    this.triggerMap.put(id, triggerPoint);
                    tracker.registerObject(extension, (Object)triggerPoint, 2);
                }
            }
            ++n2;
        }
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "activitySupport");
    }
}

