/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.internal.preferences.legacy.PreferenceForwarder;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.util.tracker.ServiceTracker;

public abstract class Plugin
implements BundleActivator {
    public static final String PLUGIN_PREFERENCE_SCOPE = "instance";
    private Bundle bundle;
    private volatile IPath stateLocation;
    private boolean debug = false;
    private ServiceTracker<DebugOptions, DebugOptions> debugTracker = null;
    public static final String PREFERENCES_DEFAULT_OVERRIDE_BASE_NAME = "preferences";
    public static final String PREFERENCES_DEFAULT_OVERRIDE_FILE_NAME = "preferences.ini";
    @Deprecated
    private Preferences preferences = null;

    @Deprecated
    public final URL find(IPath path) {
        return FileLocator.find((Bundle)this.getBundle(), (IPath)path, null);
    }

    @Deprecated
    public final URL find(IPath path, Map<String, String> override) {
        return FileLocator.find((Bundle)this.getBundle(), (IPath)path, override);
    }

    public final ILog getLog() {
        return ILog.of(this.getBundle());
    }

    public final IPath getStateLocation() throws IllegalStateException {
        if (this.stateLocation == null) {
            this.stateLocation = InternalPlatform.getDefault().getStateLocation(this.getBundle(), true);
        }
        return this.stateLocation;
    }

    @Deprecated
    public final Preferences getPluginPreferences() {
        Bundle bundleCopy = this.getBundle();
        if (this.preferences != null) {
            if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
                InternalPlatform.message("Plugin preferences already loaded for: " + bundleCopy.getSymbolicName());
            }
            return this.preferences;
        }
        if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
            InternalPlatform.message("Loading preferences for plugin: " + bundleCopy.getSymbolicName());
        }
        Preferences[] preferencesCopy = new Preferences[1];
        Runnable innerCall = () -> {
            PreferenceForwarder preferenceForwarder = new PreferenceForwarder(this, bundleCopy.getSymbolicName());
        };
        innerCall.run();
        this.preferences = preferencesCopy[0];
        return this.preferences;
    }

    @Deprecated
    public final void savePluginPreferences() {
        if (InternalPlatform.getDefault().isRunning()) {
            Location instance = InternalPlatform.getDefault().getInstanceLocation();
            if (instance == null || !instance.isSet()) {
                return;
            }
            this.getPluginPreferences();
            Preferences preferencesCopy = this.preferences;
            Runnable innerCall = () -> {
                try {
                    ((PreferenceForwarder)preferencesCopy).flush();
                }
                catch (BackingStoreException e) {
                    Status status = new Status(4, "org.eclipse.core.runtime", 4, Messages.preferences_saveProblems, (Throwable)e);
                    RuntimeLog.log((IStatus)status);
                }
            };
            innerCall.run();
        }
    }

    @Deprecated
    protected void initializeDefaultPluginPreferences() {
    }

    @Deprecated
    public final void internalInitializeDefaultPluginPreferences() {
        this.initializeDefaultPluginPreferences();
    }

    public boolean isDebugging() {
        Bundle debugBundle = this.getBundle();
        if (debugBundle == null) {
            return this.debug;
        }
        String key = debugBundle.getSymbolicName() + "/debug";
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions == null) {
            return this.debug;
        }
        return debugOptions.isDebugEnabled() ? InternalPlatform.getDefault().getBooleanOption(key, false) : false;
    }

    @Deprecated
    public final InputStream openStream(IPath file) throws IOException {
        return FileLocator.openStream((Bundle)this.getBundle(), (IPath)file, (boolean)false);
    }

    @Deprecated
    public final InputStream openStream(IPath file, boolean substituteArgs) throws IOException {
        return FileLocator.openStream((Bundle)this.getBundle(), (IPath)file, (boolean)substituteArgs);
    }

    public void setDebugging(boolean value) {
        Bundle debugBundle = this.getBundle();
        if (debugBundle == null) {
            this.debug = value;
            return;
        }
        String key = debugBundle.getSymbolicName() + "/debug";
        DebugOptions options = this.getDebugOptions();
        if (options == null) {
            this.debug = value;
        } else {
            if (!options.isDebugEnabled()) {
                options.setDebugEnabled(true);
            }
            options.setOption(key, value ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        }
    }

    private DebugOptions getDebugOptions() {
        Bundle debugBundle = this.getBundle();
        if (debugBundle == null) {
            return null;
        }
        if (this.debugTracker == null) {
            BundleContext context = debugBundle.getBundleContext();
            if (context == null) {
                return null;
            }
            this.debugTracker = new ServiceTracker(context, DebugOptions.class.getName(), null);
            this.debugTracker.open();
        }
        return (DebugOptions)this.debugTracker.getService();
    }

    @Deprecated
    public void shutdown() throws CoreException {
    }

    @Deprecated
    public void startup() throws CoreException {
    }

    public String toString() {
        Bundle myBundle = this.getBundle();
        if (myBundle == null) {
            return "";
        }
        String name = myBundle.getSymbolicName();
        return name == null ? String.valueOf(myBundle.getBundleId()) : name;
    }

    public void start(BundleContext context) throws Exception {
        this.bundle = context.getBundle();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
    }

    public final Bundle getBundle() {
        if (this.bundle != null) {
            return this.bundle;
        }
        return FrameworkUtil.getBundle(this.getClass());
    }
}

