/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.internal.copy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ViewContentProvider
implements ITreeContentProvider {
    private static final String CATEGORY_TAG = "categoryTag:";
    private static final int CATEGORY_TAG_LENGTH = "categoryTag:".length();
    private Map<Object, Object[]> childMap = new HashMap<Object, Object[]>();
    private MApplication application;

    public ViewContentProvider(MApplication application) {
        this.application = application;
    }

    public void dispose() {
        this.childMap.clear();
    }

    public Object getParent(Object element) {
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.childMap.clear();
        this.application = (MApplication)newInput;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof MApplication) {
            return true;
        }
        return element instanceof String;
    }

    public Object[] getChildren(Object element) {
        Object[] children = this.childMap.get(element);
        if (children == null) {
            children = this.createChildren(element);
            this.childMap.put(element, children);
        }
        return children;
    }

    private Object[] createChildren(Object element) {
        if (element instanceof MApplication) {
            List descriptors = ((MApplication)element).getDescriptors();
            HashSet<String> categoryTags = new HashSet<String>();
            HashSet<MPartDescriptor> noCategoryDescriptors = new HashSet<MPartDescriptor>();
            for (MPartDescriptor descriptor : descriptors) {
                List tags = descriptor.getTags();
                String category = null;
                boolean isView = false;
                for (String tag : tags) {
                    if (tag.equals("View")) {
                        isView = true;
                        continue;
                    }
                    if (!tag.startsWith(CATEGORY_TAG)) continue;
                    category = tag.substring(CATEGORY_TAG_LENGTH);
                }
                if (!isView) continue;
                if (category != null) {
                    categoryTags.add(category);
                    continue;
                }
                noCategoryDescriptors.add(descriptor);
            }
            HashSet<String> combinedTopElements = new HashSet<String>();
            combinedTopElements.addAll(categoryTags);
            combinedTopElements.addAll(noCategoryDescriptors);
            return combinedTopElements.toArray();
        }
        if (element instanceof String) {
            List descriptors = this.application.getDescriptors();
            HashSet<MPartDescriptor> categoryDescriptors = new HashSet<MPartDescriptor>();
            for (MPartDescriptor descriptor : descriptors) {
                List tags = descriptor.getTags();
                for (String tag : tags) {
                    String categoryTag;
                    if (!tag.startsWith(CATEGORY_TAG) || !element.equals(categoryTag = tag.substring(CATEGORY_TAG_LENGTH))) continue;
                    categoryDescriptors.add(descriptor);
                }
            }
            return categoryDescriptors.toArray();
        }
        return new Object[0];
    }
}

