/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.util.Map;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;

public class TouchpointInstruction
implements ITouchpointInstruction {
    private final String body;
    private final String importAttribute;

    public static String encodeAction(String actionName, Map<String, String> parameters) {
        StringBuilder result = new StringBuilder(actionName);
        result.append('(');
        boolean first = true;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            result.append(entry.getKey());
            result.append(':');
            TouchpointInstruction.appendEncoded(result, entry.getValue());
        }
        result.append(')').append(';');
        return result.toString();
    }

    private static void appendEncoded(StringBuilder buf, String value) {
        char[] chars;
        char[] cArray = chars = value.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '$': 
                case ',': 
                case ':': 
                case ';': 
                case '{': 
                case '}': {
                    buf.append("${#").append(Integer.toString(c)).append('}');
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++n2;
        }
    }

    public TouchpointInstruction(String body, String importAttribute) {
        this.body = body;
        this.importAttribute = importAttribute;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ITouchpointInstruction)) {
            return false;
        }
        ITouchpointInstruction other = (ITouchpointInstruction)obj;
        if (this.body == null ? other.getBody() != null : !this.body.equals(other.getBody())) {
            return false;
        }
        return !(this.importAttribute == null ? other.getImportAttribute() != null : !this.importAttribute.equals(other.getImportAttribute()));
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public String getImportAttribute() {
        return this.importAttribute;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        result = 31 * result + (this.importAttribute == null ? 0 : this.importAttribute.hashCode());
        return result;
    }

    public String toString() {
        return "Instruction[" + this.body + "," + this.importAttribute + "]";
    }
}

