/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPPublicKeyStore;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.BasePackage;

public class PGPKeyResourceImpl
extends ResourceImpl {
    private Set<PGPPublicKey> publicKeys;

    public PGPKeyResourceImpl(URI uri) {
        super(uri);
    }

    public Set<PGPPublicKey> getPublicKeys() {
        return this.publicKeys;
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        String value = new String(inputStream.readAllBytes(), StandardCharsets.US_ASCII);
        this.publicKeys = PGPPublicKeyStore.readPublicKeys((String)value);
        Annotation annotation = BaseFactory.eINSTANCE.createAnnotation();
        annotation.setSource(value);
        this.getContents().add((Object)annotation);
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        String value = this.getValue();
        if (value != null) {
            outputStream.write(value.getBytes(StandardCharsets.US_ASCII));
        }
    }

    protected String getValue() {
        Annotation annotation = (Annotation)EcoreUtil.getObjectByType((Collection)this.getContents(), (EClassifier)BasePackage.Literals.ANNOTATION);
        if (annotation != null) {
            return annotation.getSource();
        }
        return null;
    }
}

