/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.util.HexUtil;
import org.eclipse.oomph.util.Messages;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.osgi.util.NLS;

public final class StringUtil {
    public static final String EMPTY = "";
    public static final String NL = PropertiesUtil.getProperty("line.separator");
    public static String HORIZONTAL_ELLIPSIS = "\u2026";
    private static final Pattern WILDCARD_FILTER_PATTERN = Pattern.compile("(\\\\.|[*?])");

    private StringUtil() {
    }

    public static String escape(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuilder builder = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (c > '\u0fff') {
                builder.append("\\u" + HexUtil.charToHex(c));
            } else if (c > '\u00ff') {
                builder.append("\\u0" + HexUtil.charToHex(c));
            } else if (c > '\u007f') {
                builder.append("\\u00" + HexUtil.charToHex(c));
            } else if (c < ' ') {
                switch (c) {
                    case '\r': {
                        builder.append('\\');
                        builder.append('r');
                        break;
                    }
                    case '\n': {
                        builder.append('\\');
                        builder.append('n');
                        break;
                    }
                    case '\t': {
                        builder.append('\\');
                        builder.append('t');
                        break;
                    }
                    case '\f': {
                        builder.append('\\');
                        builder.append('f');
                        break;
                    }
                    case '\b': {
                        builder.append('\\');
                        builder.append('b');
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            builder.append("\\u00" + HexUtil.charToHex(c));
                            break;
                        }
                        builder.append("\\u000" + HexUtil.charToHex(c));
                        break;
                    }
                }
            } else if (c == '\\') {
                builder.append('\\');
                builder.append('\\');
            } else {
                builder.append(c);
            }
            ++i;
        }
        return builder.toString();
    }

    public static String unescape(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuilder builder = new StringBuilder(len);
        StringBuilder unicodeBuilder = new StringBuilder(4);
        boolean unicode = false;
        boolean slash = false;
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (unicode) {
                unicodeBuilder.append(c);
                if (unicodeBuilder.length() == 4) {
                    try {
                        char value = HexUtil.hexToChar(unicodeBuilder.toString());
                        builder.append(value);
                        unicodeBuilder.setLength(0);
                        unicode = false;
                        slash = false;
                    }
                    catch (NumberFormatException ex) {
                        builder.append('\\');
                        builder.append('u');
                        builder.append((CharSequence)unicodeBuilder);
                    }
                }
            } else if (slash) {
                slash = false;
                switch (c) {
                    case '\\': {
                        builder.append('\\');
                        break;
                    }
                    case 'r': {
                        builder.append('\r');
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        break;
                    }
                    case 't': {
                        builder.append('\t');
                        break;
                    }
                    case 'f': {
                        builder.append('\f');
                        break;
                    }
                    case 'b': {
                        builder.append('\b');
                        break;
                    }
                    case 'u': {
                        unicode = true;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        if (i + 2 < len && str.charAt(i + 1) >= '0' && str.charAt(i + 1) <= '7' && str.charAt(i + 2) >= '0' && str.charAt(i + 2) <= '7') {
                            builder.append((char)Integer.parseInt(str.substring(i, i + 3), 8));
                            i += 2;
                            break;
                        }
                    }
                    default: {
                        builder.append(c);
                        break;
                    }
                }
            } else if (c == '\\') {
                slash = true;
            } else {
                builder.append(c);
            }
            ++i;
        }
        if (slash) {
            builder.append('\\');
        }
        return builder.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String safe(String str) {
        return StringUtil.safe(str, EMPTY);
    }

    private static String safe(String str, String def) {
        if (str == null) {
            return def;
        }
        return str;
    }

    public static String cap(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char first = str.charAt(0);
        if (Character.isUpperCase(first)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(0, Character.toUpperCase(first));
        return builder.toString();
    }

    public static String capAll(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        boolean inWhiteSpace = true;
        StringBuilder builder = new StringBuilder(str);
        int i = 0;
        while (i < builder.length()) {
            char c = builder.charAt(i);
            boolean isWhiteSpace = Character.isWhitespace(c);
            if (!isWhiteSpace && inWhiteSpace) {
                builder.setCharAt(i, Character.toUpperCase(c));
            }
            inWhiteSpace = isWhiteSpace;
            ++i;
        }
        return builder.toString();
    }

    public static String uncap(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char first = str.charAt(0);
        if (Character.isLowerCase(first)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(0, Character.toLowerCase(first));
        return builder.toString();
    }

    public static String uncapAll(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        boolean inWhiteSpace = true;
        StringBuilder builder = new StringBuilder(str);
        int i = 0;
        while (i < builder.length()) {
            char c = builder.charAt(i);
            boolean isWhiteSpace = Character.isWhitespace(c);
            if (!isWhiteSpace && inWhiteSpace) {
                builder.setCharAt(i, Character.toLowerCase(c));
            }
            inWhiteSpace = isWhiteSpace;
            ++i;
        }
        return builder.toString();
    }

    public static List<String> explode(String string, String separators) {
        return StringUtil.explode(string, separators, '\\');
    }

    public static List<String> explode(String string, String separators, char escapeCharacter) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean separator = false;
        boolean escape = false;
        int i = 0;
        while (i < string.length()) {
            separator = false;
            char c = string.charAt(i);
            if (!escape && c == escapeCharacter) {
                escape = true;
            } else {
                if (!escape && separators.indexOf(c) != -1) {
                    tokens.add(builder.toString());
                    builder.setLength(0);
                    separator = true;
                } else {
                    builder.append(c);
                }
                escape = false;
            }
            ++i;
        }
        if (separator || builder.length() != 0) {
            tokens.add(builder.toString());
        }
        return tokens;
    }

    public static String implode(List<String> tokens, char separator) {
        return StringUtil.implode(tokens, separator, '\\');
    }

    public static String implode(List<String> tokens, char separator, char escapeCharacter) {
        String escapeString = Character.toString(escapeCharacter);
        String escapeString2 = String.valueOf(escapeString) + escapeString;
        String separatorString = Character.toString(separator);
        String separatorString2 = String.valueOf(escapeString) + separatorString;
        StringBuilder builder = new StringBuilder();
        boolean firstTime = true;
        for (String token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                builder.append(separator);
            }
            if (token == null) continue;
            token = token.replace(escapeString, escapeString2);
            token = token.replace(separatorString, separatorString2);
            builder.append(token);
        }
        return builder.toString();
    }

    public static String toOSString(String uri) {
        URI emfURI;
        if (!StringUtil.isEmpty(uri) && (emfURI = URI.createURI((String)uri)).isFile()) {
            uri = emfURI.toFileString();
        }
        return uri;
    }

    public static String shorten(String input, int length, boolean wholeWord) {
        if (input == null) {
            return EMPTY;
        }
        if (length <= HORIZONTAL_ELLIPSIS.length()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.StringUtil_TooShort_exception, (Object)(HORIZONTAL_ELLIPSIS.length() + 1)));
        }
        if (input.length() <= length) {
            return input;
        }
        int ellipsisPos = length - HORIZONTAL_ELLIPSIS.length() - 1;
        if (wholeWord) {
            ellipsisPos = StringUtil.findLastSpaceBetween(input, 0, ellipsisPos);
        }
        String result = input.substring(0, ellipsisPos);
        result = String.valueOf(result) + HORIZONTAL_ELLIPSIS;
        return result;
    }

    public static String wrapText(String input, int maxCharactersPerLine, boolean wholeWord) {
        int startIndex = 0;
        int endIndex = startIndex + maxCharactersPerLine;
        boolean finished = false;
        StringBuilder builder = new StringBuilder();
        do {
            if (endIndex >= input.length()) {
                endIndex = input.length();
                finished = true;
            }
            if (!finished && wholeWord) {
                int spaceIndex = StringUtil.findLastSpaceBetween(input, startIndex, endIndex);
                if (spaceIndex > 0) {
                    endIndex = spaceIndex;
                } else {
                    endIndex = input.length();
                    finished = true;
                }
            }
            builder.append(input.substring(startIndex, endIndex));
            if (!finished) {
                builder.append(NL);
            }
            startIndex = wholeWord ? endIndex + 1 : endIndex;
            endIndex += maxCharactersPerLine;
        } while (!finished);
        return builder.toString();
    }

    private static int findLastSpaceBetween(String text, int startPosition, int endPosition) {
        int index = endPosition;
        char lastBeforeEllipsis = text.charAt(index);
        while (lastBeforeEllipsis != ' ') {
            if (--index <= startPosition) {
                index = -1;
                break;
            }
            lastBeforeEllipsis = text.charAt(index);
        }
        return index;
    }

    public static String removePrefix(String string, String ... prefixes) {
        int i = 0;
        while (i < prefixes.length) {
            String prefix = prefixes[i];
            if (string.startsWith(prefix)) {
                return string.substring(prefix.length());
            }
            ++i;
        }
        return string;
    }

    public static String removeSuffix(String string, String ... suffixes) {
        int i = 0;
        while (i < suffixes.length) {
            String suffix = suffixes[i];
            if (string.endsWith(suffix)) {
                return string.substring(0, string.length() - suffix.length());
            }
            ++i;
        }
        return string;
    }

    public static String trimLeft(String str) {
        int len = str.length();
        int st = 0;
        while (st < len && str.charAt(st) <= ' ') {
            ++st;
        }
        if (st == 0) {
            return str;
        }
        return str.substring(st, len);
    }

    public static String trimRight(String str) {
        int len;
        int end = len = str.length();
        while (end > 0 && str.charAt(end - 1) <= ' ') {
            --end;
        }
        if (end == len) {
            return str;
        }
        return str.substring(0, end);
    }

    public static String trimTrailingSlashes(String str) {
        int len;
        int end = len = str.length();
        while (end > 0) {
            char c = str.charAt(end - 1);
            if (c != '/' && c != '\\') break;
            --end;
        }
        if (end == len) {
            return str;
        }
        return str.substring(0, end);
    }

    public static Pattern globPattern(String filter) {
        StringBuffer pattern = new StringBuffer("(\\Q");
        Matcher matcher = WILDCARD_FILTER_PATTERN.matcher(filter);
        while (matcher.find()) {
            String tail;
            String separator = matcher.group(1);
            if (separator.length() == 2) {
                matcher.appendReplacement(pattern, EMPTY);
                if ("\\E".equals(separator)) {
                    pattern.append("\\E\\\\E\\Q");
                    continue;
                }
                if ("\\\\".equals(separator)) {
                    pattern.append("\\E\\\\\\Q");
                    continue;
                }
                pattern.append(separator.charAt(1));
                continue;
            }
            char separatorChar = separator.charAt(0);
            switch (separatorChar) {
                case '*': {
                    tail = ".*?";
                    break;
                }
                case '?': {
                    tail = ".";
                    break;
                }
                default: {
                    throw new IllegalStateException(NLS.bind((String)Messages.StringUtil_ShouldMatch_exception, (Object)WILDCARD_FILTER_PATTERN));
                }
            }
            matcher.appendReplacement(pattern, "\\\\E)");
            pattern.append(tail).append("(\\Q");
        }
        matcher.appendTail(pattern);
        pattern.append("\\E)");
        return Pattern.compile(pattern.toString(), 2);
    }
}

