/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;

public final class BundleToJarInputStream
extends InputStream {
    static final ByteArrayInputStream directoryInputStream = new ByteArrayInputStream(new byte[0]);
    private final BundleFile bundlefile;
    private final Iterator<String> entryPaths;
    private final JarOutputStream jarOutput;
    private final NextEntryOutputStream nextEntryOutput = new NextEntryOutputStream();
    private InputStream nextEntryInput = null;

    public BundleToJarInputStream(BundleFile bundleFile) throws IOException {
        this.bundlefile = bundleFile;
        ArrayList<String> entries = new ArrayList<String>();
        int signatureFileCnt = 0;
        Enumeration<String> ePaths = bundleFile.getEntryPaths("", true);
        while (ePaths.hasMoreElements()) {
            String entry = ePaths.nextElement();
            if (entry.equals("META-INF/MANIFEST.MF")) {
                entries.add(0, entry);
                ++signatureFileCnt;
                continue;
            }
            if (this.isSignatureFile(entry)) {
                entries.add(signatureFileCnt++, entry);
                continue;
            }
            entries.add(entry);
        }
        this.entryPaths = entries.iterator();
        this.jarOutput = new JarOutputStream(this.nextEntryOutput);
        this.jarOutput.setLevel(0);
    }

    private boolean isSignatureFile(String entry) {
        if ((entry = entry.toUpperCase()).startsWith("META-INF/") && entry.indexOf(47, "META-INF/".length()) == -1) {
            return entry.endsWith(".SF") || entry.endsWith(".DSA") || entry.endsWith(".RSA") || entry.endsWith(".EC");
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.nextEntryInput != null) {
            int result = this.nextEntryInput.read();
            if (result != -1) {
                return result;
            }
            this.nextEntryInput.close();
            this.nextEntryInput = null;
            return this.read();
        }
        if (this.entryPaths.hasNext()) {
            this.readNext(this.entryPaths.next());
            if (!this.entryPaths.hasNext()) {
                this.jarOutput.close();
            }
        } else {
            this.jarOutput.close();
            return -1;
        }
        return this.read();
    }

    private void readNext(String path) throws IOException {
        block12: {
            BundleEntry found = this.bundlefile.getEntry(path);
            if (found == null) {
                throw new IOException("No entry found: " + path);
            }
            this.nextEntryOutput.setCurrent(found);
            JarEntry entry = this.getJarEntry(path, found);
            this.nextEntryOutput.setCurrentLen(entry.getSize());
            this.jarOutput.putNextEntry(entry);
            this.nextEntryOutput.prefixWritten();
            if (!entry.isDirectory()) {
                Throwable throwable = null;
                Object var5_6 = null;
                try (BufferedInputStream source = new BufferedInputStream(found.getInputStream());){
                    int length;
                    byte[] buf = new byte[8192];
                    while ((length = ((InputStream)source).read(buf)) > 0) {
                        this.jarOutput.write(buf, 0, length);
                    }
                    break block12;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.nextEntryOutput.setCurrentLen(0L);
        }
        this.jarOutput.closeEntry();
        this.jarOutput.flush();
        this.nextEntryInput = this.nextEntryOutput.getNextInputStream();
    }

    private JarEntry getJarEntry(String path, BundleEntry found) throws IOException {
        JarEntry entry = new JarEntry(path);
        if (!entry.isDirectory()) {
            entry.setMethod(0);
            entry.setCompressedSize(-1L);
            CRC32 crc = new CRC32();
            long entryLen = 0L;
            Throwable throwable = null;
            Object var8_8 = null;
            try (BufferedInputStream source = new BufferedInputStream(found.getInputStream());){
                int length;
                byte[] buf = new byte[8192];
                while ((length = ((InputStream)source).read(buf)) > 0) {
                    entryLen += (long)length;
                    crc.update(buf, 0, length);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            entry.setCrc(crc.getValue());
            entry.setSize(entryLen);
        }
        return entry;
    }

    @Override
    public void close() throws IOException {
        this.nextEntryOutput.close();
    }

    static class NextEntryOutputStream
    extends OutputStream {
        private BundleEntry current = null;
        private long currentLen = -1L;
        private long currentWritten = 0L;
        private boolean writingPrefix = true;
        final ByteArrayOutputStream currentPrefix = new ByteArrayOutputStream();
        final ByteArrayOutputStream currentPostfix = new ByteArrayOutputStream();

        NextEntryOutputStream() {
        }

        void setCurrent(BundleEntry entry) {
            this.current = entry;
            this.currentWritten = 0L;
            this.currentPrefix.reset();
            this.currentPostfix.reset();
            this.writingPrefix = true;
        }

        void prefixWritten() {
            this.writingPrefix = false;
        }

        void setCurrentLen(long currentLen) {
            this.currentLen = currentLen;
        }

        InputStream getCurrentInputStream() throws IOException {
            if (this.current.getName().endsWith("/")) {
                return directoryInputStream;
            }
            return new BufferedInputStream(this.current.getInputStream());
        }

        InputStream getNextInputStream() throws IOException {
            return new FilterInputStream(this.getCurrentInputStream()){
                ByteArrayInputStream prefix;
                ByteArrayInputStream postfix;
                {
                    super($anonymous0);
                    this.prefix = new ByteArrayInputStream(nextEntryOutputStream.currentPrefix.toByteArray());
                    this.postfix = new ByteArrayInputStream(nextEntryOutputStream.currentPostfix.toByteArray());
                }

                @Override
                public int read() throws IOException {
                    int read = this.prefix.read();
                    if (read != -1) {
                        return read;
                    }
                    read = super.read();
                    if (read != -1) {
                        return read;
                    }
                    return this.postfix.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    int read = this.prefix.read(b);
                    if (read != -1) {
                        return read;
                    }
                    read = super.read(b);
                    if (read != -1) {
                        return read;
                    }
                    return this.postfix.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int read = this.prefix.read(b, off, len);
                    if (read != -1) {
                        return read;
                    }
                    read = super.read(b, off, len);
                    if (read != -1) {
                        return read;
                    }
                    return this.postfix.read(b, off, len);
                }
            };
        }

        @Override
        public void write(int b) throws IOException {
            if (this.writingPrefix) {
                this.currentPrefix.write(b);
                return;
            }
            if (this.currentWritten < this.currentLen) {
                ++this.currentWritten;
                return;
            }
            this.currentPostfix.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.writingPrefix) {
                this.currentPrefix.write(b);
                return;
            }
            if (this.currentWritten < this.currentLen) {
                this.currentWritten += (long)b.length;
                return;
            }
            this.currentPostfix.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.writingPrefix) {
                this.currentPrefix.write(b, off, len);
                return;
            }
            if (this.currentWritten < this.currentLen) {
                this.currentWritten += (long)len;
                return;
            }
            this.currentPostfix.write(b, off, len);
        }
    }
}

