/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.spi;

import java.net.URI;
import org.apache.http.client.fluent.Request;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.Session;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.spi.ICredentialsProvider;
import org.eclipse.userstorage.util.NoServiceException;

public abstract class AbstractCredentialsProvider
implements ICredentialsProvider {
    @Override
    public boolean hasCredentials(IStorageService service) {
        return false;
    }

    @Override
    public Credentials getCredentials(IStorageService service) {
        return null;
    }

    @Override
    public boolean updateCredentials(IStorageService service, Credentials credentials) {
        return false;
    }

    @Override
    public boolean isValid(Credentials credentials) {
        return !StringUtil.isEmpty(credentials.getUsername()) && !StringUtil.isEmpty(credentials.getPassword());
    }

    @Override
    public Request configureRequest(Request request, URI uri, Credentials credentials) {
        return request;
    }

    public Session openSession(IStorageService service) throws NoServiceException {
        throw new NoServiceException();
    }
}

