/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.logger;

import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.logger.R6LogServiceLogger;
import org.apache.felix.scr.impl.logger.R7LogServiceLogger;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;

class LogServiceSupport {
    private final boolean r7Enabled;
    private final LogService logService;
    private final Bundle bundle;

    private static boolean checkForLoggerFactory(Class<?> clazz) {
        while (clazz != null) {
            Class<?>[] is;
            for (Class<?> c : is = clazz.getInterfaces()) {
                if ("org.osgi.service.log.LoggerFactory".equals(c.getName())) {
                    return true;
                }
                if (!LogServiceSupport.checkForLoggerFactory(c)) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public LogServiceSupport(Bundle bundle, Object logService) {
        this.logService = (LogService)logService;
        this.bundle = bundle;
        this.r7Enabled = LogServiceSupport.checkForLoggerFactory(this.logService.getClass());
    }

    InternalLogger getLogger() {
        if (this.r7Enabled) {
            return new R7LogServiceLogger(this.bundle, this.logService, null);
        }
        return new R6LogServiceLogger(this.logService);
    }

    InternalLogger getLogger(String className) {
        if (this.r7Enabled) {
            return new R7LogServiceLogger(this.bundle, this.logService, className);
        }
        return new R6LogServiceLogger(this.logService);
    }
}

