/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.event.mapper;

import java.util.HashMap;
import org.eclipse.equinox.internal.event.mapper.EventAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class BundleEventAdapter
extends EventAdapter {
    public static final String HEADER = "org/osgi/framework/BundleEvent";
    public static final String INSTALLED = "INSTALLED";
    public static final String STOPPED = "STOPPED";
    public static final String STARTED = "STARTED";
    public static final String UPDATED = "UPDATED";
    public static final String UNINSTALLED = "UNINSTALLED";
    public static final String RESOLVED = "RESOLVED";
    public static final String UNRESOLVED = "UNRESOLVED";
    private BundleEvent event;

    public BundleEventAdapter(BundleEvent event, EventAdmin eventAdmin) {
        super(eventAdmin);
        this.event = event;
    }

    @Override
    public Event convert() {
        String typename = null;
        switch (this.event.getType()) {
            case 1: {
                typename = INSTALLED;
                break;
            }
            case 4: {
                typename = STOPPED;
                break;
            }
            case 2: {
                typename = STARTED;
                break;
            }
            case 8: {
                typename = UPDATED;
                break;
            }
            case 16: {
                typename = UNINSTALLED;
                break;
            }
            case 32: {
                typename = RESOLVED;
                break;
            }
            case 64: {
                typename = UNRESOLVED;
                break;
            }
            default: {
                typename = Integer.toString(this.event.getType());
            }
        }
        String topic = "org/osgi/framework/BundleEvent/" + typename;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Bundle bundle = this.event.getBundle();
        if (bundle == null) {
            throw new RuntimeException("BundleEvent.getBundle() returns null");
        }
        this.putBundleProperties(properties, bundle);
        properties.put("event", this.event);
        Event converted = new Event(topic, properties);
        return converted;
    }
}

