/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash.repository;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.oomph.gitbash.AbstractAction;
import org.eclipse.oomph.gitbash.Activator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateCopyrightsAction
extends AbstractAction<Repository> {
    private static final String[] IGNORED_PATHS = new String[]{"resourcemanager.java", "menucardtemplate.java", "org.eclipse.oomph.version.tests/tests", "org.eclipse.net4j.jms.api/src", "org/eclipse/net4j/util/ui/proposals/", "org.eclipse.emf.cdo.examples.installer/examples", "org.eclipse.net4j.examples.installer/examples"};
    private static final String[] REQUIRED_EXTENSIONS = new String[]{".java", ".ant", "build.xml", "plugin.xml", "fragment.xml", "feature.xml", "plugin.properties", "fragment.properties", "feature.properties", "about.properties", "build.properties", "messages.properties", "copyright.txt", ".exsd", "org.eclipse.jdt.ui.prefs"};
    private static final String[] OPTIONAL_EXTENSIONS = new String[]{".properties", ".xml", ".css", ".ecore", ".genmodel", ".mwe", ".xpt", ".ext"};
    private static final String[] IGNORED_MESSAGE_VERBS = new String[]{"update", "adjust", "fix"};
    private static final String[] IGNORED_MESSAGE_NOUNS = new String[]{"copyright", "legal header"};
    private static final String[] IGNORED_MESSAGES = UpdateCopyrightsAction.combineWords(IGNORED_MESSAGE_VERBS, IGNORED_MESSAGE_NOUNS);
    private static final Pattern COPYRIGHT_PATTERN = Pattern.compile("(.*?)Copyright \\(c\\) ([0-9 ,-]+) (.*?) and others\\.(.*)");
    private static final Calendar CALENDAR = GregorianCalendar.getInstance();
    private static final int CURRENT_YEAR = CALENDAR.get(1);
    private static final String CURRENT_YEAR_STRING = Integer.toString(CURRENT_YEAR);
    private static final IWorkbench WORKBENCH = PlatformUI.getWorkbench();
    private static final String NL = System.getProperty("line.separator");
    private Git git;
    private File workTree;
    private int workTreeLength;
    private List<String> missingCopyrights = new ArrayList<String>();
    private int rewriteCount;
    private int fileCount;

    public UpdateCopyrightsAction() {
        super(Repository.class);
    }

    protected boolean isCheckOnly() {
        return false;
    }

    @Override
    protected void run(final Shell shell, final Repository repository) throws Exception {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        UpdateCopyrightsAction.this.git = new Git(repository);
                        UpdateCopyrightsAction.this.workTree = repository.getWorkTree();
                        UpdateCopyrightsAction.this.workTreeLength = UpdateCopyrightsAction.this.workTree.getAbsolutePath().length() + 1;
                        UpdateCopyrightsAction.this.fileCount = UpdateCopyrightsAction.this.countFiles(UpdateCopyrightsAction.this.workTree);
                        monitor.beginTask(UpdateCopyrightsAction.this.getTitle(), UpdateCopyrightsAction.this.fileCount);
                        final long start = System.currentTimeMillis();
                        UpdateCopyrightsAction.this.checkFolder(monitor, UpdateCopyrightsAction.this.workTree);
                        shell.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                try {
                                    UpdateCopyrightsAction.this.handleResult(shell, UpdateCopyrightsAction.this.workTree, UpdateCopyrightsAction.formatDuration(start));
                                }
                                catch (Exception ex) {
                                    Activator.log(ex);
                                }
                            }
                        });
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        UpdateCopyrightsAction.this.missingCopyrights.clear();
                        UpdateCopyrightsAction.this.rewriteCount = 0;
                        UpdateCopyrightsAction.this.fileCount = 0;
                        UpdateCopyrightsAction.this.workTreeLength = 0;
                        UpdateCopyrightsAction.this.workTree = null;
                        UpdateCopyrightsAction.this.git = null;
                        monitor.done();
                    }
                    catch (Exception ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
                finally {
                    UpdateCopyrightsAction.this.missingCopyrights.clear();
                    UpdateCopyrightsAction.this.rewriteCount = 0;
                    UpdateCopyrightsAction.this.fileCount = 0;
                    UpdateCopyrightsAction.this.workTreeLength = 0;
                    UpdateCopyrightsAction.this.workTree = null;
                    UpdateCopyrightsAction.this.git = null;
                    monitor.done();
                }
            }
        };
        WORKBENCH.getProgressService().run(true, true, runnable);
    }

    private int countFiles(File folder) throws Exception {
        int count = 0;
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (file.isDirectory() && !fileName.equals(".git")) {
                count += this.countFiles(file);
            } else {
                String path = this.getPath(file);
                if (!this.hasString(path, IGNORED_PATHS)) {
                    ++count;
                }
            }
            ++n2;
        }
        return count;
    }

    private void checkFolder(IProgressMonitor monitor, File folder) throws Exception {
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            String fileName = file.getName();
            if (file.isDirectory() && !fileName.equals(".git")) {
                this.checkFolder(monitor, file);
            } else if (this.checkFile(monitor, file)) {
                monitor.worked(1);
            }
            ++n2;
        }
    }

    private boolean checkFile(IProgressMonitor monitor, File file) throws Exception {
        String path = this.getPath(file);
        if (!this.hasString(path, IGNORED_PATHS)) {
            boolean required = this.hasExtension(file, REQUIRED_EXTENSIONS);
            boolean optional = required || this.hasExtension(file, OPTIONAL_EXTENSIONS);
            boolean checkOnly = this.isCheckOnly();
            if (checkOnly ? required : optional) {
                monitor.subTask(path);
                ArrayList<String> lines = new ArrayList<String>();
                boolean copyrightFound = false;
                boolean copyrightChanged = false;
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                try {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        Matcher matcher = COPYRIGHT_PATTERN.matcher(line);
                        if (matcher.matches()) {
                            copyrightFound = true;
                            if (checkOnly) {
                                break;
                            }
                            String prefix = matcher.group(1);
                            String dates = matcher.group(2);
                            String owner = matcher.group(3);
                            String suffix = matcher.group(4);
                            if (dates.endsWith(CURRENT_YEAR_STRING)) {
                                break;
                            }
                            String newLine = this.rewriteCopyright(path, line, prefix, dates, owner, suffix);
                            if (newLine != line) {
                                line = newLine;
                                copyrightChanged = true;
                            }
                        }
                        lines.add(line);
                    }
                }
                finally {
                    UpdateCopyrightsAction.close(bufferedReader);
                    UpdateCopyrightsAction.close(fileReader);
                }
                if (required && !copyrightFound) {
                    this.missingCopyrights.add(path);
                }
                if (copyrightChanged) {
                    UpdateCopyrightsAction.writeLines(file, lines);
                    ++this.rewriteCount;
                }
            }
            return true;
        }
        return false;
    }

    private String rewriteCopyright(String path, String line, String prefix, String dates, String owner, String suffix) throws Exception {
        String newDates;
        if (path.endsWith("org.eclipse.jdt.ui.prefs") || path.endsWith("copyright.txt") || path.endsWith("org.eclipse.emf.cdo.license-feature/feature.properties") || suffix.equals(" All rights reserved.\\n\\")) {
            newDates = "2004-" + CURRENT_YEAR;
        } else {
            HashSet<Integer> years = new HashSet<Integer>();
            for (RevCommit commit : this.git.log().addPath(path).call()) {
                String message = commit.getFullMessage();
                if (this.hasString(message, IGNORED_MESSAGES)) continue;
                CALENDAR.setTimeInMillis(1000L * (long)commit.getCommitTime());
                int year = CALENDAR.get(1);
                years.add(year);
            }
            if (years.isEmpty()) {
                return line;
            }
            newDates = this.formatYears(years);
        }
        if (newDates.equals(dates)) {
            return line;
        }
        return String.valueOf(prefix) + "Copyright (c) " + newDates + " " + owner + " and" + " others." + suffix;
    }

    private String formatYears(Collection<Integer> years) {
        ArrayList<Integer> list = new ArrayList<Integer>(years);
        Collections.sort(list);
        class YearRange {
            private int begin;
            private int end;

            public YearRange(int begin) {
                this.begin = begin;
                this.end = begin;
            }

            public boolean add(int year) {
                if (year == this.end + 1) {
                    this.end = year;
                    return true;
                }
                return false;
            }

            public String toString() {
                if (this.begin == this.end) {
                    return "" + this.begin;
                }
                if (this.begin == this.end - 1) {
                    return this.begin + ", " + this.end;
                }
                return this.begin + "-" + this.end;
            }
        }
        ArrayList<YearRange> ranges = new ArrayList<YearRange>();
        YearRange lastRange = null;
        for (Integer year : list) {
            if (lastRange != null && lastRange.add(year)) continue;
            lastRange = new YearRange(year);
            ranges.add(lastRange);
        }
        StringBuilder builder = new StringBuilder();
        for (YearRange range : ranges) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(range);
        }
        return builder.toString();
    }

    private String getTitle() {
        return String.valueOf(this.isCheckOnly() ? "Check" : "Update") + " Copyrights";
    }

    private String getPath(File file) {
        String path = file.getAbsolutePath().replace('\\', '/');
        return path.substring(this.workTreeLength);
    }

    private boolean hasString(String string, String[] strings) {
        string = string.toLowerCase();
        int i = 0;
        while (i < strings.length) {
            if (string.indexOf(strings[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasExtension(File file, String[] extensions) {
        String fileName = file.getName().toLowerCase();
        int i = 0;
        while (i < extensions.length) {
            if (fileName.endsWith(extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void handleResult(Shell shell, File workTree, String duration) throws PartInitException {
        String message = "Copyrights missing: " + this.missingCopyrights.size();
        message = String.valueOf(message) + "\nCopyrights rewritten: " + this.rewriteCount;
        message = String.valueOf(message) + "\nFiles visited: " + this.fileCount;
        message = String.valueOf(message) + "\nTime needed: " + duration;
        int size = this.missingCopyrights.size();
        if (size != 0) {
            StringBuilder builder = new StringBuilder(message);
            message = String.valueOf(message) + "\n\nDo you want to open the files with missing copyrights in editors?";
            if (MessageDialog.openQuestion((Shell)shell, (String)this.getTitle(), (String)message)) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IWorkbenchPage page = WORKBENCH.getActiveWorkbenchWindow().getActivePage();
                builder.append("\n");
                for (String missingCopyright : this.missingCopyrights) {
                    builder.append("\nMissing: ");
                    builder.append(missingCopyright);
                    File externalFile = new File(workTree, missingCopyright);
                    IFile file = root.getFileForLocation((IPath)new Path(externalFile.getAbsolutePath()));
                    if (file != null && file.isAccessible()) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                        continue;
                    }
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(externalFile.toURI());
                    if (fileStore == null) continue;
                    IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                }
                Activator.log((IStatus)new Status(2, "org.eclipse.oomph.gitbash", builder.toString()));
            }
        } else {
            MessageDialog.openInformation((Shell)shell, (String)this.getTitle(), (String)message);
            Activator.log((IStatus)new Status(1, "org.eclipse.oomph.gitbash", message));
        }
    }

    private static String[] combineWords(String[] verbs, String[] nouns) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = nouns;
        int n = nouns.length;
        int n2 = 0;
        while (n2 < n) {
            String noun = stringArray[n2];
            String[] stringArray2 = verbs;
            int n3 = verbs.length;
            int n4 = 0;
            while (n4 < n3) {
                String verb = stringArray2[n4];
                result.add(String.valueOf(verb) + " " + noun);
                verb = verb.endsWith("e") ? String.valueOf(verb) + "d" : String.valueOf(verb) + "ed";
                result.add(String.valueOf(verb) + " " + noun);
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private static String formatDuration(long start) {
        double duration = System.currentTimeMillis() - start;
        String unit = "milliseconds";
        if (duration > 1000.0) {
            duration /= 1000.0;
            unit = "seconds";
            if (duration > 60.0) {
                duration /= 60.0;
                unit = "minutes";
                if (duration > 60.0) {
                    duration /= 60.0;
                    unit = "hours";
                }
            }
        }
        duration = (double)Math.round(duration * 100.0) / 100.0;
        return String.valueOf(duration) + " " + unit;
    }

    private static void writeLines(File file, List<String> lines) throws IOException {
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(fileWriter);
            for (String line : lines) {
                bufferedWriter.write(line);
                bufferedWriter.write(NL);
            }
        }
        catch (Throwable throwable) {
            UpdateCopyrightsAction.close(bufferedWriter);
            UpdateCopyrightsAction.close(fileWriter);
            throw throwable;
        }
        UpdateCopyrightsAction.close(bufferedWriter);
        UpdateCopyrightsAction.close(fileWriter);
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                Activator.log(ex);
            }
        }
    }
}

