/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectcopy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.projectcopy.ProjectCopyPlugin;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.XMLUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.w3c.dom.Element;

public class ProjectCopyAction
implements IObjectActionDelegate {
    private Shell shell;
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void run(IAction action) {
        final IProject source = (IProject)((IStructuredSelection)this.selection).getFirstElement();
        final File folder = source.getLocation().toFile();
        try {
            final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
            final File parentFolder = folder.getParentFile();
            InputDialog dialog = new InputDialog(this.shell, "Copy Project", "Name of the new project:", source.getName(), new IInputValidator(){

                public String isValid(String newName) {
                    try {
                        IProject newProject = ROOT.getProject(newName);
                        if (newProject.exists()) {
                            return "Project " + newName + " already exists.";
                        }
                        File newFolder = new File(parentFolder, newName);
                        if (newFolder.exists()) {
                            return "Location " + newFolder.getAbsolutePath() + " already exists.";
                        }
                        return null;
                    }
                    catch (Exception exception) {
                        return exception.getLocalizedMessage();
                    }
                }
            });
            if (dialog.open() == 0) {
                final String newName = dialog.getValue();
                new Job("Copy project"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                                public void run(IProgressMonitor monitor) throws CoreException {
                                    try {
                                        File newFolder = new File(parentFolder, newName);
                                        ProjectCopyAction.copyTree(folder, source.getName(), newName, folder, newFolder);
                                        ProjectCopyAction.importProject(newFolder, newName);
                                    }
                                    catch (Exception ex) {
                                        ProjectCopyPlugin.INSTANCE.coreException(ex);
                                    }
                                }
                            }, monitor);
                            return Status.OK_STATUS;
                        }
                        catch (CoreException ex) {
                            return ex.getStatus();
                        }
                    }
                }.schedule();
            }
        }
        catch (Exception ex) {
            ProjectCopyPlugin.INSTANCE.log(ex);
        }
    }

    private static void copyTree(File folder, String oldName, String newName, File source, File target) throws Exception {
        if (source.isDirectory()) {
            File[] files;
            IOUtil.mkdirs((File)target);
            File[] fileArray = files = source.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name = file.getName();
                ProjectCopyAction.copyTree(folder, oldName, newName, new File(source, name), new File(target, name));
                ++n2;
            }
        } else if (source.equals(new File(folder, ".project"))) {
            Replacer replacer = new Replacer("<name>" + oldName + "</name>", "<name>" + newName + "</name>");
            replacer.copy(source, target);
        } else if (source.equals(new File(new File(folder, "META-INF"), "MANIFEST.MF"))) {
            Replacer replacer = new Replacer("Bundle-SymbolicName: " + oldName, "Bundle-SymbolicName: " + newName);
            replacer.copy(source, target);
        } else if (source.equals(new File(folder, "feature.xml"))) {
            oldName = ProjectCopyAction.replaceFeatureSuffix(oldName, "");
            newName = ProjectCopyAction.replaceFeatureSuffix(newName, "");
            Replacer replacer = new Replacer("id=\"" + oldName + "\"", "id=\"" + newName + "\"");
            replacer.copy(source, target);
        } else if (source.equals(new File(folder, "component.def"))) {
            oldName = ProjectCopyAction.replaceFeatureSuffix(oldName, ".feature.group");
            newName = ProjectCopyAction.replaceFeatureSuffix(newName, ".feature.group");
            Replacer replacer = new Replacer("id=\"" + oldName + "\"", "id=\"" + newName + "\"");
            replacer.copy(source, target);
        } else if (source.equals(new File(folder, "pom.xml"))) {
            oldName = ProjectCopyAction.replaceFeatureSuffix(oldName, "");
            newName = ProjectCopyAction.replaceFeatureSuffix(newName, "");
            DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
            Element rootElement = XMLUtil.loadRootElement((DocumentBuilder)documentBuilder, (File)source);
            XMLUtil.ElementUpdater artifactIDUpdater = new XMLUtil.ElementUpdater(rootElement, "artifactId");
            String oldContents = IOUtil.readUTF8((File)source);
            String newContents = artifactIDUpdater.update(oldContents, newName);
            IOUtil.writeUTF8((File)target, (String)newContents);
        } else {
            IOUtil.copyFile((File)source, (File)target);
        }
    }

    private static String replaceFeatureSuffix(String name, String newSuffix) {
        if (name.endsWith("-feature")) {
            name = name.substring(0, name.length() - "-feature".length());
            name = String.valueOf(name) + newSuffix;
        }
        return name;
    }

    private static void importProject(final File folder, final String name) throws CoreException {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Path locationPath = new Path(folder.getAbsolutePath());
                if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                    locationPath = null;
                }
                IProjectDescription description = workspace.newProjectDescription(name);
                description.setLocation((IPath)locationPath);
                IProject project = workspace.getRoot().getProject(name);
                project.create(description, monitor);
                if (!project.isOpen()) {
                    project.open(monitor);
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    public static class Replacer {
        private final String search;
        private final String replace;
        private boolean done;

        public Replacer(String search, String replace) {
            this.search = search;
            this.replace = replace;
        }

        public final void copy(File source, File target) throws IOException {
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                reader = new BufferedReader(new FileReader(source));
                writer = new BufferedWriter(new FileWriter(target));
                this.copyText(reader, writer);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                IOUtil.close(writer);
                throw throwable;
            }
            IOUtil.close((Closeable)reader);
            IOUtil.close((Closeable)writer);
        }

        private void copyText(BufferedReader reader, BufferedWriter writer) throws IOException {
            String line;
            while ((line = reader.readLine()) != null) {
                int start;
                if (!this.done && (start = line.indexOf(this.search)) != -1) {
                    line = String.valueOf(line.substring(0, start)) + this.replace + line.substring(start + this.search.length());
                    this.done = true;
                }
                writer.write(line);
                writer.newLine();
            }
        }
    }
}

