/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.preferences.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.PreferencesPackage;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesRecorder
extends EContentAdapter {
    private static final String INSTANCE_SCOPE = "instance";
    private final Map<Property, URI> paths = new HashMap<Property, URI>();
    private final Map<URI, Pair<String, String>> values = new HashMap<URI, Pair<String, String>>();
    private PreferenceNode rootPreferenceNode = this.getRootPreferenceNode();

    public PreferencesRecorder() {
        this.rootPreferenceNode.eAdapters().add((Object)this);
    }

    public Map<URI, Pair<String, String>> done() {
        Object it;
        if (this.rootPreferenceNode != null) {
            it = this.rootPreferenceNode.eResource().getAllContents();
            while (it.hasNext()) {
                ((EObject)it.next()).eAdapters().clear();
            }
            this.rootPreferenceNode = null;
        }
        this.paths.clear();
        it = this.values.values().iterator();
        while (it.hasNext()) {
            Pair pair = (Pair)it.next();
            if (!ObjectUtil.equals((Object)pair.getElement1(), (Object)pair.getElement2())) continue;
            it.remove();
        }
        return this.values;
    }

    protected PreferenceNode getRootPreferenceNode() {
        return PreferencesUtil.getRootPreferenceNode(Collections.singleton(INSTANCE_SCOPE), true);
    }

    protected void setTarget(EObject target) {
        Property property;
        URI absolutePath;
        String scope;
        super.setTarget(target);
        if (target instanceof Property && INSTANCE_SCOPE.equals(scope = (absolutePath = (property = (Property)target).getAbsolutePath()).authority())) {
            this.paths.put(property, absolutePath);
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.rootPreferenceNode != null && !notification.isTouch()) {
            switch (notification.getEventType()) {
                case 1: {
                    if (notification.getFeature() != PreferencesPackage.Literals.PROPERTY__VALUE) break;
                    Property property = (Property)notification.getNotifier();
                    String oldValue = notification.getOldStringValue();
                    this.notifyChanged(property, oldValue, property.getValue());
                    break;
                }
                case 3: {
                    if (notification.getFeature() != PreferencesPackage.Literals.PREFERENCE_NODE__PROPERTIES) break;
                    Property property = (Property)notification.getNewValue();
                    String value = property.getValue();
                    this.notifyChanged(property, null, value);
                    break;
                }
                case 4: {
                    if (notification.getFeature() != PreferencesPackage.Literals.PREFERENCE_NODE__PROPERTIES) break;
                    Property property = (Property)notification.getOldValue();
                    URI uri = this.paths.get(property);
                    String path = PreferencesFactory.eINSTANCE.convertURI(uri);
                    PreferencesUtil.PreferenceProperty preferenceProperty = new PreferencesUtil.PreferenceProperty(path);
                    String effectiveValue = preferenceProperty.getEffectiveProperty().get(null);
                    this.notifyChanged(property, property.getValue(), effectiveValue);
                }
            }
        }
    }

    protected void notifyChanged(Property property, String oldValue, String newValue) {
        URI absolutePath = this.paths.get(property);
        if (absolutePath != null) {
            this.notifyChanged(absolutePath, oldValue, newValue);
        }
    }

    protected void notifyChanged(URI absolutePath, String oldValue, String newValue) {
        Pair<String, String> pair = this.values.get(absolutePath);
        if (pair == null) {
            this.values.put(absolutePath, (Pair<String, String>)new Pair((Object)oldValue, (Object)newValue));
        } else {
            pair.setElement2((Object)newValue);
        }
    }
}

