/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ScopeType implements Enumerator
{
    NONE(0, "None", "None"),
    PRODUCT_CATALOG(1, "ProductCatalog", "ProductCatalog"),
    PRODUCT(2, "Product", "Eclipse"),
    PRODUCT_VERSION(3, "ProductVersion", "ProductVersion"),
    PROJECT_CATALOG(4, "ProjectCatalog", "ProjectCatalog"),
    PROJECT(5, "Project", "Project"),
    STREAM(6, "Stream", "Stream"),
    INSTALLATION(7, "Installation", "Installation"),
    WORKSPACE(8, "Workspace", "Workspace"),
    USER(9, "User", "User"),
    MACRO(10, "Macro", "Macro");

    public static final int NONE_VALUE = 0;
    public static final int PRODUCT_CATALOG_VALUE = 1;
    public static final int PRODUCT_VALUE = 2;
    public static final int PRODUCT_VERSION_VALUE = 3;
    public static final int PROJECT_CATALOG_VALUE = 4;
    public static final int PROJECT_VALUE = 5;
    public static final int STREAM_VALUE = 6;
    public static final int INSTALLATION_VALUE = 7;
    public static final int WORKSPACE_VALUE = 8;
    public static final int USER_VALUE = 9;
    public static final int MACRO_VALUE = 10;
    private static final ScopeType[] VALUES_ARRAY;
    public static final List<ScopeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ScopeType[]{NONE, PRODUCT_CATALOG, PRODUCT, PRODUCT_VERSION, PROJECT_CATALOG, PROJECT, STREAM, INSTALLATION, WORKSPACE, USER, MACRO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ScopeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ScopeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ScopeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ScopeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ScopeType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return PRODUCT_CATALOG;
            }
            case 2: {
                return PRODUCT;
            }
            case 3: {
                return PRODUCT_VERSION;
            }
            case 4: {
                return PROJECT_CATALOG;
            }
            case 5: {
                return PROJECT;
            }
            case 6: {
                return STREAM;
            }
            case 7: {
                return INSTALLATION;
            }
            case 8: {
                return WORKSPACE;
            }
            case 9: {
                return USER;
            }
            case 10: {
                return MACRO;
            }
        }
        return null;
    }

    private ScopeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

