/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core.listeners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.core.TargletContainerEvent;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.internal.core.listeners.FileUpdater;
import org.eclipse.oomph.targlets.internal.core.listeners.WorkspaceUpdateListener;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetDefinitionGenerator
extends WorkspaceUpdateListener {
    public static final String ANNOTATION = "http:/www.eclipse.org/oomph/targlets/TargetDefinitionGenerator";
    public static final String ANNOTATION_NAME = "name";
    public static final String ANNOTATION_LOCATION = "location";
    public static final String ANNOTATION_GENERATE_IMPLICIT_UNITS = "generateImplicitUnits";
    public static final String ANNOTATION_GENERATE_VERSIONS = "generateVersions";
    public static final String ANNOTATION_INCLUDE_ALL_PLATFORMS = "includeAllPlatforms";
    public static final String ANNOTATION_INCLUDE_CONFIGURE_PHASE = "includeConfigurePhase";
    public static final String ANNOTATION_INCLUDE_MODE = "includeMode";
    public static final String ANNOTATION_INCLUDE_SOURCE = "includeSource";
    public static final String ANNOTATION_EXTRA_UNITS = "extraUnits";
    private static final Pattern SEQUENCE_NUMBER_PATTERN = Pattern.compile("sequenceNumber=\"([0-9]+)\"");
    private static final String TRUE = Boolean.TRUE.toString();

    @Override
    protected void handleTargletContainerEvent(TargletContainerEvent.ProfileUpdateSucceededEvent profileUpdateSucceededEvent, TargletContainerEvent.WorkspaceUpdateFinishedEvent workspaceUpdateFinishedEvent, IProgressMonitor monitor) throws Exception {
        ITargletContainer targletContainer = profileUpdateSucceededEvent.getSource();
        for (Targlet targlet : targletContainer.getTarglets()) {
            String location;
            Annotation annotation = targlet.getAnnotation(ANNOTATION);
            if (annotation == null) continue;
            EMap details = annotation.getDetails();
            String name = (String)details.get((Object)ANNOTATION_NAME);
            if (StringUtil.isEmpty((String)name)) {
                name = "Generated from " + targlet.getName();
            }
            if (StringUtil.isEmpty((String)(location = (String)details.get((Object)ANNOTATION_LOCATION)))) {
                location = File.createTempFile("tmp-", ".target").getAbsolutePath();
                TargletsCorePlugin.INSTANCE.log("Generating target definition for targlet " + targlet.getName() + " to " + location);
            }
            Profile profile = profileUpdateSucceededEvent.getProfile();
            List<IMetadataRepository> metadataRepositories = profileUpdateSucceededEvent.getMetadataRepositories();
            TargetDefinitionGenerator.generateTargetDefinition(targlet, name, location, profile, metadataRepositories, monitor);
        }
    }

    private static void generateTargetDefinition(final Targlet targlet, final String name, String location, Profile profile, List<IMetadataRepository> metadataRepositories, final IProgressMonitor monitor) throws Exception {
        monitor.setTaskName("Checking for generated target definition updates");
        final Map<Repository, Set<IU>> repositoryIUs = TargetDefinitionGenerator.analyzeRepositories(targlet, profile, metadataRepositories, monitor);
        File targetDefinition = new File(location);
        new FileUpdater(){
            private int sequenceNumber;

            protected String createNewContents(String oldContents, String encoding, String nl) {
                Matcher matcher;
                if (oldContents != null && (matcher = SEQUENCE_NUMBER_PATTERN.matcher(oldContents)).find()) {
                    this.sequenceNumber = Integer.parseInt(matcher.group(1));
                }
                StringBuilder builder = new StringBuilder();
                builder.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\" standalone=\"no\"?>");
                builder.append(nl);
                builder.append("<?pde version=\"3.8\"?>");
                builder.append(nl);
                builder.append("<target name=\"" + name + "\" sequenceNumber=\"" + this.sequenceNumber + "\">");
                builder.append(nl);
                builder.append("  <locations>");
                builder.append(nl);
                for (Map.Entry entry : repositoryIUs.entrySet()) {
                    Repository repository = (Repository)entry.getKey();
                    Set set = (Set)entry.getValue();
                    Set extraUnits = TargetDefinitionGenerator.getExtraUnits(repository);
                    set.addAll(extraUnits);
                    ArrayList list = new ArrayList(set);
                    if (list.isEmpty()) continue;
                    boolean versions = TargetDefinitionGenerator.isAnnotationDetail((ModelElement)repository, TargetDefinitionGenerator.ANNOTATION_GENERATE_VERSIONS, false);
                    boolean includeAllPlatforms = TargetDefinitionGenerator.isAnnotationDetail((ModelElement)repository, TargetDefinitionGenerator.ANNOTATION_INCLUDE_ALL_PLATFORMS, targlet.isIncludeAllPlatforms());
                    boolean includeConfigurePhase = TargetDefinitionGenerator.isAnnotationDetail((ModelElement)repository, TargetDefinitionGenerator.ANNOTATION_INCLUDE_CONFIGURE_PHASE, true);
                    String includeMode = TargetDefinitionGenerator.getAnnotationDetail((ModelElement)repository, TargetDefinitionGenerator.ANNOTATION_INCLUDE_MODE, "planner");
                    boolean includeSource = TargetDefinitionGenerator.isAnnotationDetail((ModelElement)repository, TargetDefinitionGenerator.ANNOTATION_INCLUDE_SOURCE, targlet.isIncludeSources());
                    builder.append("    <location includeAllPlatforms=\"" + includeAllPlatforms + "\" includeConfigurePhase=\"" + includeConfigurePhase + "\" includeMode=\"" + includeMode + "\" includeSource=\"" + includeSource + "\" type=\"InstallableUnit\">");
                    builder.append(nl);
                    LinkedHashSet<String> elements = new LinkedHashSet<String>();
                    Collections.sort(list);
                    for (IU iu : list) {
                        elements.add(iu.formatElement(versions));
                    }
                    for (String element : elements) {
                        builder.append("      ");
                        builder.append(element);
                        builder.append(nl);
                    }
                    builder.append("      <repository location=\"" + repository.getURL() + "\"/>");
                    builder.append(nl);
                    builder.append("    </location>");
                    builder.append(nl);
                }
                builder.append("  </locations>");
                builder.append(nl);
                builder.append("</target>");
                builder.append(nl);
                return builder.toString();
            }

            protected void setContents(URI uri, String encoding, String contents) throws IOException {
                monitor.subTask("Updating " + (uri.isPlatformResource() ? uri.toPlatformString(true) : uri.toFileString()));
                contents = contents.replace("sequenceNumber=\"" + this.sequenceNumber + "\"", "sequenceNumber=\"" + (this.sequenceNumber + 1) + "\"");
                super.setContents(uri, encoding, contents);
            }
        }.update(targetDefinition);
    }

    private static String getAnnotationDetail(ModelElement element, String annotationDetailKey, String defaultValue) {
        for (Annotation annotation : element.getAnnotations()) {
            String value;
            if (!ANNOTATION.equals(annotation.getSource()) || (value = (String)annotation.getDetails().get((Object)annotationDetailKey)) == null) continue;
            return value;
        }
        if (element instanceof Targlet) {
            return defaultValue;
        }
        EObject container = element.eContainer();
        if (container instanceof ModelElement) {
            return TargetDefinitionGenerator.getAnnotationDetail((ModelElement)container, annotationDetailKey, defaultValue);
        }
        return defaultValue;
    }

    private static boolean isAnnotationDetail(ModelElement element, String annotationDetailKey, boolean defaultValue) {
        String detail = TargetDefinitionGenerator.getAnnotationDetail(element, annotationDetailKey, Boolean.toString(defaultValue));
        return TRUE.equalsIgnoreCase(detail);
    }

    private static Set<IU> getExtraUnits(Repository repository) {
        HashSet<IU> extraUnits = new HashSet<IU>();
        for (Annotation annotation : repository.getAnnotations()) {
            String values;
            if (!ANNOTATION.equals(annotation.getSource()) || StringUtil.isEmpty((String)(values = (String)annotation.getDetails().get((Object)ANNOTATION_EXTRA_UNITS)))) continue;
            String[] stringArray = values.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!StringUtil.isEmpty((String)value)) {
                    int pos = value.lastIndexOf(95);
                    String id = pos == -1 ? value : value.substring(0, pos);
                    Version version = pos == -1 ? Version.emptyVersion : Version.create((String)value.substring(pos + 1));
                    extraUnits.add(new ExtraIU(id, version));
                }
                ++n2;
            }
        }
        return extraUnits;
    }

    private static Map<Repository, Set<IU>> analyzeRepositories(Targlet targlet, Profile profile, List<IMetadataRepository> metadataRepositories, IProgressMonitor monitor) {
        LinkedHashMap<Repository, Set<IU>> result = new LinkedHashMap<Repository, Set<IU>>();
        HashMap<IInstallableUnit, IU> ius = new HashMap<IInstallableUnit, IU>();
        boolean generateImplicitUnits = TargetDefinitionGenerator.isAnnotationDetail((ModelElement)targlet, ANNOTATION_GENERATE_IMPLICIT_UNITS, false);
        for (Repository repository : targlet.getActiveRepositories()) {
            TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
            HashSet<IU> resultIUs = new HashSet<IU>();
            IMetadataRepository metadataRepository = TargetDefinitionGenerator.getMetadataRepository(repository.getURL(), metadataRepositories);
            for (IInstallableUnit repositoryIU : P2Util.asIterable((IQueryResult)metadataRepository.query(QueryUtil.createIUAnyQuery(), null))) {
                TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
                IInstallableUnit installableUnit = TargetDefinitionGenerator.getInstallableUnitFromProfile(repositoryIU, profile);
                if (installableUnit == null || installableUnit.getId().endsWith(".source")) continue;
                IU iu = TargetDefinitionGenerator.getOrCreateIU(ius, installableUnit);
                resultIUs.add(iu);
            }
            if (!generateImplicitUnits) {
                HashSet rootIUs = new HashSet(resultIUs);
                for (IU resultIU : resultIUs) {
                    TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
                    IInstallableUnit delegate = resultIU.getDelegate();
                    if (delegate == null) continue;
                    Set<IU> requiredIUs = resultIU.getRequiredIUs();
                    if (requiredIUs == null) {
                        requiredIUs = new HashSet<IU>();
                        resultIU.setRequiredIUs(requiredIUs);
                        for (IRequirement requirement : delegate.getRequirements()) {
                            TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
                            for (IInstallableUnit installableUnit : P2Util.asIterable((IQueryResult)profile.query(QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0]), null))) {
                                TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
                                IU requiredIU = TargetDefinitionGenerator.getOrCreateIU(ius, installableUnit);
                                requiredIU.setRequired(true);
                                requiredIUs.add(requiredIU);
                            }
                        }
                    }
                    rootIUs.removeAll(requiredIUs);
                }
                result.put(repository, rootIUs);
                continue;
            }
            result.put(repository, resultIUs);
        }
        if (!generateImplicitUnits) {
            block5: for (Set resultIUs : result.values()) {
                TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
                ArrayList list = new ArrayList(resultIUs);
                Collections.sort(list);
                for (IU iu : list) {
                    TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
                    if (resultIUs.size() <= 1) continue block5;
                    if (!iu.isRequired()) continue;
                    resultIUs.remove(iu);
                }
            }
        }
        return result;
    }

    private static IU getOrCreateIU(Map<IInstallableUnit, IU> ius, IInstallableUnit installableUnit) {
        IU iu = ius.get(installableUnit);
        if (iu == null) {
            iu = new ProfileIU(installableUnit);
            ius.put(installableUnit, iu);
        }
        return iu;
    }

    private static IMetadataRepository getMetadataRepository(String url, List<IMetadataRepository> metadataRepositories) {
        for (IMetadataRepository metadataRepository : metadataRepositories) {
            if (!metadataRepository.getLocation().toString().equals(url)) continue;
            return metadataRepository;
        }
        return null;
    }

    private static IInstallableUnit getInstallableUnitFromProfile(IInstallableUnit repositoryIU, Profile profile) {
        for (IInstallableUnit profileIU : P2Util.asIterable((IQueryResult)profile.query(QueryUtil.createIUQuery((IVersionedId)repositoryIU), null))) {
            if (TRUE.equalsIgnoreCase(profileIU.getProperty("org.eclipse.oomph.targlet.workspace"))) continue;
            return profileIU;
        }
        return null;
    }

    private static final class ExtraIU
    extends IU {
        private final String id;
        private final Version version;

        public ExtraIU(String id, Version version) {
            this.id = id;
            this.version = version;
        }

        public String getID() {
            return this.id;
        }

        public Version getVersion() {
            return this.version;
        }

        public IInstallableUnit getDelegate() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class IU
    implements Comparable<IU> {
        private Set<IU> requiredIUs;
        private boolean required;

        public abstract String getID();

        public abstract Version getVersion();

        public abstract IInstallableUnit getDelegate();

        public final Set<IU> getRequiredIUs() {
            return this.requiredIUs;
        }

        public final void setRequiredIUs(Set<IU> requiredIUs) {
            this.requiredIUs = requiredIUs;
        }

        public final boolean isRequired() {
            return this.required;
        }

        public final void setRequired(boolean required) {
            this.required = required;
        }

        public final int hashCode() {
            int result = 1;
            result = 31 * result + this.getID().hashCode();
            Version version = this.getVersion();
            result = 31 * result + version.hashCode();
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IU)) {
                return false;
            }
            IU other = (IU)obj;
            if (!this.getID().equals(other.getID())) {
                return false;
            }
            return this.getVersion().equals(other.getVersion());
        }

        @Override
        public final int compareTo(IU o) {
            int result = this.getID().compareTo(o.getID());
            if (result == 0) {
                result = this.getVersion().compareTo((Object)o.getVersion());
            }
            return result;
        }

        public final String toString() {
            return String.valueOf(this.getID()) + "_" + this.getVersion();
        }

        public final String formatElement(boolean withVersion) {
            Version version = this.getVersion();
            if (!withVersion || version == null) {
                version = Version.emptyVersion;
            }
            return "<unit id=\"" + this.getID() + "\" version=\"" + version + "\"/>";
        }
    }

    private static final class ProfileIU
    extends IU {
        private final IInstallableUnit delegate;

        public ProfileIU(IInstallableUnit delegate) {
            this.delegate = delegate;
        }

        public String getID() {
            return this.delegate.getId();
        }

        public Version getVersion() {
            return this.delegate.getVersion();
        }

        public IInstallableUnit getDelegate() {
            return this.delegate;
        }
    }
}

