/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.module;

import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.LiquidLevelFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.testsuite.CSEUtil;
import org.eclipse.om2m.ipe.sdt.testsuite.TestReport;
import org.eclipse.om2m.ipe.sdt.testsuite.module.AbstractModuleTest;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.LiquidLevel;

public class WaterLevelModuleTest
extends AbstractModuleTest {
    public WaterLevelModuleTest(CseService pCseService, Module pModule) {
        super(pCseService, pModule);
    }

    public TestReport testGetLiquidLevel() {
        TestReport report = new TestReport("Test " + this.getModule().getName() + ".getLiquidLevel()");
        if (!this.checkModuleUrl(report)) {
            return report;
        }
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), this.getModuleUrl());
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer: " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        LiquidLevelFlexContainer retrievedFlexContainer = (LiquidLevelFlexContainer)response.getContent();
        CustomAttribute liquidLevelCA = retrievedFlexContainer.getCustomAttribute(DatapointType.liquidLevel.getShortName());
        if (liquidLevelCA == null) {
            report.setErrorMessage("liquidLevel customAttribute does not exist");
            report.setState(TestReport.State.KO);
            return report;
        }
        LiquidLevel liquidLevelDP = (LiquidLevel)this.getModule().getDataPoint(DatapointType.liquidLevel.getShortName());
        Integer liquidLevelValueFromDP = null;
        try {
            liquidLevelValueFromDP = (Integer)liquidLevelDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve liquidLevel datapoint value: " + e.getMessage());
            report.setException((Exception)e);
            report.setState(TestReport.State.KO);
            return report;
        }
        Integer liquidLevelFromFlexContainer = null;
        try {
            liquidLevelFromFlexContainer = Integer.parseInt(liquidLevelCA.getCustomAttributeValue());
        }
        catch (NumberFormatException numberFormatException) {
            report.setErrorMessage("unable to cast liquidLevel customAttribute value (" + liquidLevelCA.getCustomAttributeValue() + ") as an Integer");
            report.setState(TestReport.State.KO);
            return report;
        }
        if (!this.checkObject(liquidLevelFromFlexContainer, liquidLevelValueFromDP, report, DatapointType.liquidLevel.getShortName())) {
            return report;
        }
        report.setState(TestReport.State.OK);
        return report;
    }

    public TestReport testSetLiquidLevel() {
        TestReport report = new TestReport("Test " + this.getModule().getName() + ".setLiquidLevel()");
        if (!this.checkModuleUrl(report)) {
            return report;
        }
        LiquidLevel liquidLevelDP = (LiquidLevel)this.getModule().getDataPoint(DatapointType.liquidLevel.getShortName());
        Integer liquidLevelFromDP = null;
        try {
            liquidLevelFromDP = (Integer)liquidLevelDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve value from liquidLevel datapoint: " + e.getMessage());
            report.setException((Exception)e);
            report.setState(TestReport.State.KO);
            return report;
        }
        Integer newLiquidLevelValue = liquidLevelFromDP == 1 ? 5 : 1;
        LiquidLevelFlexContainer toBeUpdated = new LiquidLevelFlexContainer();
        CustomAttribute liquidLevelCA = new CustomAttribute();
        liquidLevelCA.setCustomAttributeName(DatapointType.liquidLevel.getShortName());
        liquidLevelCA.setCustomAttributeValue(newLiquidLevelValue.toString());
        toBeUpdated.getCustomAttributes().add(liquidLevelCA);
        ResponsePrimitive response = CSEUtil.updateFlexContainerEntity(this.getCseService(), this.getModuleUrl(), (AbstractFlexContainer)toBeUpdated);
        if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to update liquidLevel customAttribute: " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            liquidLevelFromDP = (Integer)liquidLevelDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve value from liquidLevel datapoint: " + e.getMessage());
            report.setException((Exception)e);
            report.setState(TestReport.State.KO);
            return report;
        }
        if (!this.checkObject(newLiquidLevelValue, liquidLevelFromDP, report, DatapointType.liquidLevel.getShortName())) {
            return report;
        }
        report.setState(TestReport.State.OK);
        return report;
    }
}

