/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.utils;

import org.osgi.service.log.LogService;

public class Logger {
    private static final String PREFIX = "[ONEM2M.SDT";
    private static final String[] LEVELS = new String[]{"ERROR ", "WARNING ", "INFO ", "DEBUG "};
    private static LogService logService;

    private Logger() {
    }

    public static void setLogService(LogService log) {
        logService = log;
    }

    public static void unsetLogService() {
        logService = null;
    }

    public static void debug(String message) {
        Logger.print(4, null, message);
    }

    public static void debug(String message, Class clazz) {
        Logger.print(4, clazz, message);
    }

    public static void info(String message) {
        Logger.print(3, null, message);
    }

    public static void info(String message, Class clazz) {
        Logger.print(3, clazz, message);
    }

    public static void warning(String message) {
        Logger.print(2, null, message);
    }

    public static void warning(String message, Exception e) {
        Logger.print(2, null, message, e);
    }

    public static void warning(String message, Class clazz) {
        Logger.print(2, clazz, message);
    }

    public static void warning(String message, Class clazz, Exception e) {
        Logger.print(2, clazz, message, e);
    }

    public static void error(String message) {
        Logger.print(1, null, message);
    }

    public static void error(String message, Exception e) {
        Logger.print(1, null, message, e);
    }

    public static void error(String message, Class clazz) {
        Logger.print(1, clazz, message);
    }

    public static void error(String message, Class clazz, Exception e) {
        Logger.print(1, clazz, message, e);
    }

    private static void print(int level, Class clazz, String message) {
        String msg = PREFIX + (clazz == null ? "] " : "." + clazz.getSimpleName() + "] ") + message;
        if (logService != null) {
            logService.log(level, msg);
        } else {
            System.out.println(String.valueOf(LEVELS[level - 1]) + msg);
        }
    }

    private static void print(int level, Class clazz, String message, Exception e) {
        String msg = PREFIX + (clazz == null ? "] " : "." + clazz.getSimpleName() + "] ") + message;
        if (logService != null) {
            logService.log(level, msg, (Throwable)e);
        } else {
            System.out.println(String.valueOf(LEVELS[level - 1]) + msg + ": " + e.getMessage());
        }
        if (e != null) {
            e.printStackTrace();
        }
    }
}

