/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.crud;

import java.util.UUID;
import org.eclipse.om2m.commons.constants.CSEType;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;
import org.eclipse.om2m.das.testsuite.crud.CreateDAS_CseBase_Test;

public class CreateDAS_RemoteCSE_Test
extends CreateDAS_CseBase_Test {
    public CreateDAS_RemoteCSE_Test(CseService pCseService) {
        super("Create DAS - RemoteCSE", pCseService);
    }

    @Override
    public void performTest() {
        RemoteCSE remoteCse = this.createRemoteCSE();
        if (remoteCse == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create RemoteCse");
            return;
        }
        if (!this.createAndCheck(remoteCse.getResourceID())) {
            return;
        }
        if (!this.createAndCheck("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + remoteCse.getName())) {
            return;
        }
        this.setState(Test.State.OK);
    }

    private RemoteCSE createRemoteCSE() {
        RemoteCSE remoteCse = new RemoteCSE();
        remoteCse.setCseType(CSEType.IN_CSE);
        remoteCse.setCSEID("cseId" + UUID.randomUUID());
        remoteCse.setCSEBase("/base" + remoteCse.getCSEID());
        remoteCse.setRequestReachability(Boolean.FALSE);
        remoteCse.setName(remoteCse.getCSEID());
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.CREATE);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setResourceType(16);
        request.setTargetId("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setContent((Object)remoteCse);
        ResponsePrimitive response = this.getCseService().doRequest(request);
        if (response != null && ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
            return (RemoteCSE)response.getContent();
        }
        return null;
    }
}

