/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.eclipse.om2m.commons.constants.AccessControl;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.AccessControlRule;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.FlexContainer;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.SetOfAcrs;
import org.eclipse.om2m.commons.resource.flexcontainerspec.BinarySwitchFlexContainerAnnc;
import org.eclipse.om2m.core.service.CseService;

public abstract class Test {
    private final String name;
    private State state = State.KO;
    private String message;
    private final CseService cseService;

    protected Test(String pName, CseService pCseService) {
        this.name = pName;
        this.cseService = pCseService;
    }

    public String getName() {
        return this.name;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public CseService getCseService() {
        return this.cseService;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public abstract void performTest();

    public void cleanUp() {
    }

    public boolean checkNotNull(Object object, String objectName) {
        if (object == null) {
            this.setState(State.KO);
            this.setMessage("object " + objectName + " must not be null ");
            return false;
        }
        return true;
    }

    public boolean checkNull(Object object, String objectName) {
        if (object != null) {
            this.setState(State.KO);
            this.setMessage("object " + objectName + " must be null ");
            return false;
        }
        return true;
    }

    public boolean checkEmpty(List object, String objectName) {
        if (object == null) {
            this.setState(State.KO);
            this.setMessage("object " + objectName + " must not be null");
            return false;
        }
        if (!object.isEmpty()) {
            this.setState(State.KO);
            this.setMessage("object " + objectName + " must be empty ");
            return false;
        }
        return true;
    }

    public boolean checkNotEmpty(String object, String objectName) {
        if (!this.checkNotNull(object, objectName)) {
            return false;
        }
        if (object.isEmpty()) {
            this.setState(State.KO);
            this.setMessage("object " + objectName + " must not be empty ");
            return false;
        }
        return true;
    }

    public boolean checkEquals(int currentValue, int expectedValue, String objectName) {
        if (currentValue != expectedValue) {
            this.setState(State.KO);
            this.setMessage("object " + objectName + ": expected=" + expectedValue + ", found=" + currentValue);
            return false;
        }
        return true;
    }

    public boolean checkEquals(Object currentValue, Object expectedValue, String objectName) {
        if (currentValue == null) {
            if (expectedValue != null) {
                this.setState(State.KO);
                this.setMessage("object " + objectName + ": expected=" + expectedValue + ", found=" + currentValue);
                return false;
            }
            return true;
        }
        if (!currentValue.equals(expectedValue)) {
            this.setState(State.KO);
            this.setMessage("object " + objectName + ": expected=" + expectedValue + ", found=" + currentValue);
            return false;
        }
        return true;
    }

    public boolean checkEquals(List<?> currentList, List<?> expectedList, String objectName) {
        if (currentList == null) {
            if (expectedList != null) {
                this.setState(State.KO);
                this.setMessage("object " + objectName + ": expected=" + expectedList.toString() + ", found=" + currentList);
                return false;
            }
            return true;
        }
        if (!currentList.equals(expectedList)) {
            this.setState(State.KO);
            this.setMessage("object " + objectName + ": expected=" + expectedList + ", found=" + currentList.toString());
            return false;
        }
        return true;
    }

    public void printTestReport() {
        System.out.println("\t - " + this.getName() + ", state=" + (Object)((Object)this.getState()) + ", message=" + this.getMessage());
    }

    protected DynamicAuthorizationConsultation createDAS() {
        return this.createDAS((String)null);
    }

    protected DynamicAuthorizationConsultation createDAS(String poA) {
        ArrayList<String> poas = null;
        if (poA != null) {
            poas = new ArrayList<String>();
            poas.add(poA);
        }
        return this.createDAS(poas);
    }

    protected DynamicAuthorizationConsultation createDAS(List<String> poAs) {
        RequestPrimitive request = new RequestPrimitive();
        Boolean enabled = Boolean.TRUE;
        ArrayList<String> poa = new ArrayList<String>();
        if (poAs == null) {
            poa.add("poa1" + UUID.randomUUID());
            poa.add("poa2" + UUID.randomUUID());
        } else {
            poa.addAll(poAs);
        }
        String dasName = "DAS" + UUID.randomUUID().toString();
        request.setOperation(Operation.CREATE);
        request.setTargetId("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setResourceType(34);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        DynamicAuthorizationConsultation das = new DynamicAuthorizationConsultation();
        das.setDynamicAuthorizationEnabled(enabled);
        das.setDynamicAuthorisationPoA(poa);
        das.setDynamicAuthorizationLifetime(new Date().toString());
        das.setName(dasName);
        request.setContent((Object)das);
        ResponsePrimitive response = this.getCseService().doRequest(request);
        if (response != null && ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
            return (DynamicAuthorizationConsultation)response.getContent();
        }
        return null;
    }

    protected RemoteCSE createRemoteCse() {
        RequestPrimitive request = new RequestPrimitive();
        String remoteCseName = "RemoteCse_" + UUID.randomUUID().toString();
        request.setOperation(Operation.CREATE);
        request.setTargetId("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setResourceType(16);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        RemoteCSE remoteCse = new RemoteCSE();
        remoteCse.setCSEBase("/base/" + remoteCseName);
        remoteCse.setCSEID(remoteCseName);
        remoteCse.setRequestReachability(Boolean.FALSE);
        remoteCse.setName(remoteCseName);
        request.setContent((Object)remoteCse);
        ResponsePrimitive response = this.getCseService().doRequest(request);
        if (response != null && ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
            return (RemoteCSE)response.getContent();
        }
        return null;
    }

    protected AEAnnc createAeAnnc(String url) {
        return this.createAeAnnc(url, null);
    }

    protected AEAnnc createAeAnnc(String url, List<String> dacis) {
        AccessControlPolicy createdAcp = this.createAcp();
        if (createdAcp == null) {
            return null;
        }
        RequestPrimitive request = new RequestPrimitive();
        String aeAnncCseName = "AeAnnc_" + UUID.randomUUID().toString();
        request.setOperation(Operation.CREATE);
        request.setTargetId(url);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setResourceType(10002);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        AEAnnc aeAnnc = new AEAnnc();
        aeAnnc.setName(aeAnncCseName);
        aeAnnc.setAppID("AeAnncAppID_" + UUID.randomUUID());
        aeAnnc.setLink("/" + aeAnnc.getAppID());
        aeAnnc.getAccessControlPolicyIDs().add(createdAcp.getResourceID());
        if (dacis != null) {
            aeAnnc.getDynamicAuthorizationConsultationIDs().addAll(dacis);
        }
        request.setContent((Object)aeAnnc);
        ResponsePrimitive response = this.getCseService().doRequest(request);
        if (response != null && ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
            return (AEAnnc)response.getContent();
        }
        return null;
    }

    protected AE createAe() {
        return this.createAE(null);
    }

    protected AccessControlPolicy createAcp() {
        AccessControlPolicy acp = new AccessControlPolicy();
        acp.setName("ACP" + UUID.randomUUID());
        AccessControlRule acr = new AccessControlRule();
        acr.getAccessControlOriginators().add(Constants.ADMIN_REQUESTING_ENTITY);
        acr.setAccessControlOperations(AccessControl.ALL);
        acp.setPrivileges(new SetOfAcrs());
        acp.getPrivileges().getAccessControlRule().add(acr);
        acp.setSelfPrivileges(new SetOfAcrs());
        AccessControlRule selfAcr = new AccessControlRule();
        selfAcr.setAccessControlOperations(AccessControl.ALL);
        selfAcr.getAccessControlOriginators().add(Constants.ADMIN_REQUESTING_ENTITY);
        acp.getSelfPrivileges().getAccessControlRule().add(selfAcr);
        RequestPrimitive acpCreateRequest = new RequestPrimitive();
        acpCreateRequest.setOperation(Operation.CREATE);
        acpCreateRequest.setRequestContentType("application/obj");
        acpCreateRequest.setReturnContentType("application/obj");
        acpCreateRequest.setResourceType(1);
        acpCreateRequest.setTargetId("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        acpCreateRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        acpCreateRequest.setContent((Object)acp);
        ResponsePrimitive acpCreateResponse = this.getCseService().doRequest(acpCreateRequest);
        if (!ResponseStatusCode.CREATED.equals(acpCreateResponse.getResponseStatusCode())) {
            return null;
        }
        return (AccessControlPolicy)acpCreateResponse.getContent();
    }

    protected AE createAE(List<String> dacis) {
        AccessControlPolicy createdAcp = this.createAcp();
        if (createdAcp == null) {
            return null;
        }
        AE ae = new AE();
        ae.setAppID("1234");
        ae.setAppName("appName" + UUID.randomUUID());
        ae.setName(ae.getAppName());
        ae.setRequestReachability(Boolean.TRUE);
        ae.getAccessControlPolicyIDs().add(createdAcp.getResourceID());
        ae.getPointOfAccess().add("poa_" + UUID.randomUUID());
        if (dacis != null) {
            ae.getDynamicAuthorizationConsultationIDs().addAll(dacis);
        }
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.CREATE);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setResourceType(2);
        request.setTargetId("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setContent((Object)ae);
        ResponsePrimitive response = this.getCseService().doRequest(request);
        if (response != null && ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
            return (AE)response.getContent();
        }
        return null;
    }

    protected FlexContainer createFlexContainer(List<String> dacis) {
        return this.createFlexContainer("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME, dacis);
    }

    protected FlexContainer createFlexContainer(String resourceUrl, List<String> dacis) {
        AccessControlPolicy createdAcp = this.createAcp();
        if (createdAcp == null) {
            return null;
        }
        FlexContainer flexContainer = new FlexContainer();
        flexContainer.setName("FlexContainer_" + UUID.randomUUID());
        flexContainer.setContainerDefinition("myDef");
        flexContainer.getAccessControlPolicyIDs().add(createdAcp.getResourceID());
        if (dacis != null) {
            flexContainer.getDynamicAuthorizationConsultationIDs().addAll(dacis);
        }
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.CREATE);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setResourceType(28);
        request.setTargetId(resourceUrl);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setContent((Object)flexContainer);
        ResponsePrimitive response = this.getCseService().doRequest(request);
        if (response != null && ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
            return (FlexContainer)response.getContent();
        }
        return null;
    }

    protected BinarySwitchFlexContainerAnnc createFlexContainerAnnc(String resourceUrl, List<String> dacis) {
        AccessControlPolicy createdAcp = this.createAcp();
        if (createdAcp == null) {
            return null;
        }
        BinarySwitchFlexContainerAnnc flexContainerAnnc = new BinarySwitchFlexContainerAnnc();
        flexContainerAnnc.setName("FlexContainer_" + UUID.randomUUID());
        flexContainerAnnc.getAccessControlPolicyIDs().add(createdAcp.getResourceID());
        flexContainerAnnc.setLink("/link" + UUID.randomUUID());
        if (dacis != null) {
            flexContainerAnnc.getDynamicAuthorizationConsultationIDs().addAll(dacis);
        }
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.CREATE);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setResourceType(10028);
        request.setTargetId(resourceUrl);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setContent((Object)flexContainerAnnc);
        ResponsePrimitive response = this.getCseService().doRequest(request);
        if (response != null && ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
            return (BinarySwitchFlexContainerAnnc)response.getContent();
        }
        return null;
    }

    protected ResponsePrimitive retrieveEntity(String url) {
        return this.retrieveEntity(url, Constants.ADMIN_REQUESTING_ENTITY);
    }

    protected ResponsePrimitive retrieveEntity(String url, String from) {
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.RETRIEVE);
        request.setTargetId(url);
        request.setFrom(from);
        request.setResourceType(34);
        request.setReturnContentType("application/obj");
        return this.getCseService().doRequest(request);
    }

    protected void deleteEntity(String url) {
        RequestPrimitive request = new RequestPrimitive();
        request.setOperation(Operation.DELETE);
        request.setTargetId(url);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        this.getCseService().doRequest(request);
    }

    public static enum State {
        OK,
        KO;

    }
}

