/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.args;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.om2m.sdt.args.ValuedArg;
import org.eclipse.om2m.sdt.types.DataType;

public abstract class AbstractDateArg
extends ValuedArg<Date> {
    private static final DateFormat dateFormat = DateFormat.getDateInstance();
    private static final DateFormat dateTimeFormat = DateFormat.getDateTimeInstance();
    private static final DateFormat timeFormat = DateFormat.getTimeInstance();
    private DateFormat df;

    protected AbstractDateArg(String name, DataType type) {
        super(name, type);
        if (type.equals(DataType.Date)) {
            this.df = dateFormat;
        } else if (type.equals(DataType.Datetime)) {
            this.df = dateTimeFormat;
        } else if (type.equals(DataType.Time)) {
            this.df = timeFormat;
        }
    }

    @Override
    public void setValue(String v) {
        try {
            this.setValue(this.df.parse(v));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("", e);
        }
    }

    @Override
    public void setValue(long value) {
        this.setValue(new Date(value));
    }

    public String getStringValue() {
        return this.df.format((Date)this.getValue());
    }
}

