/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.subscription;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.Notification;
import org.eclipse.om2m.datamapping.service.DataMapperService;
import org.eclipse.om2m.ipe.sdt.testsuite.subscription.NotificationQueue;
import org.eclipse.om2m.ipe.sdt.testsuite.subscription.ReceivedNotification;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class SubscriptionHttpServlet
extends HttpServlet {
    private static final String SERVLET_PATH_PREFIX = "/subscription_";
    private final String servletPath;
    private final HttpService httpService;
    private final DataMapperService dataMapperService;
    private final NotificationQueue notificationQueue;
    private boolean openToStoreNotification = false;

    public SubscriptionHttpServlet(HttpService pHttpService, DataMapperService pDataMapperService, NotificationQueue pNotificationQueue, String moduleName) {
        this.httpService = pHttpService;
        this.dataMapperService = pDataMapperService;
        this.notificationQueue = pNotificationQueue;
        this.servletPath = SERVLET_PATH_PREFIX + System.currentTimeMillis() + moduleName;
    }

    protected boolean register() {
        try {
            this.httpService.registerServlet(this.servletPath, (Servlet)this, null, null);
        }
        catch (ServletException | NamespaceException e) {
            return false;
        }
        return true;
    }

    protected void unregister() {
        this.httpService.unregister(this.servletPath);
    }

    protected String getServletPath() {
        return this.servletPath;
    }

    protected void storeNotification() {
        this.openToStoreNotification = true;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean verifRequest;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream()));
        String line = null;
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        Notification notification = (Notification)this.dataMapperService.stringToObj(sb.toString());
        boolean bl = verifRequest = notification.isVerificationRequest() != null ? notification.isVerificationRequest() : false;
        if (verifRequest) {
            resp.setStatus(200);
        } else {
            Notification.NotificationEvent notifEvent = notification.getNotificationEvent();
            Notification.NotificationEvent.Representation representation = notifEvent.getRepresentation();
            if (representation.getResource() instanceof AbstractFlexContainer) {
                AbstractFlexContainer notifiedFlexContainer = (AbstractFlexContainer)representation.getResource();
                ReceivedNotification receivedNotification = new ReceivedNotification(notifiedFlexContainer, new Date());
                if (this.openToStoreNotification) {
                    this.notificationQueue.addNotificationFromOM2M(receivedNotification);
                }
            }
            resp.setStatus(200);
        }
    }
}

