/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.FlexContainerFactory;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.testsuite.Activator;
import org.eclipse.om2m.ipe.sdt.testsuite.CSEUtil;
import org.eclipse.om2m.sdt.Action;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.datapoints.AbstractDateDataPoint;
import org.eclipse.om2m.sdt.datapoints.EnumDataPoint;
import org.eclipse.om2m.sdt.datapoints.ValuedDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.types.DataType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DeviceDiscoveryTestSuite {
    private static final String DEVICE_PREFIX = "DEVICE_";
    private final BundleContext bundleContext;
    private final CseService cseService;
    private final ServiceTracker deviceServiceTracker;
    private final List<Device> devices;

    public DeviceDiscoveryTestSuite(BundleContext context, CseService pCseService) {
        this.bundleContext = context;
        this.cseService = pCseService;
        this.devices = new ArrayList<Device>();
        this.deviceServiceTracker = new ServiceTracker(this.bundleContext, Device.class.getName(), new ServiceTrackerCustomizer(){

            public void removedService(ServiceReference reference, Object service) {
                DeviceDiscoveryTestSuite.this.removeDevice((Device)service);
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public Object addingService(ServiceReference reference) {
                Device device = (Device)DeviceDiscoveryTestSuite.this.bundleContext.getService(reference);
                DeviceDiscoveryTestSuite.this.addDevice(device);
                DeviceDiscoveryTestSuite.this.checkDevice(device);
                return device;
            }
        });
        this.deviceServiceTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDevice(Device device) {
        List<Device> list = this.devices;
        synchronized (list) {
            this.devices.add(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDevice(Device device) {
        List<Device> list = this.devices;
        synchronized (list) {
            this.devices.remove(device);
        }
    }

    private void checkDevice(Device device) {
        System.out.println("\n\ncheckDevice(" + device.getId() + "," + device.getName() + ")");
        String deviceLocation = String.valueOf(Activator.SDT_IPE_LOCATION) + "/" + DEVICE_PREFIX + device.getId();
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.cseService, deviceLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            System.out.println("DEVICE NOT FOUND invalid response status code: " + response.getResponseStatusCode());
            return;
        }
        AbstractFlexContainer deviceFlexContainer = (AbstractFlexContainer)response.getContent();
        if (!this.checkName(deviceFlexContainer, DEVICE_PREFIX + device.getId())) {
            System.out.println("invalid name");
            return;
        }
        if (!this.checkContainerDefinition(deviceFlexContainer, device.getDefinition())) {
            System.out.println("invalid definition");
            return;
        }
        for (String propertyName : device.getPropertyNames()) {
            Property property = device.getProperty(propertyName);
            if (property.getName().startsWith("prop")) {
                if (this.checkCustomAttribute(deviceFlexContainer, propertyName, property.getValue())) continue;
                System.out.println("invalid customAttribute name=" + propertyName + ", expectedValue=" + property.getValue());
                return;
            }
            System.out.println("current property(name=" + property.getName() + ", value=" + property.getValue() + ") is not a standard property");
        }
        for (Module module : device.getModules()) {
            String moduleLocation;
            if (this.checkModule(module, moduleLocation = String.valueOf(deviceLocation) + "/" + module.getName())) continue;
            System.out.println("invalid module " + module.getName() + " for device " + device.getDefinition());
            return;
        }
        System.out.println("checkDevice(" + device.getId() + "," + device.getName() + "): OK");
    }

    private boolean checkName(AbstractFlexContainer flexContainer, String expectedName) {
        System.out.println("checkName(expectedName=" + expectedName + ", currentName=" + flexContainer.getName() + ")");
        if (expectedName == null && flexContainer.getName() != null) {
            return false;
        }
        return expectedName.equals(flexContainer.getName());
    }

    private boolean checkContainerDefinition(AbstractFlexContainer flexContainer, String expectedContainerDefinition) {
        System.out.println("checkContainerDefinition(expectedContainerDefinition=" + expectedContainerDefinition + ", currentContainerDefinition=" + flexContainer.getContainerDefinition() + ")");
        if (expectedContainerDefinition == null && flexContainer.getContainerDefinition() != null) {
            return false;
        }
        return expectedContainerDefinition.equals(flexContainer.getContainerDefinition());
    }

    private boolean checkCustomAttribute(AbstractFlexContainer flexContainer, String attributeName, String attributeValue) {
        System.out.println("checkCustomAttribute(name=" + attributeName + ", expectedValue=" + attributeValue + ")");
        CustomAttribute customAttribute = flexContainer.getCustomAttribute(attributeName);
        if (customAttribute == null) {
            System.out.println("checkCustomAttribute(name=" + attributeName + ", expectedValue=" + attributeValue + ") - unexisting customAttribute");
            return false;
        }
        if (attributeValue == null) {
            if (customAttribute.getCustomAttributeValue() != null) {
                System.out.println("checkCustomAttribute(name=" + attributeName + ", expectedValue=" + attributeValue + ") - expecting null value");
                return false;
            }
            return true;
        }
        boolean result = attributeValue.equals(customAttribute.getCustomAttributeValue());
        if (!result) {
            System.out.println("checkCustomAttribute(name=" + attributeName + ", expectedValue=" + attributeValue + ") - found " + customAttribute.getCustomAttributeValue() + "- foundType=" + customAttribute.getCustomAttributeValue().getClass());
        }
        return result;
    }

    private boolean checkModule(Module module, String moduleLocation) {
        System.out.println("checkModule(name=" + module.getName() + ")");
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.cseService, moduleLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            System.out.println("invalid response status code: " + response.getResponseStatusCode());
            return false;
        }
        AbstractFlexContainer moduleFlexContainer = (AbstractFlexContainer)response.getContent();
        if (!this.checkName(moduleFlexContainer, module.getName())) {
            System.out.println("invalid module name");
            return false;
        }
        if (!this.checkContainerDefinition(moduleFlexContainer, module.getDefinition())) {
            System.out.println("invalid module definition");
            return false;
        }
        AbstractFlexContainer moduleClassPropertyFlexContainer = (AbstractFlexContainer)response.getContent();
        for (Property property : module.getProperties()) {
            if (this.checkCustomAttribute(moduleClassPropertyFlexContainer, property.getName(), property.getValue())) continue;
            System.out.println("invalid customProperty (" + property.getName() + ")");
        }
        for (DataPoint dataPoint : module.getDataPoints()) {
            String value = null;
            try {
                Object o = ((ValuedDataPoint)dataPoint).getValue();
                value = dataPoint instanceof AbstractDateDataPoint ? ((AbstractDateDataPoint)dataPoint).getStringValue() : (o != null ? o.toString() : null);
            }
            catch (DataPointException e) {
                System.out.println("unable to retrieve value of dataPoint " + dataPoint.getName());
                return false;
            }
            catch (AccessException e) {
                System.out.println("unable to retrieve value of dataPoint " + dataPoint.getName());
                return false;
            }
            if (this.checkCustomAttribute(moduleFlexContainer, dataPoint.getName(), value)) continue;
            System.out.println("invalid custom attribute for dataPoint " + dataPoint.getName());
            return false;
        }
        for (Action action : module.getActions()) {
            if (this.checkAction(action, String.valueOf(moduleLocation) + "/" + action.getName())) continue;
            System.out.println("invalid Action " + action.getName());
            return false;
        }
        return true;
    }

    private boolean writeDataPoint(Module module, String moduleLocation, DataPoint dataPoint) {
        System.out.println("writeDataPoint(moduleName=" + module.getName() + ", moduleLocation=" + moduleLocation + ", dataPointName=" + dataPoint.getName());
        Object currentValue = null;
        try {
            currentValue = ((ValuedDataPoint)dataPoint).getValue();
        }
        catch (DataPointException e) {
            e.printStackTrace();
            System.out.println("unable to retrieve current value of DataPoint " + dataPoint.getName());
            return false;
        }
        catch (AccessException e) {
            e.printStackTrace();
            System.out.println("unable to retrieve current value of DataPoint " + dataPoint.getName());
            return false;
        }
        String newValue = null;
        if (dataPoint.getDataType().equals((Object)DataType.Boolean)) {
            Boolean currentValueBoolean = (Boolean)currentValue;
            newValue = Boolean.valueOf(currentValueBoolean == false).toString();
        } else if (dataPoint.getDataType().equals((Object)DataType.Integer)) {
            Integer currentValueInteger = (Integer)currentValue;
            if ("red".equals(dataPoint.getName()) || "green".equals(dataPoint.getName()) || "blue".equals(dataPoint.getName())) {
                newValue = String.valueOf(Math.round(Math.random() * 255.0));
            }
        }
        if (newValue != null) {
            AbstractFlexContainer updateFc = FlexContainerFactory.getSpecializationFlexContainer((String)module.getShortDefinitionName());
            CustomAttribute dataPointCA = new CustomAttribute();
            dataPointCA.setCustomAttributeName(dataPoint.getName());
            dataPointCA.setCustomAttributeValue(newValue);
            updateFc.getCustomAttributes().add(dataPointCA);
            ResponsePrimitive response = CSEUtil.updateFlexContainerEntity(this.cseService, moduleLocation, updateFc);
            if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
                System.out.println("fail to update DataPoint " + dataPoint.getName() + " throught the IPE:" + response.getContent());
                return false;
            }
            try {
                currentValue = ((ValuedDataPoint)dataPoint).getValue();
            }
            catch (DataPointException e) {
                e.printStackTrace();
                System.out.println("unable to retrieve new value of DataPoint " + dataPoint.getName());
                return false;
            }
            catch (AccessException e) {
                e.printStackTrace();
                System.out.println("unable to retrieve new value of DataPoint " + dataPoint.getName());
                return false;
            }
            if (!newValue.equals(currentValue.toString())) {
                System.out.println("invalid new Value for DataPoint:" + dataPoint.getName() + "- found =" + currentValue + ",expected:" + newValue);
                return false;
            }
        } else {
            System.out.println("new value is null for DataPoint " + dataPoint.getName() + ", type=" + dataPoint.getDataType());
        }
        return true;
    }

    public boolean checkAction(Action action, String actionLocation) {
        System.out.println("checkAction(name=" + action.getName() + ", location=" + actionLocation + ")");
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.cseService, actionLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            System.out.println("invalid response status code: " + response.getResponseStatusCode());
            return false;
        }
        AbstractFlexContainer actionFlexContainer = (AbstractFlexContainer)response.getContent();
        if (!this.checkContainerDefinition(actionFlexContainer, action.getDefinition())) {
            System.out.println("invalid container definition, expected:" + action.getDefinition() + ", found:" + actionFlexContainer.getContainerDefinition());
            return false;
        }
        if (!this.checkName(actionFlexContainer, action.getName())) {
            System.out.println("invalid name");
            return false;
        }
        for (String name : action.getArgNames()) {
            CustomAttribute ca = actionFlexContainer.getCustomAttribute(name);
            if (ca != null) continue;
            System.out.println("no customAttribute for argument " + name);
            return false;
        }
        AbstractFlexContainer executionFlexContainer = FlexContainerFactory.getSpecializationFlexContainer((String)actionFlexContainer.getShortName());
        for (String name : action.getArgNames()) {
            CustomAttribute ca = new CustomAttribute();
            executionFlexContainer.getCustomAttributes().add(ca);
            ca.setCustomAttributeName(name);
            ca.setCustomAttributeValue("12");
        }
        response = CSEUtil.updateFlexContainerEntity(this.cseService, actionLocation, executionFlexContainer);
        if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            System.out.println("unable to invoke action " + action.getName() + ", reason :" + response.getContent());
            return false;
        }
        return true;
    }

    public boolean checkDataPoint(DataPoint dataPoint, String dataPointLocation) {
        System.out.println("checkDataPoint(name=" + dataPoint.getName() + ", location=" + dataPointLocation + ")");
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.cseService, dataPointLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            System.out.println("invalid response status code: " + response.getResponseStatusCode());
            return false;
        }
        AbstractFlexContainer dataPointFlexContainer = (AbstractFlexContainer)response.getContent();
        if (!this.checkContainerDefinition(dataPointFlexContainer, "org.onem2m.home.datapoint")) {
            System.out.println("invalid container definition");
            return false;
        }
        if (dataPointFlexContainer.getCustomAttributes().size() != 3) {
            System.out.println("invalid number of customAttributes");
            return false;
        }
        if (!this.checkCustomAttribute(dataPointFlexContainer, "name", dataPoint.getName())) {
            System.out.println("invalid name customAttribute");
            return false;
        }
        if (!this.checkCustomAttribute(dataPointFlexContainer, "type", "xs:" + dataPoint.getDataType().getName())) {
            System.out.println("invalid name customAttribute");
            return false;
        }
        try {
            Object value = ((ValuedDataPoint)dataPoint).getValue();
            if (!this.checkCustomAttribute(dataPointFlexContainer, "value", value != null ? value.toString() : null)) {
                System.out.println("invalid value customAttribute");
                return false;
            }
        }
        catch (DataPointException e) {
            System.out.println("unable to get value of DataPoint " + dataPoint.getName());
        }
        catch (AccessException e) {
            System.out.println("unable to get value of DataPoint " + dataPoint.getName());
        }
        AbstractFlexContainer flexContainerToBeUpdated = FlexContainerFactory.getSpecializationFlexContainer((String)dataPointFlexContainer.getShortName());
        CustomAttribute value = new CustomAttribute();
        value.setCustomAttributeName("value");
        String typedRandomValue = DeviceDiscoveryTestSuite.randomValue(dataPoint.getDataType().getName());
        value.setCustomAttributeValue(typedRandomValue);
        flexContainerToBeUpdated.getCustomAttributes().add(value);
        response = CSEUtil.updateFlexContainerEntity(this.cseService, dataPointLocation, flexContainerToBeUpdated);
        if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            System.out.println("unable to update value of DataPoint " + dataPointLocation + ", new value =" + typedRandomValue + ", reason:" + response.getContent());
            return false;
        }
        try {
            Object dataPointValueObject = ((ValuedDataPoint)dataPoint).getValue();
            String dataPointValueString = dataPointValueObject != null ? dataPointValueObject.toString() : null;
            boolean error = false;
            if (dataPointValueString == null) {
                if (typedRandomValue != null) {
                    error = true;
                }
            } else if (!dataPointValueString.equals(typedRandomValue)) {
                if (dataPoint.getDataType().getName().equals("enum")) {
                    String values = (String)((EnumDataPoint)dataPoint).getValue();
                    if (!values.contains(typedRandomValue)) {
                        error = true;
                    }
                } else {
                    error = true;
                }
            }
            if (error) {
                System.out.println("dataPointLocation=" + dataPointLocation + ",expected value=" + typedRandomValue + ", found value=" + dataPointValueString);
                return false;
            }
        }
        catch (DataPointException e) {
            System.out.println("unable to retrieve value from DataPoint:" + e.getMessage());
            e.printStackTrace();
            return false;
        }
        catch (AccessException e) {
            System.out.println("unable to retrieve value from DataPoint:" + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static String randomValue(String type) {
        Random random = new Random();
        switch (type) {
            case "boolean": {
                return Boolean.toString(random.nextBoolean());
            }
            case "integer": {
                return Integer.toString(random.nextInt());
            }
            case "float": {
                return Float.toString(random.nextFloat());
            }
            case "string": {
                return random.toString();
            }
            case "enum": {
                return "enum1";
            }
        }
        return null;
    }
}

