/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.control;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateMemento;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;

public class StateHelper {
    static boolean isRequiredState(int state) {
        if (state <= 7) {
            return true;
        }
        switch (state) {
            case 0: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    static boolean isCUDState(int state, int[] exceptions) {
        if (exceptions != null) {
            int[] nArray = exceptions;
            int n = exceptions.length;
            int n2 = 0;
            while (n2 < n) {
                int exception = nArray[n2];
                if (state == exception) {
                    return false;
                }
                ++n2;
            }
        }
        switch (state) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    static boolean unitHasState(CompilationUnitDeclaration unit, int state) {
        if (unit.types == null) {
            return false;
        }
        TypeDeclaration[] typeDeclarationArray = unit.types;
        int n = unit.types.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration type = typeDeclarationArray[n2];
            if (!StateHelper.hasState(type.binding, state)) {
                return false;
            }
            ++n2;
        }
        unit.state.setState(state);
        return true;
    }

    public static boolean hasState(ReferenceBinding clazz, int state) {
        if (clazz == null) {
            return false;
        }
        return StateHelper.getState(clazz).getState() >= state;
    }

    public static int minimalState(ReferenceBinding[] types) {
        int s = 25;
        ReferenceBinding[] referenceBindingArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding type = referenceBindingArray[n2];
            int s1 = StateHelper.getState(type).getState();
            if (s1 < s) {
                s = s1;
            }
            ++n2;
        }
        return s;
    }

    public static void setStateRecursive(CompilationUnitDeclaration unit, int state, boolean markRoleUnits) {
        LocalTypeBinding[] localTypes;
        int requested = 0;
        unit.state.setState(state);
        TypeDeclaration[] types = unit.types;
        if (types != null) {
            int t = 0;
            while (t < types.length) {
                int roleRequest;
                StateHelper.setStateRecursive(types[t], state, markRoleUnits);
                if (types[t].isRole() && (roleRequest = types[t].getRoleModel()._state.fetchRequestedState()) > requested) {
                    requested = roleRequest;
                }
                ++t;
            }
        }
        if ((localTypes = unit.localTypes) != null) {
            int t = 0;
            while (t < unit.localTypeCount) {
                if (localTypes[t].scope != null) {
                    ClassScope scope = localTypes[t].scope;
                    if (scope.referenceContext != null) {
                        StateHelper.setStateRecursive(scope.referenceContext, state, markRoleUnits);
                    }
                }
                ++t;
            }
        }
        unit.state.handleRequest(unit, requested);
    }

    public static void setStateRecursive(TypeDeclaration decl, int state, boolean markRoleUnit) {
        TypeModel model;
        boolean processed = false;
        if (decl.isTeam()) {
            model = decl.getTeamModel();
            model.setState(state);
            processed = true;
        }
        if (decl.isRole()) {
            boolean handlingRoleFileImports;
            boolean bl = handlingRoleFileImports = decl.isRoleFile() && state == 5;
            if (!handlingRoleFileImports || markRoleUnit) {
                model = decl.getRoleModel();
                model.setState(state);
                if (decl.compilationUnit != null) {
                    decl.compilationUnit.state.setState(state);
                }
            }
            processed = true;
        }
        if (!processed) {
            model = decl.getModel();
            model.setState(state);
        }
        if (decl.memberTypes != null) {
            int i = 0;
            while (i < decl.memberTypes.length) {
                StateHelper.setStateRecursive(decl.memberTypes[i], state, markRoleUnit);
                ++i;
            }
        }
    }

    public static boolean isReadyToProcess(TypeModel model, int state) {
        ReferenceBinding role;
        if (!model.isReadyToProcess(state)) {
            return false;
        }
        if (model.isRole() && StateHelper.isCUDState(state, null) && (role = model.getBinding()) != null && role.enclosingType() != null) {
            return StateHelper.hasState(role.enclosingType(), state) || StateHelper.isReadyToProcess(role.enclosingType().getTeamModel(), state);
        }
        return true;
    }

    public static boolean isReadyToProcess(SourceTypeBinding type, int state) {
        if (type.isRole() && !StateHelper.isReadyToProcess(type.roleModel, state)) {
            return false;
        }
        if (type.isTeam() && !StateHelper.isReadyToProcess(type.getTeamModel(), state)) {
            return false;
        }
        return StateHelper.isReadyToProcess(type.model, state);
    }

    public static boolean isDefinitelyReadyToProcess(ReferenceBinding type, ReferenceBinding requestingSite, int state) {
        if (!(type instanceof SourceTypeBinding)) {
            return false;
        }
        SourceTypeBinding sourceType = (SourceTypeBinding)type;
        if (TypeBinding.equalsEquals(sourceType.outermostEnclosingType().erasure(), requestingSite.outermostEnclosingType().erasure()) || CharOperation.equals(type.getFileName(), requestingSite.getFileName())) {
            return false;
        }
        if (!StateHelper.isReadyToProcess(sourceType, state)) {
            return false;
        }
        try {
            StateMemento unitState = sourceType.scope.compilationUnitScope().referenceContext.state;
            if (unitState.isReadyToProcess(state)) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static boolean startProcessing(TypeDeclaration type, int state, int step) {
        if (type.isRole()) {
            RoleModel roleModel = type.getRoleModel();
            if (roleModel.getTeamModel()._state.isBlocking(roleModel.getTeamModel(), state, step)) {
                return false;
            }
            roleModel._state.startProcessing(state, step);
        }
        if (type.isTeam()) {
            type.getTeamModel()._state.startProcessing(state, step);
        }
        return true;
    }

    static StateMemento getState(ReferenceBinding type) {
        TypeModel model = null;
        if (type.isTeam()) {
            model = type.getTeamModel();
        } else if (type.isRole()) {
            model = type.roleModel;
        }
        if (model == null) {
            model = type.model;
        }
        return model._state;
    }
}

