/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObject;

public class ConstantPoolObjectWriter
implements ClassFileConstants {
    private ClassFile dstClassFile;

    public ConstantPoolObjectWriter(ClassFile dstClassFile) {
        this.dstClassFile = dstClassFile;
        if (this.dstClassFile.codeStream.constantPool == null) {
            this.dstClassFile.codeStream.constantPool = this.dstClassFile.constantPool;
        }
    }

    int writeConstantPoolObject(ConstantPoolObject cpo) {
        int type = cpo.getType();
        switch (type) {
            case 8: {
                return this.dstClassFile.constantPool.literalIndex(cpo.getString());
            }
            case 3: {
                return this.dstClassFile.constantPool.literalIndex(cpo.getInteger());
            }
            case 4: {
                return this.dstClassFile.constantPool.literalIndex(cpo.getFloat());
            }
            case 5: {
                return this.dstClassFile.constantPool.literalIndex(cpo.getLong());
            }
            case 6: {
                return this.dstClassFile.constantPool.literalIndex(cpo.getDouble());
            }
            case 7: {
                return this.dstClassFile.codeStream.recordTypeBinding(cpo.getClassObject());
            }
            case 9: {
                FieldBinding fieldBinding = cpo.getFieldRef();
                if ((fieldBinding.otBits & 1) != 0) {
                    fieldBinding = fieldBinding.model.getOriginalFromFake();
                }
                return this.dstClassFile.constantPool.literalIndexForField(fieldBinding.declaringClass.constantPoolName(), fieldBinding.name, fieldBinding.type.signature());
            }
            case 10: {
                MethodBinding methodBinding = cpo.getMethodRef();
                return this.dstClassFile.constantPool.literalIndexForMethod(methodBinding.declaringClass.constantPoolName(), methodBinding.selector, methodBinding.signature(), false);
            }
            case 11: {
                MethodBinding methodBinding = cpo.getInterfaceMethodRef();
                return this.dstClassFile.constantPool.literalIndexForMethod(methodBinding.declaringClass.constantPoolName(), methodBinding.selector, methodBinding.signature(), true);
            }
            case 1: {
                return this.dstClassFile.constantPool.literalIndex(cpo.getUtf8());
            }
        }
        throw new RuntimeException();
    }

    public void writeConstantPoolObject(byte[] code, int offset, int length, ConstantPoolObject cpo) {
        int index = this.writeConstantPoolObject(cpo);
        switch (length) {
            case 1: {
                this.write1(code, offset, index);
                break;
            }
            case 2: {
                this.write2(code, offset, index);
                break;
            }
            default: {
                throw new InternalCompilerError("unexpected value length " + length);
            }
        }
    }

    public void writeUtf8(byte[] code, int offset, char[] value) {
        int index = this.dstClassFile.constantPool.literalIndex(value);
        this.write2(code, offset, index);
    }

    public void write2(byte[] code, int offset, int value) {
        code[offset] = (byte)(value >> 8);
        code[offset + 1] = (byte)value;
    }

    private void write1(byte[] code, int offset, int value) {
        code[offset] = (byte)value;
    }
}

