/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.debug.internal.breakpoints.OOTBreakpoints;

public class TeamBreakpointInstaller {
    private static Hashtable<String, IBreakpoint> OT_BREAKPOINTS = new Hashtable(5);

    public static void installTeamBreakpoints(IJavaProject project) throws CoreException {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                boolean done = false;
                if (OT_BREAKPOINTS.size() == 0) {
                    done = true;
                } else {
                    DebugEvent[] debugEventArray = events;
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugEvent event = debugEventArray[n2];
                        if (event.getKind() == 4 && event.getSource() instanceof IJavaDebugTarget) {
                            IDebugTarget debugTarget = ((IJavaDebugTarget)event.getSource()).getDebugTarget();
                            for (IBreakpoint bp : OT_BREAKPOINTS.values()) {
                                debugTarget.breakpointAdded(bp);
                            }
                            done = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (done) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
            }
        });
        try {
            IType oot = project.findType(new String(IOTConstants.STR_ORG_OBJECTTEAMS_TEAM));
            if (oot != null) {
                if (!OT_BREAKPOINTS.containsKey("org.eclipse.objectteams.otdt.debug.TeamBreakpoint.Constructor")) {
                    OT_BREAKPOINTS.put("org.eclipse.objectteams.otdt.debug.TeamBreakpoint.Constructor", OOTBreakpoints.createOOTConstructorBreakpoint(oot));
                }
                if (!OT_BREAKPOINTS.containsKey("org.eclipse.objectteams.otdt.debug.TeamBreakpoint.FinalizeMethod")) {
                    OT_BREAKPOINTS.put("org.eclipse.objectteams.otdt.debug.TeamBreakpoint.FinalizeMethod", OOTBreakpoints.createOOTFinalizeBreakpoint(oot));
                }
                if (!OT_BREAKPOINTS.containsKey("org.eclipse.objectteams.otdt.debug.TeamBreakpoint.ActivateMethod")) {
                    OT_BREAKPOINTS.put("org.eclipse.objectteams.otdt.debug.TeamBreakpoint.ActivateMethod", OOTBreakpoints.createOOTActivateBreakpoint(oot));
                }
                if (!OT_BREAKPOINTS.containsKey("org.eclipse.objectteams.otdt.debug.TeamBreakpoint.DeactivateMethod")) {
                    OT_BREAKPOINTS.put("org.eclipse.objectteams.otdt.debug.TeamBreakpoint.DeactivateMethod", OOTBreakpoints.createOOTDeactivateBreakpoint(oot));
                }
                if (!OT_BREAKPOINTS.containsKey("org.eclipse.objectteams.otdt.debug.TeamBreakpoint.ImplicitActivateMethod")) {
                    OT_BREAKPOINTS.put("org.eclipse.objectteams.otdt.debug.TeamBreakpoint.ImplicitActivateMethod", OOTBreakpoints.createOOTImplicitActivateBreakpoint(oot));
                }
                if (!OT_BREAKPOINTS.containsKey("org.eclipse.objectteams.otdt.debug.TeamBreakpoint.ImplicitDeactivateMethod")) {
                    OT_BREAKPOINTS.put("org.eclipse.objectteams.otdt.debug.TeamBreakpoint.ImplicitDeactivateMethod", OOTBreakpoints.createOOTImplicitDeactivateBreakpoint(oot));
                }
            }
        }
        catch (JavaModelException ex) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.objectteams.otdt.debug", 0, "Cannot set breakpoints for team-activation tracking", (Throwable)ex));
        }
    }

    public static void uninstallTeamBreakpoints() throws CoreException {
        OT_BREAKPOINTS.clear();
    }
}

