/**
 * 
 */
package banking.operations;

import base world.PrepaidPhone;
import base world.Account;

/**
 * @author stephan
 *
 */
public team class Transfer {
	protected class PhoneSink implements ISink playedBy PrepaidPhone {

		void accept(int amount) -> void load(int amount);
	
	}
	protected interface ISource {

		boolean withdraw(int amount);

	}

	protected interface ISink {
		void accept(int amount);
	}

	protected class SourceAccount implements ISource playedBy Account 
	{
		void decreaseBalance(int amount) -> void decreaseBalance(int amount);

		int getBalance() -> int getBalance();

		public boolean withdraw(int amount) {
			if (amount > getBalance())
				return false;
			decreaseBalance(amount);
			return true;
		}
	}

	protected class SinkAccount implements ISink playedBy Account {

		void accept(int amount) -> void increaseBalance(int amount);
		
	}
	
	protected void doTransfer(ISource src, ISink sink, int amount) {
		if (src.withdraw(amount))
			sink.accept(amount);
	}
	public void accountTransfer(Account as SourceAccount src, Account as ISink sink, int amount) 
	{
		doTransfer(src, sink, amount);
	}
	public void transferToPhone(Account as SourceAccount src, PrepaidPhone as ISink sink, int amount) 
	{
		doTransfer(src, sink, amount);
	}
}
