/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items = new TabItem[0];
    int selectedIndex = -1;
    int xClient;
    int yClient;
    int imageHeight = -1;
    int topTabIndex = 0;
    boolean scrollButtonDown = false;
    boolean inDispose = false;
    String toolTipText;
    static final int SCROLL_BUTTON_SIZE = 20;
    static final int CLIENT_MARGIN_WIDTH = 2;
    static final int SELECTED_TAB_TOP_EXPANSION = 2;
    static final int SELECTED_TAB_HORIZONTAL_EXPANSION = 2;

    public TabFolder(Composite composite, int n) {
        super(composite, TabFolder.checkStyle(n));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TabFolder.this.handleEvents(event);
            }
        };
        this.addListener(12, listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(32, listener);
        this.addListener(9, listener);
        this.addListener(31, listener);
        this.addListener(1, listener);
        this.addListener(15, listener);
        this.addListener(16, listener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        n = TabFolder.checkBits(n, 128, 1024, 0, 0, 0, 0);
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point = super.computeSize(n, n2, bl);
        if (this.items.length > 0) {
            TabItem tabItem = this.items[this.items.length - 1];
            int n3 = this.getBorderWidth();
            int n4 = tabItem.x + tabItem.width + n3 * 2 + 4 + 4;
            point.x = Math.max(n4, point.x);
        }
        return point;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = this.getBorderWidth();
        int n6 = n - n5 - 2 - 2;
        int n7 = n2 - n5 - 2 - 2;
        int n8 = 0;
        if (this.items.length > 0) {
            TabItem tabItem = this.items[0];
            n8 = tabItem.y + tabItem.height;
        }
        int n9 = n3 + n5 * 2 + 4 + 4;
        int n10 = n4 + n8 + n5 * 2 + 4 + 4;
        return new Rectangle(n6, n7 - n8, n9, n10);
    }

    void createChild(TabItem tabItem, int n) {
        boolean bl = this.isTabScrolling();
        if (n < 0 || n > this.getItemCount()) {
            this.error(6);
        }
        tabItem.parent = this;
        TabItem[] tabItemArray = new TabItem[this.items.length + 1];
        System.arraycopy(this.items, 0, tabItemArray, 0, n);
        tabItemArray[n] = tabItem;
        System.arraycopy(this.items, n, tabItemArray, n + 1, this.items.length - n);
        this.items = tabItemArray;
        if (this.selectedIndex >= n) {
            ++this.selectedIndex;
        }
        this.layoutItems();
        this.redrawTabs();
        if (this.isTabScrolling() != bl && !bl) {
            this.redrawScrollButtons();
        }
        if (this.getItemCount() == 1) {
            this.setSelection(0, true);
        }
    }

    void destroyChild(TabItem tabItem) {
        int n = this.indexOf(tabItem);
        if (n == -1) {
            return;
        }
        if (this.items.length == 1) {
            this.items = new TabItem[0];
            this.selectedIndex = -1;
            this.topTabIndex = 0;
            if (!this.inDispose) {
                Control control = tabItem.control;
                if (control != null && !control.isDisposed()) {
                    control.setVisible(false);
                }
                this.redraw();
            }
        } else {
            TabItem[] tabItemArray = new TabItem[this.items.length - 1];
            System.arraycopy(this.items, 0, tabItemArray, 0, n);
            System.arraycopy(this.items, n + 1, tabItemArray, n, this.items.length - n - 1);
            this.items = tabItemArray;
            if (this.selectedIndex == n) {
                if (!this.inDispose) {
                    Control control = tabItem.control;
                    if (control != null && !control.isDisposed()) {
                        control.setVisible(false);
                    }
                    this.selectedIndex = -1;
                    this.setSelection(Math.max(0, n - 1), true);
                }
            } else if (this.selectedIndex > n) {
                --this.selectedIndex;
            }
            if (this.topTabIndex == this.items.length) {
                --this.topTabIndex;
            }
        }
        if (this.topTabIndex > 0 && !this.isTabScrolling()) {
            this.topTabIndex = 0;
        }
        if (!this.inDispose) {
            this.layoutItems();
            this.redrawTabs();
        }
    }

    void doDispose(Event event) {
        if (this.inDispose) {
            return;
        }
        this.inDispose = true;
        this.notifyListeners(12, event);
        event.type = 0;
        while (this.items.length > 0) {
            if (this.items[this.items.length - 1] == null) continue;
            this.items[this.items.length - 1].dispose();
        }
    }

    void drawArrow(GC gC, int n, int n2, int n3, boolean bl) {
        int n4 = n3 / 4;
        int[] nArray = new int[6];
        if (!bl) {
            n4 *= -1;
        }
        nArray[0] = n + (n3 + n4) / 2;
        nArray[1] = n2 + n3 / 4;
        nArray[2] = nArray[0];
        nArray[3] = nArray[1] + n3 / 2;
        nArray[4] = nArray[0] - n4;
        nArray[5] = n2 + n3 / 2;
        gC.setBackground(this.getForeground());
        gC.fillPolygon(nArray);
        gC.setBackground(this.getBackground());
    }

    void drawBorder(Event event) {
        GC gC = event.gc;
        Rectangle rectangle = this.getClientArea();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Color color = this.display.getSystemColor(20);
        Color color2 = this.display.getSystemColor(19);
        gC.setForeground(color);
        int n3 = this.xClient - 2;
        int n4 = this.yClient - 2;
        gC.drawLine(n3, this.yClient + n2 + 2, n3, n4 + 1);
        gC.setForeground(color2);
        gC.drawLine(n3 + 1, this.yClient + n2 + 2, n3 + 1, n4 + 1);
        gC.setForeground(color);
        if (this.selectedIndex == -1) {
            gC.setForeground(color2);
            gC.drawLine(n3 + 1, n4 + 1, this.xClient + n + 2, n4 + 1);
        } else {
            TabItem tabItem = this.items[this.selectedIndex];
            gC.setForeground(color2);
            if (this.selectedIndex > 0) {
                gC.drawLine(n3 + 1, n4 + 1, tabItem.x - 1 + 2, n4 + 1);
            }
            gC.drawLine(tabItem.x + tabItem.width, n4 + 1, this.xClient + n + 2, n4 + 1);
        }
        gC.setForeground(this.display.getSystemColor(21));
        n3 = this.xClient - 2;
        n4 = this.yClient + n2 + 2;
        int n5 = this.xClient + n + 2;
        gC.drawLine(n3, n4, n5, n4);
        int n6 = this.yClient - 2 + 1;
        gC.drawLine(n5, n4, n5, n6);
        gC.setForeground(this.display.getSystemColor(18));
        gC.drawLine(++n3, --n4, --n5, n4);
        gC.drawLine(n5, n4 - 1, n5, ++n6);
        gC.setForeground(this.getForeground());
    }

    void drawPlainButton(GC gC, int n, int n2, int n3) {
        Color color = this.getForeground();
        Color color2 = this.display.getSystemColor(18);
        Color color3 = this.display.getSystemColor(17);
        Color color4 = this.display.getSystemColor(19);
        int n4 = n2;
        int n5 = n;
        int n6 = n2 + n3 - 1;
        int n7 = n + n3 - 1;
        if (this.scrollButtonDown) {
            color = this.display.getSystemColor(19);
            color2 = this.display.getSystemColor(17);
            color3 = this.display.getSystemColor(18);
            color4 = this.getForeground();
        }
        gC.fillRectangle(n5, n4, n7 - n5, n6 - n4);
        gC.setForeground(color);
        gC.drawLine(n7, n4, n7, n6);
        gC.drawLine(n5, n6, n7, n6);
        gC.setForeground(color2);
        gC.drawLine(n5, n4, n5, n6 - 1);
        gC.drawLine(n5, n4, n7 - 1, n4);
        gC.setForeground(color3);
        gC.drawLine(--n7, ++n4, n7, --n6);
        gC.drawLine(++n5, n6, n7, n6);
        gC.setForeground(color4);
        gC.drawLine(n5, n4, n5, n6 - 1);
        gC.drawLine(n5, n4, n7 - 1, n4);
        gC.setForeground(this.getForeground());
    }

    void drawScrollButtons(Event event) {
        Rectangle rectangle = this.getScrollButtonArea();
        int n = rectangle.width / 2;
        this.drawPlainButton(event.gc, rectangle.x, rectangle.y, n);
        this.drawPlainButton(event.gc, rectangle.x + n, rectangle.y, n);
        if (this.scrollButtonDown) {
            this.drawArrow(event.gc, rectangle.x, rectangle.y, n, true);
            this.drawArrow(event.gc, rectangle.x + n + 1, rectangle.y, n + 1, false);
        } else {
            this.drawArrow(event.gc, rectangle.x - 1, rectangle.y - 1, n, true);
            this.drawArrow(event.gc, rectangle.x + n, rectangle.y - 1, n, false);
        }
    }

    void ensureRightFreeSpaceUsed() {
        if (this.topTabIndex > 0 && !this.isTabScrolling()) {
            this.topTabIndex = 0;
            this.layoutItems();
            this.redrawTabs();
        }
    }

    void ensureVisible(int n) {
        if (n < 0 || n >= this.items.length) {
            return;
        }
        if (!this.isTabScrolling()) {
            return;
        }
        if (n < this.topTabIndex) {
            this.topTabIndex = n;
            this.layoutItems();
            this.redrawTabs();
            return;
        }
        int n2 = this.getScrollButtonArea().x;
        TabItem tabItem = this.items[n];
        while (tabItem.x + tabItem.width > n2 && n != this.topTabIndex) {
            ++this.topTabIndex;
            this.layoutItems();
            this.redrawTabs();
        }
    }

    void focus(Event event) {
        if (this.selectedIndex == -1) {
            return;
        }
        TabItem tabItem = this.items[this.selectedIndex];
        this.redraw(tabItem.x, tabItem.y, tabItem.width, tabItem.height);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle rectangle = super.getClientArea();
        if (this.yClient == 0) {
            this.layoutItems();
        }
        rectangle.x = this.xClient;
        rectangle.y = this.yClient;
        rectangle.width = Math.max(0, rectangle.width - (this.xClient + 2 + 1));
        rectangle.height = Math.max(0, rectangle.height - (this.yClient + 2 + 1));
        return rectangle;
    }

    int getImageHeight() {
        return this.imageHeight;
    }

    public TabItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.getItemCount()) {
            this.error(6);
        }
        return this.items[n];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = this.items[n2];
            Rectangle rectangle = tabItem.getBounds();
            if (rectangle.contains(point)) {
                return tabItem;
            }
            ++n2;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        TabItem[] tabItemArray = new TabItem[this.items.length];
        System.arraycopy(this.items, 0, tabItemArray, 0, this.items.length);
        return tabItemArray;
    }

    char getMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return string.charAt(n);
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    Rectangle getScrollButtonArea() {
        return new Rectangle(super.getClientArea().width - 40, 2, 40, 20);
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        if (this.selectedIndex == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[this.selectedIndex]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.selectedIndex;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void handleEvents(Event event) {
        switch (event.type) {
            case 12: {
                this.doDispose(event);
                break;
            }
            case 9: {
                this.paint(event);
                break;
            }
            case 3: {
                this.mouseDown(event);
                break;
            }
            case 4: {
                this.mouseUp(event);
                break;
            }
            case 32: {
                this.mouseHover(event);
                break;
            }
            case 31: {
                this.traversal(event);
                break;
            }
            case 15: 
            case 16: {
                this.focus(event);
                break;
            }
            case 1: {
                this.keyDown(event);
                break;
            }
        }
    }

    public int indexOf(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.items.length) {
            if (this.items[n] == tabItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    boolean isLeftButtonHit(Event event) {
        Rectangle rectangle = this.getScrollButtonArea();
        rectangle.width /= 2;
        return this.isTabScrolling() && event.button == 1 && rectangle.contains(event.x, event.y);
    }

    boolean isRightButtonHit(Event event) {
        Rectangle rectangle = this.getScrollButtonArea();
        int n = rectangle.width / 2;
        rectangle.x += n;
        rectangle.width = n;
        return this.isTabScrolling() && event.button == 1 && rectangle.contains(event.x, event.y);
    }

    boolean isTabScrolling() {
        boolean bl = false;
        if (this.items.length > 0) {
            TabItem tabItem = this.items[this.items.length - 1];
            int n = tabItem.x + tabItem.width;
            tabItem = this.items[0];
            if (n - tabItem.x > super.getClientArea().width) {
                bl = true;
            }
        }
        return bl;
    }

    void itemChanged(TabItem tabItem) {
        Image image = tabItem.getImage();
        boolean bl = this.isTabScrolling();
        if (this.imageHeight == -1 && image != null) {
            this.imageHeight = image.getBounds().height;
        }
        this.layoutItems();
        this.redrawTabs();
        if (this.isTabScrolling() != bl && !bl) {
            this.redrawScrollButtons();
        }
    }

    void keyDown(Event event) {
        int n = this.items.length;
        if (n <= 1) {
            return;
        }
        switch (event.keyCode) {
            case 0x1000004: {
                if (this.selectedIndex >= this.items.length - 1) break;
                this.setSelection(this.selectedIndex + 1, true);
                break;
            }
            case 0x1000003: {
                if (this.selectedIndex <= 0) break;
                this.setSelection(this.selectedIndex - 1, true);
                break;
            }
            case 0x1000007: {
                if (this.selectedIndex <= 0) break;
                this.setSelection(0, true);
                break;
            }
            case 0x1000008: {
                if (this.selectedIndex >= n - 1) break;
                this.setSelection(n - 1, true);
            }
        }
    }

    void layoutItems() {
        TabItem tabItem;
        int n = 2;
        int n2 = 2;
        int n3 = 0;
        GC gC = new GC(this);
        int n4 = this.topTabIndex - 1;
        while (n4 >= 0) {
            tabItem = this.items[n4];
            tabItem.width = tabItem.preferredWidth(gC);
            tabItem.height = tabItem.preferredHeight(gC);
            tabItem.x = n -= tabItem.width;
            tabItem.y = n2;
            if (tabItem.height > n3) {
                n3 = tabItem.height;
            }
            --n4;
        }
        n = 2;
        n4 = this.topTabIndex;
        while (n4 < this.items.length) {
            tabItem = this.items[n4];
            tabItem.x = n;
            tabItem.y = n2;
            tabItem.width = tabItem.preferredWidth(gC);
            tabItem.height = tabItem.preferredHeight(gC);
            n += tabItem.width;
            if (tabItem.height > n3) {
                n3 = tabItem.height;
            }
            ++n4;
        }
        gC.dispose();
        this.xClient = 2;
        this.yClient = 2 + n3;
        TabItem[] tabItemArray = this.getSelection();
        if (tabItemArray.length > 0) {
            tabItemArray[0].expand(2, 2, 2, 0);
        }
    }

    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < controlArray.length) {
            SerializableCompatibility serializableCompatibility;
            Control control = controlArray[n5];
            int n6 = 0;
            while (n6 < this.items.length) {
                if (this.items[n6].control == control) break;
                ++n6;
            }
            if (n6 == this.items.length) {
                serializableCompatibility = control.getBounds();
                n3 = Math.max(n3, serializableCompatibility.x + serializableCompatibility.width);
                n4 = Math.max(n4, serializableCompatibility.y + serializableCompatibility.height);
            } else {
                serializableCompatibility = control.computeSize(n, n2, bl);
                n3 = Math.max(n3, ((Point)serializableCompatibility).x);
                n4 = Math.max(n4, ((Point)serializableCompatibility).y);
            }
            ++n5;
        }
        return new Point(n3, n4);
    }

    boolean mnemonicHit(char c) {
        int n = 0;
        while (n < this.items.length) {
            char c2 = this.getMnemonic(this.items[n].getText());
            if (c2 != '\u0000' && Character.toUpperCase(c) == Character.toUpperCase(c2) && this.forceFocus()) {
                if (n != this.selectedIndex) {
                    this.setSelection(n, true);
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    void mouseDown(Event event) {
        if (this.isLeftButtonHit(event)) {
            this.scrollButtonDown = true;
            this.redrawHitButton(event);
            this.scrollLeft();
        } else if (this.isRightButtonHit(event)) {
            this.scrollButtonDown = true;
            this.redrawHitButton(event);
            this.scrollRight();
        } else {
            int n = 0;
            while (n < this.items.length) {
                if (this.items[n].getBounds().contains(new Point(event.x, event.y))) {
                    this.forceFocus();
                    this.setSelection(n, true);
                    return;
                }
                ++n;
            }
        }
    }

    void mouseHover(Event event) {
        String string = super.getToolTipText();
        if (this.toolTipText == null) {
            Point point = new Point(event.x, event.y);
            int n = 0;
            while (n < this.items.length) {
                if (this.items[n].getBounds().contains(point)) {
                    String string2 = this.items[n].getToolTipText();
                    if (string2 != null && !string2.equals(string)) {
                        super.setToolTipText(string2);
                    }
                    return;
                }
                ++n;
            }
            if (string != null) {
                super.setToolTipText(null);
            }
            return;
        }
        if (!this.toolTipText.equals(string)) {
            super.setToolTipText(this.toolTipText);
        }
    }

    void mouseUp(Event event) {
        if (this.scrollButtonDown && event.button == 1) {
            this.scrollButtonDown = false;
            this.redrawHitButton(event);
        }
    }

    void paint(Event event) {
        int n = 0;
        while (n < this.getItemCount()) {
            if (n != this.selectedIndex && event.getBounds().intersects(this.items[n].getBounds())) {
                this.items[n].paint(event.gc, false);
            }
            ++n;
        }
        this.drawBorder(event);
        if (this.selectedIndex != -1) {
            this.items[this.selectedIndex].paint(event.gc, true);
        }
        if (this.isTabScrolling()) {
            this.drawScrollButtons(event);
        }
    }

    void redraw(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getScrollButtonArea();
        boolean bl = false;
        if (this.isTabScrolling()) {
            if (n > rectangle.x) {
                n = rectangle.x;
                bl = true;
            }
            if (n + n3 > rectangle.x) {
                n3 = rectangle.x - n;
                bl = true;
            }
        }
        this.redraw(n, n2, n3, n4, false);
        if (bl) {
            this.redraw(rectangle.x, 0, rectangle.width, rectangle.y, false);
            if (rectangle.height < this.getClientArea().y) {
                int n5 = rectangle.y + rectangle.height;
                this.redraw(rectangle.x, n5, rectangle.width, this.getClientArea().y - n5, false);
            }
        }
    }

    void redrawHitButton(Event event) {
        Rectangle rectangle = this.getScrollButtonArea();
        int n = rectangle.width / 2;
        if (this.isLeftButtonHit(event)) {
            this.redraw(rectangle.x, rectangle.y, n, rectangle.height, false);
        } else if (this.isRightButtonHit(event)) {
            this.redraw(rectangle.x + n, rectangle.y, n, rectangle.height, false);
        }
    }

    void redrawScrollButtons() {
        Rectangle rectangle = this.getScrollButtonArea();
        this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
    }

    void redrawSelectionChange(int n, int n2) {
        TabItem tabItem;
        if (n != -1) {
            tabItem = this.items[n];
            this.redraw(tabItem.x - 2, tabItem.y - 2, tabItem.width + 4, tabItem.height + 2);
        }
        if (n2 != -1) {
            tabItem = this.items[n2];
            this.redraw(tabItem.x, tabItem.y, tabItem.width, tabItem.height);
        }
        this.update();
    }

    void redrawTabs() {
        this.redraw(0, 0, super.getClientArea().width, this.getClientArea().y);
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n = 0;
        while (n < this.items.length) {
            TabItem tabItem = this.items[n];
            if (tabItem.control == control) {
                tabItem.setControl(null);
            }
            ++n;
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    void resize() {
        Control control;
        if (this.selectedIndex != -1 && (control = this.items[this.selectedIndex].getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
        }
        this.ensureRightFreeSpaceUsed();
    }

    void scrollLeft() {
        if (this.topTabIndex > 0) {
            --this.topTabIndex;
            this.layoutItems();
            this.redrawTabs();
        }
    }

    void scrollRight() {
        if (this.items.length > 0 && this.topTabIndex < this.items.length - 1) {
            TabItem tabItem = this.items[this.items.length - 1];
            int n = tabItem.x + tabItem.width;
            if (n > super.getClientArea().width - 40) {
                ++this.topTabIndex;
                this.layoutItems();
                this.redrawTabs();
            }
        }
    }

    boolean setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3 && bl2) {
            this.resize();
        }
        return bl3;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.layoutItems();
        this.redrawTabs();
    }

    public void setSelection(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        this.setSelection(n, false);
    }

    public void setSelection(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        int n = -1;
        if (tabItemArray.length > 0) {
            n = this.indexOf(tabItemArray[0]);
        }
        this.setSelection(n, false);
    }

    void setSelection(int n, boolean bl) {
        Object object;
        if (this.selectedIndex == n) {
            return;
        }
        int n2 = this.selectedIndex;
        if (this.selectedIndex == n || n >= this.getItemCount()) {
            return;
        }
        if (this.selectedIndex != -1 && (object = this.items[this.selectedIndex].control) != null && !((Widget)object).isDisposed()) {
            ((Control)object).setVisible(false);
        }
        if (n < 0) {
            n = -1;
        }
        this.selectedIndex = n;
        this.layoutItems();
        this.ensureVisible(n);
        this.redrawSelectionChange(n2, n);
        if (n >= 0 && (object = this.items[n].control) != null && !((Widget)object).isDisposed()) {
            ((Control)object).setBounds(this.getClientArea());
            ((Control)object).setVisible(true);
        }
        if (bl && this.selectedIndex != n2 && this.selectedIndex != -1) {
            object = new Event();
            ((Event)object).item = this.getSelection()[0];
            this.notifyListeners(13, (Event)object);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.toolTipText = string;
    }

    void traversal(Event event) {
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 128: 
            case 256: 
            case 512: {
                event.doit = true;
            }
        }
    }

    boolean traverseItem(boolean bl) {
        return false;
    }

    boolean traversePage(boolean bl) {
        int n = this.items.length;
        if (n == 0) {
            return false;
        }
        int n2 = this.selectedIndex;
        if (n2 == -1) {
            n2 = 0;
        } else {
            int n3 = bl ? 1 : -1;
            n2 = (n2 + n3 + n) % n;
        }
        this.setSelection(n2, true);
        return true;
    }
}

