/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class ClipboardProxy {
    Display display;
    int shellHandle;
    int atomAtom;
    int clipboardAtom;
    int motifClipboardAtom;
    int primaryAtom;
    int targetsAtom;
    int[][] convertData = new int[10][3];
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    boolean done = false;
    Object selectionValue;
    Transfer selectionTransfer;
    Callback XtConvertSelectionCallback;
    Callback XtLoseSelectionCallback;
    Callback XtSelectionDoneCallback;
    Callback XtSelectionCallbackCallback;
    static byte[] ATOM = Converter.wcsToMbcs(null, "ATOM", true);
    static byte[] CLIPBOARD = Converter.wcsToMbcs(null, "CLIPBOARD", true);
    static byte[] PRIMARY = Converter.wcsToMbcs(null, "PRIMARY", true);
    static byte[] TARGETS = Converter.wcsToMbcs(null, "TARGETS", true);
    static byte[] _MOTIF_CLIPBOARD_TARGETS = Converter.wcsToMbcs(null, "_MOTIF_CLIPBOARD_TARGETS", true);
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(final Display display) {
        ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
        if (clipboardProxy != null) {
            return clipboardProxy;
        }
        clipboardProxy = new ClipboardProxy(display);
        display.setData(ID, clipboardProxy);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
                if (clipboardProxy == null) {
                    return;
                }
                display.setData(ID, null);
                clipboardProxy.dispose();
            }
        });
        return clipboardProxy;
    }

    ClipboardProxy(Display display) {
        this.display = display;
        this.XtConvertSelectionCallback = new Callback(this, "XtConvertSelection", 7);
        if (this.XtConvertSelectionCallback.getAddress() == 0) {
            SWT.error(3);
        }
        this.XtLoseSelectionCallback = new Callback(this, "XtLoseSelection", 2);
        if (this.XtLoseSelectionCallback.getAddress() == 0) {
            SWT.error(3);
        }
        this.XtSelectionDoneCallback = new Callback(this, "XtSelectionDone", 3);
        if (this.XtSelectionDoneCallback.getAddress() == 0) {
            SWT.error(3);
        }
        this.XtSelectionCallbackCallback = new Callback(this, "XtSelectionCallback", 7);
        if (this.XtSelectionCallbackCallback.getAddress() == 0) {
            SWT.error(3);
        }
        int n = OS.topLevelShellWidgetClass();
        this.shellHandle = OS.XtAppCreateShell(null, null, n, display.xDisplay, null, 0);
        OS.XtSetMappedWhenManaged(this.shellHandle, false);
        OS.XtRealizeWidget(this.shellHandle);
        int n2 = OS.XtDisplay(this.shellHandle);
        this.atomAtom = OS.XmInternAtom(n2, ATOM, true);
        this.clipboardAtom = OS.XmInternAtom(n2, CLIPBOARD, true);
        this.motifClipboardAtom = OS.XmInternAtom(n2, _MOTIF_CLIPBOARD_TARGETS, true);
        this.primaryAtom = OS.XmInternAtom(n2, PRIMARY, true);
        this.targetsAtom = OS.XmInternAtom(n2, TARGETS, true);
    }

    void clear(Clipboard clipboard, int n) {
        int n2 = OS.XtDisplay(this.shellHandle);
        if (n2 == 0) {
            return;
        }
        if ((n & 1) != 0 && this.activeClipboard == clipboard) {
            OS.XtDisownSelection(this.shellHandle, this.clipboardAtom, 0);
        }
        if ((n & 2) != 0 && this.activePrimaryClipboard == clipboard) {
            OS.XtDisownSelection(this.shellHandle, this.primaryAtom, 0);
        }
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.shellHandle != 0) {
            OS.XtDestroyWidget(this.shellHandle);
            this.shellHandle = 0;
        }
        if (this.XtConvertSelectionCallback != null) {
            this.XtConvertSelectionCallback.dispose();
        }
        this.XtConvertSelectionCallback = null;
        if (this.XtLoseSelectionCallback != null) {
            this.XtLoseSelectionCallback.dispose();
        }
        this.XtLoseSelectionCallback = null;
        if (this.XtSelectionCallbackCallback != null) {
            this.XtSelectionCallbackCallback.dispose();
        }
        this.XtSelectionCallbackCallback = null;
        if (this.XtSelectionDoneCallback != null) {
            this.XtSelectionDoneCallback.dispose();
        }
        this.XtSelectionDoneCallback = null;
        this.activeClipboard = null;
        this.activePrimaryClipboard = null;
        this.clipboardData = null;
        this.clipboardDataTypes = null;
        this.primaryClipboardData = null;
        this.primaryClipboardDataTypes = null;
    }

    Object getContents(Transfer transfer, int n) {
        int[] nArray = this.getAvailableTypes(n);
        int n2 = -1;
        TransferData transferData = new TransferData();
        int n3 = 0;
        while (n3 < nArray.length) {
            transferData.type = nArray[n3];
            if (transfer.isSupportedType(transferData)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            return null;
        }
        this.done = false;
        this.selectionValue = null;
        this.selectionTransfer = transfer;
        n3 = n == 1 ? this.clipboardAtom : this.primaryAtom;
        OS.XtGetSelectionValue(this.shellHandle, n3, nArray[n2], this.XtSelectionCallbackCallback.getAddress(), 0, 0);
        if (!this.done) {
            int n4 = OS.XtDisplay(this.shellHandle);
            if (n4 == 0) {
                return null;
            }
            int n5 = OS.XtDisplayToApplicationContext(n4);
            int n6 = OS.XtAppGetSelectionTimeout(n5);
            this.wait(n6);
        }
        return !this.done ? null : this.selectionValue;
    }

    int[] getAvailableTypes(int n) {
        int n2;
        int n3;
        int n4 = OS.XtDisplay(this.shellHandle);
        if (n4 == 0) {
            return new int[0];
        }
        this.done = false;
        this.selectionValue = null;
        this.selectionTransfer = null;
        int n5 = n == 1 ? this.clipboardAtom : this.primaryAtom;
        int n6 = this.targetsAtom;
        OS.XtGetSelectionValue(this.shellHandle, n5, n6, this.XtSelectionCallbackCallback.getAddress(), 0, 0);
        if (!this.done) {
            n3 = OS.XtDisplayToApplicationContext(n4);
            n2 = OS.XtAppGetSelectionTimeout(n3);
            this.wait(n2);
        }
        if (this.done && this.selectionValue == null) {
            this.done = false;
            n6 = this.motifClipboardAtom;
            OS.XtGetSelectionValue(this.shellHandle, n5, n6, this.XtSelectionCallbackCallback.getAddress(), 0, 0);
            if (!this.done) {
                n3 = OS.XtDisplayToApplicationContext(n4);
                n2 = OS.XtAppGetSelectionTimeout(n3);
                this.wait(n2);
            }
        }
        if (this.done && this.selectionValue == null) {
            this.done = false;
            n6 = this.atomAtom;
            OS.XtGetSelectionValue(this.shellHandle, n5, n6, this.XtSelectionCallbackCallback.getAddress(), 0, 0);
            if (!this.done) {
                n3 = OS.XtDisplayToApplicationContext(n4);
                n2 = OS.XtAppGetSelectionTimeout(n3);
                this.wait(n2);
            }
        }
        return !this.done || this.selectionValue == null ? new int[]{} : (int[])this.selectionValue;
    }

    void setContents(Clipboard clipboard, Object[] objectArray, Transfer[] transferArray, int n) {
        int n2;
        int n3;
        int n4;
        if ((n & 1) != 0) {
            this.clipboardData = objectArray;
            this.clipboardDataTypes = transferArray;
            n4 = this.XtConvertSelectionCallback.getAddress();
            if (!OS.XtOwnSelection(this.shellHandle, this.clipboardAtom, 0, n4, n3 = this.XtLoseSelectionCallback.getAddress(), n2 = this.XtSelectionDoneCallback.getAddress())) {
                DND.error(2002);
            }
            this.activeClipboard = clipboard;
        }
        if ((n & 2) != 0) {
            this.primaryClipboardData = objectArray;
            this.primaryClipboardDataTypes = transferArray;
            n4 = this.XtConvertSelectionCallback.getAddress();
            if (!OS.XtOwnSelection(this.shellHandle, this.primaryAtom, 0, n4, n3 = this.XtLoseSelectionCallback.getAddress(), n2 = this.XtSelectionDoneCallback.getAddress())) {
                DND.error(2002);
            }
            this.activePrimaryClipboard = clipboard;
        }
    }

    void storePtr(int n, int n2, int n3) {
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.convertData.length) {
            if (this.convertData[n5][0] == 0) {
                n4 = n5;
                break;
            }
            ++n5;
        }
        if (n4 == -1) {
            int[][] nArray = new int[this.convertData.length + 4][3];
            System.arraycopy(this.convertData, 0, nArray, 0, this.convertData.length);
            n4 = this.convertData.length;
            this.convertData = nArray;
        }
        this.convertData[n4][0] = n2;
        this.convertData[n4][1] = n3;
        this.convertData[n4][2] = n;
    }

    void wait(int n) {
        int n2 = OS.XtDisplay(this.shellHandle);
        if (n2 == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        Callback callback = new Callback(this, "checkEvent", 3);
        int n3 = callback.getAddress();
        if (n3 == 0) {
            SWT.error(3);
        }
        int n4 = OS.XtMalloc(96);
        this.display.timerExec(n, new Runnable(){

            public void run() {
            }
        });
        while (!this.done && System.currentTimeMillis() - l < (long)n && this.display != null) {
            if (OS.XCheckIfEvent(n2, n4, n3, 0) != 0) {
                OS.XtDispatchEvent(n4);
                continue;
            }
            this.display.sleep();
        }
        OS.XtFree(n4);
        callback.dispose();
    }

    int checkEvent(int n, int n2, int n3) {
        XEvent xEvent = new XEvent();
        OS.memmove(xEvent, n2, 96);
        switch (xEvent.type) {
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return 1;
            }
        }
        return 0;
    }

    int XtConvertSelection(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object;
        Object[] objectArray;
        int n8 = 0;
        if (n2 != 0) {
            objectArray = new int[1];
            OS.memmove(objectArray, n2, 4);
            n8 = objectArray[0];
        }
        if (n8 == 0) {
            return 0;
        }
        objectArray = null;
        if (n8 == this.clipboardAtom) {
            objectArray = this.clipboardDataTypes;
        }
        if (n8 == this.primaryAtom) {
            objectArray = this.primaryClipboardDataTypes;
        }
        if (objectArray == null) {
            return 0;
        }
        int n9 = 0;
        if (n3 != 0) {
            object = new int[1];
            OS.memmove(object, n3, 4);
            n9 = object[0];
        }
        if (n9 == this.atomAtom || n9 == this.targetsAtom || n9 == this.motifClipboardAtom) {
            object = new int[]{n9};
            int n10 = 0;
            while (n10 < objectArray.length) {
                TransferData[] transferDataArray = objectArray[n10].getSupportedTypes();
                int[] nArray = new int[((int[])object).length + transferDataArray.length];
                System.arraycopy(object, 0, nArray, 0, ((int[])object).length);
                int n11 = ((int[])object).length;
                object = nArray;
                int n12 = 0;
                while (n12 < transferDataArray.length) {
                    object[n11++] = transferDataArray[n12].type;
                    ++n12;
                }
                ++n10;
            }
            n10 = OS.XtMalloc(((int[])object).length * 4);
            this.storePtr(n10, n8, n9);
            OS.memmove(n10, object, ((int[])object).length * 4);
            OS.memmove(n4, new int[]{n9}, 4);
            OS.memmove(n5, new int[]{n10}, 4);
            OS.memmove(n6, new int[]{((int[])object).length}, 4);
            OS.memmove(n7, new int[]{32}, 4);
            return 1;
        }
        object = new TransferData();
        object.type = n9;
        int n13 = -1;
        int n14 = 0;
        while (n14 < objectArray.length) {
            if (objectArray[n14].isSupportedType((TransferData)object)) {
                n13 = n14;
                break;
            }
            ++n14;
        }
        if (n13 == -1) {
            return 0;
        }
        Object[] objectArray2 = n8 == this.clipboardAtom ? this.clipboardData : this.primaryClipboardData;
        objectArray[n13].javaToNative(objectArray2[n13], (TransferData)object);
        if (object.format < 8 || object.format % 8 != 0) {
            OS.XtFree(object.pValue);
            return 0;
        }
        OS.memmove(n4, new int[]{object.type}, 4);
        OS.memmove(n5, new int[]{object.pValue}, 4);
        OS.memmove(n6, new int[]{object.length}, 4);
        OS.memmove(n7, new int[]{object.format}, 4);
        this.storePtr(object.pValue, n8, n9);
        return 1;
    }

    int XtLoseSelection(int n, int n2) {
        if (n2 == this.clipboardAtom) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (n2 == this.primaryAtom) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        return 0;
    }

    int XtSelectionCallback(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.done = true;
        int[] nArray = new int[1];
        if (n4 != 0) {
            OS.memmove(nArray, n4, 4);
        }
        if (nArray[0] == 0) {
            return 0;
        }
        int[] nArray2 = new int[1];
        if (n6 != 0) {
            OS.memmove(nArray2, n6, 4);
        }
        if (nArray2[0] == 0) {
            return 0;
        }
        int[] nArray3 = new int[1];
        if (n7 != 0) {
            OS.memmove(nArray3, n7, 4);
        }
        if (nArray[0] == this.atomAtom || nArray[0] == this.targetsAtom || nArray[0] == this.motifClipboardAtom) {
            int[] nArray4 = new int[nArray2[0]];
            OS.memmove(nArray4, n5, nArray2[0] * nArray3[0] / 8);
            this.selectionValue = nArray4;
            return 0;
        }
        if (this.selectionTransfer != null) {
            TransferData transferData = new TransferData();
            transferData.type = nArray[0];
            transferData.length = nArray2[0];
            transferData.format = nArray3[0];
            transferData.pValue = n5;
            transferData.result = 1;
            this.selectionValue = this.selectionTransfer.nativeToJava(transferData);
        }
        return 0;
    }

    int XtSelectionDone(int n, int n2, int n3) {
        if (n3 == 0 || n2 == 0) {
            return 0;
        }
        int[] nArray = new int[1];
        OS.memmove(nArray, n2, 4);
        int[] nArray2 = new int[1];
        OS.memmove(nArray2, n3, 4);
        int n4 = 0;
        while (n4 < this.convertData.length) {
            if (this.convertData[n4][0] == nArray[0] && this.convertData[n4][1] == nArray2[0]) {
                OS.XtFree(this.convertData[n4][2]);
                this.convertData[n4][2] = 0;
                this.convertData[n4][1] = 0;
                this.convertData[n4][0] = 0;
                break;
            }
            ++n4;
        }
        return 0;
    }
}

