/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSColorPanel;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    boolean selected;

    public ColorDialog(Shell parent) {
        this(parent, 65536);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, ColorDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    void changeColor(int id2, int sel, int sender) {
        this.selected = true;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        NSColor color;
        NSColorPanel panel = NSColorPanel.sharedColorPanel();
        if (this.rgb != null) {
            NSColor color2 = NSColor.colorWithDeviceRed((float)this.rgb.red / 255.0f, (float)this.rgb.green / 255.0f, (float)this.rgb.blue / 255.0f, 1.0f);
            panel.setColor(color2);
        }
        SWTPanelDelegate delegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
        int jniRef = OS.NewGlobalRef(this);
        if (jniRef == 0) {
            SWT.error(2);
        }
        OS.object_setInstanceVariable(delegate.id, Display.SWT_OBJECT, jniRef);
        panel.setDelegate(delegate);
        this.rgb = null;
        this.selected = false;
        panel.orderFront(null);
        NSApplication.sharedApplication().runModalForWindow(panel);
        panel.setDelegate(null);
        delegate.release();
        OS.DeleteGlobalRef(jniRef);
        if (this.selected && (color = panel.color()) != null) {
            color = color.colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
            this.rgb = new RGB((int)(color.redComponent() * 255.0f), (int)(color.greenComponent() * 255.0f), (int)(color.blueComponent() * 255.0f));
        }
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    void windowWillClose(int id2, int sel, int sender) {
        NSApplication.sharedApplication().stop(null);
    }
}

