/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    Display display;
    static /* synthetic */ Class class$0;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.Clipboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int clipboards) {
        this.checkWidget();
        if ((clipboards & 1) == 0) {
            return;
        }
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        pasteboard.declareTypes(NSMutableArray.arrayWithCapacity(0), null);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int clipboards) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        if ((clipboards & 1) == 0) {
            return null;
        }
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        if (pasteboard == null) {
            return null;
        }
        String[] typeNames = transfer.getTypeNames();
        NSMutableArray types = NSMutableArray.arrayWithCapacity(typeNames.length);
        int i = 0;
        while (i < typeNames.length) {
            types.addObject(NSString.stringWith(typeNames[i]));
            ++i;
        }
        NSString type = pasteboard.availableTypeFromArray(types);
        if (type != null) {
            TransferData tdata = new TransferData();
            tdata.type = Transfer.registerType(type.getString());
            tdata.data = type.isEqual(OS.NSStringPboardType) || type.isEqual(OS.NSRTFPboardType) || type.isEqual(OS.NSHTMLPboardType) ? pasteboard.stringForType(type) : (type.isEqual(OS.NSFilenamesPboardType) ? new NSArray(pasteboard.propertyListForType((NSString)type).id) : (type.isEqual(OS.NSURLPboardType) ? NSURL.URLFromPasteboard(pasteboard) : pasteboard.dataForType(type)));
            if (tdata.data != null) {
                return transfer.nativeToJava(tdata);
            }
        }
        return null;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.setContents(data, dataTypes, 1);
    }

    public void setContents(Object[] data, Transfer[] dataTypes, int clipboards) {
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length || data.length == 0) {
            DND.error(5);
        }
        int i = 0;
        while (i < data.length) {
            if (data[i] == null || dataTypes[i] == null || !dataTypes[i].validate(data[i])) {
                DND.error(5);
            }
            ++i;
        }
        if ((clipboards & 1) == 0) {
            return;
        }
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        if (pasteboard == null) {
            DND.error(2002);
        }
        pasteboard.declareTypes(NSMutableArray.arrayWithCapacity(0), null);
        int i2 = 0;
        while (i2 < dataTypes.length) {
            String[] typeNames = dataTypes[i2].getTypeNames();
            int j = 0;
            while (j < typeNames.length) {
                TransferData transferData = new TransferData();
                transferData.type = Transfer.registerType(typeNames[j]);
                dataTypes[i2].javaToNative(data[i2], transferData);
                NSObject tdata = transferData.data;
                NSString dataType = NSString.stringWith(typeNames[j]);
                pasteboard.addTypes(NSArray.arrayWithObject(dataType), null);
                if (dataType.isEqual(OS.NSStringPboardType) || dataType.isEqual(OS.NSRTFPboardType) || dataType.isEqual(OS.NSHTMLPboardType)) {
                    pasteboard.setString((NSString)tdata, dataType);
                } else if (dataType.isEqual(OS.NSURLPboardType)) {
                    NSURL url = (NSURL)tdata;
                    url.writeToPasteboard(pasteboard);
                } else if (dataType.isEqual(OS.NSFilenamesPboardType)) {
                    pasteboard.setPropertyList((NSArray)tdata, dataType);
                } else {
                    pasteboard.setData((NSData)tdata, dataType);
                }
                ++j;
            }
            ++i2;
        }
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int clipboards) {
        this.checkWidget();
        if ((clipboards & 1) == 0) {
            return new TransferData[0];
        }
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        NSArray types = pasteboard.types();
        int count = types.count();
        TransferData[] result = new TransferData[count];
        int i = 0;
        while (i < count) {
            result[i] = new TransferData();
            result[i].type = Transfer.registerType(new NSString(types.objectAtIndex(i)).getString());
            ++i;
        }
        return result;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        NSArray types = pasteboard.types();
        int count = types.count();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = new NSString(types.objectAtIndex(i)).getString();
            ++i;
        }
        return result;
    }
}

