/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSBox;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.SWTBox;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    NSView contentView;
    String text = "";

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        NSBox widget = (NSBox)this.view;
        int border = (int)Math.ceil(widget.borderWidth());
        NSSize margins = widget.contentViewMargins();
        NSRect frame = this.contentView.frame();
        width = (int)((float)width + (margins.width + (float)border) * 2.0f);
        height = (int)((float)height + ((margins.height + (float)border) * 2.0f + frame.y));
        return super.computeTrim(x, y, width, height);
    }

    NSView contentView() {
        return this.contentView;
    }

    void createHandle() {
        this.state |= 0x800;
        NSBox widget = (NSBox)new SWTBox().alloc();
        widget.init();
        widget.setTitlePosition(0);
        NSView contentWidget = (NSView)new SWTView().alloc();
        contentWidget.init();
        widget.setContentView(contentWidget);
        this.contentView = contentWidget;
        this.view = widget;
    }

    NSFont defaultNSFont() {
        return this.display.boxFont;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.contentView);
        SWTBox box = (SWTBox)this.view;
        this.display.removeWidget(box.titleCell());
    }

    void drawBackground(int id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, context, rect, -1);
    }

    NSView eventView() {
        return this.contentView;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        NSRect rect = this.contentView.bounds();
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    float getThemeAlpha() {
        return (this.background != null ? 1.0f : 0.25f) * this.parent.getThemeAlpha();
    }

    void register() {
        super.register();
        this.display.addWidget(this.contentView, this);
        SWTBox box = (SWTBox)this.view;
        this.display.addWidget(box.titleCell(), this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.contentView != null) {
            this.contentView.release();
        }
        this.contentView = null;
    }

    void setFont(NSFont font) {
        ((NSBox)this.view).setTitleFont(font);
    }

    void setForeground(float[] color) {
        NSColor nsColor = color == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(color[0], color[1], color[2], 1.0f);
        NSTextFieldCell cell = new NSTextFieldCell(((NSBox)this.view).titleCell().id);
        cell.setTextColor(nsColor);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        NSBox box = (NSBox)this.view;
        box.setTitlePosition(length == 0 ? 0 : 2);
        box.setTitle(NSString.stringWithCharacters(buffer, length));
    }
}

