/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ClipboardProxy;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    Display display;
    static /* synthetic */ Class class$0;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.Clipboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int n) {
        this.checkWidget();
        ClipboardProxy clipboardProxy = ClipboardProxy._getInstance(this.display);
        clipboardProxy.clear(this, n);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int n) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        ClipboardProxy clipboardProxy = ClipboardProxy._getInstance(this.display);
        Object object = null;
        if ((n & 1) != 0) {
            object = clipboardProxy.getContents(transfer, 1);
        }
        if (object != null) {
            return object;
        }
        if ((n & 2) != 0) {
            object = clipboardProxy.getContents(transfer, 2);
        }
        return object;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int n) {
        Object[] objectArray;
        this.checkWidget();
        ClipboardProxy clipboardProxy = ClipboardProxy._getInstance(this.display);
        int[] nArray = null;
        if ((n & 1) != 0) {
            nArray = clipboardProxy.getAvailableTypes(1);
        }
        if ((n & 2) != 0) {
            objectArray = clipboardProxy.getAvailableTypes(2);
            if (nArray == null) {
                nArray = objectArray;
            } else {
                int[] nArray2 = new int[nArray.length + objectArray.length];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                System.arraycopy(objectArray, 0, nArray2, nArray.length, objectArray.length);
                nArray = nArray2;
            }
        }
        if (nArray == null) {
            return new TransferData[0];
        }
        objectArray = new TransferData[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            objectArray[n2] = (int)new TransferData();
            objectArray[n2].type = nArray[n2];
            ++n2;
        }
        return objectArray;
    }

    public String[] getAvailableTypeNames() {
        String string;
        byte[] byArray;
        int n;
        int n2;
        this.checkWidget();
        ClipboardProxy clipboardProxy = ClipboardProxy._getInstance(this.display);
        int[] nArray = clipboardProxy.getAvailableTypes(1);
        int[] nArray2 = clipboardProxy.getAvailableTypes(2);
        String[] stringArray = new String[nArray.length + nArray2.length];
        int n3 = 0;
        int n4 = this.display.xDisplay;
        int n5 = 0;
        while (n5 < nArray.length) {
            n2 = OS.XmGetAtomName(n4, nArray[n5]);
            n = OS.strlen(n2);
            byArray = new byte[n];
            OS.memmove(byArray, n2, n);
            OS.XtFree(n2);
            string = new String(Converter.mbcsToWcs(null, byArray));
            stringArray[n3++] = "CLIPBOARD " + string;
            ++n5;
        }
        n5 = 0;
        while (n5 < nArray2.length) {
            n2 = OS.XmGetAtomName(n4, nArray2[n5]);
            n = OS.strlen(n2);
            byArray = new byte[n];
            OS.memmove(byArray, n2, n);
            OS.XtFree(n2);
            string = new String(Converter.mbcsToWcs(null, byArray));
            stringArray[n3++] = "PRIMARY " + string;
            ++n5;
        }
        return stringArray;
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray) {
        this.setContents(objectArray, transferArray, 1);
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray, int n) {
        this.checkWidget();
        if (objectArray == null || transferArray == null || objectArray.length != transferArray.length || objectArray.length == 0) {
            DND.error(5);
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] == null || transferArray[n2] == null || !transferArray[n2].validate(objectArray[n2])) {
                DND.error(5);
            }
            ++n2;
        }
        ClipboardProxy clipboardProxy = ClipboardProxy._getInstance(this.display);
        clipboardProxy.setContents(this, objectArray, transferArray, n);
    }
}

