/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;

public class FileTransfer
extends ByteArrayTransfer {
    static FileTransfer _instance = new FileTransfer();
    static final String URI_LIST = "text/uri-list";
    static final int URI_LIST_ID = FileTransfer.registerType("text/uri-list");
    static final String URI_LIST_PREFIX = "file:";
    static final String URI_LIST_SEPARATOR = "\r";

    FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] stringArray = (String[])object;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            stringBuffer.append(URI_LIST_PREFIX);
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(URI_LIST_SEPARATOR);
            ++n;
        }
        byte[] byArray = Converter.wcsToMbcs(null, stringBuffer.toString(), true);
        n2 = OS.XtMalloc(byArray.length);
        if (n2 == 0) {
            return;
        }
        OS.memmove(n2, byArray, byArray.length);
        transferData.length = byArray.length;
        transferData.format = 8;
        transferData.pValue = n2;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int n = transferData.format * transferData.length / 8;
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        OS.memmove(byArray, transferData.pValue, n);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        String string = new String(cArray);
        int n2 = string.indexOf(URI_LIST_PREFIX);
        if (n2 == -1) {
            return null;
        }
        n2 += URI_LIST_PREFIX.length();
        String[] stringArray = new String[]{};
        while (n2 < string.length()) {
            int n3 = string.indexOf(URI_LIST_SEPARATOR, n2);
            if (n3 == -1) {
                n3 = string.length() - 1;
            }
            String string2 = string.substring(n2, n3);
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string2;
            stringArray = stringArray2;
            n2 = string.indexOf(URI_LIST_PREFIX, n3);
            if (n2 == -1) break;
            n2 += URI_LIST_PREFIX.length();
        }
        return stringArray;
    }

    protected int[] getTypeIds() {
        return new int[]{URI_LIST_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{URI_LIST};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null || stringArray[n].length() == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

