/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public class TableDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TableDragSourceEffect(Table table) {
        super(table);
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        long[] lArray;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        Table table = (Table)this.control;
        if (table.isListening(40) || table.isListening(42)) {
            return null;
        }
        long l = table.handle;
        long l2 = OS.gtk_tree_view_get_selection(l);
        long l3 = OS.gtk_tree_selection_get_selected_rows(l2, lArray = null);
        if (l3 == 0L) {
            return null;
        }
        int n = Math.min(10, OS.g_list_length(l3));
        Display display = table.getDisplay();
        if (n == 1) {
            long l4 = OS.g_list_nth_data(l3, 0);
            long l5 = OS.gtk_tree_view_create_row_drag_icon(l, l4);
            this.dragSourceImage = Image.gtk_new(display, 1, l5, 0L);
            OS.gtk_tree_path_free(l4);
        } else {
            int n2 = 0;
            int n3 = 0;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            long[] lArray2 = new long[n];
            GdkRectangle gdkRectangle = new GdkRectangle();
            for (int i = 0; i < n; ++i) {
                long l6 = OS.g_list_nth_data(l3, i);
                OS.gtk_tree_view_get_cell_area(l, l6, 0L, gdkRectangle);
                lArray2[i] = OS.gtk_tree_view_create_row_drag_icon(l, l6);
                if (OS.GTK3) {
                    nArray[0] = Cairo.cairo_xlib_surface_get_width(lArray2[i]);
                    nArray2[0] = Cairo.cairo_xlib_surface_get_height(lArray2[i]);
                } else if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                    OS.gdk_pixmap_get_size(lArray2[i], nArray, nArray2);
                } else {
                    OS.gdk_drawable_get_size(lArray2[i], nArray, nArray2);
                }
                n2 = Math.max(n2, nArray[0]);
                n3 = gdkRectangle.y + nArray2[0] - nArray3[0];
                nArray3[i] = gdkRectangle.y;
                nArray4[i] = nArray2[0];
                OS.gtk_tree_path_free(l6);
            }
            if (OS.GTK3) {
                long l7;
                long l8 = Cairo.cairo_image_surface_create(0, n2, n3);
                if (l8 == 0L) {
                    SWT.error(2);
                }
                if ((l7 = Cairo.cairo_create(l8)) == 0L) {
                    SWT.error(2);
                }
                Cairo.cairo_set_operator(l7, 1);
                for (int i = 0; i < n; ++i) {
                    Cairo.cairo_set_source_surface(l7, lArray2[i], 2.0, nArray3[i] - nArray3[0] + 2);
                    Cairo.cairo_rectangle(l7, 0.0, nArray3[i] - nArray3[0], n2, nArray4[i]);
                    Cairo.cairo_fill(l7);
                    Cairo.cairo_surface_destroy(lArray2[i]);
                }
                Cairo.cairo_destroy(l7);
                this.dragSourceImage = Image.gtk_new(display, 1, l8, 0L);
            } else {
                long l9 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n2, n3, -1);
                long l10 = OS.gdk_gc_new(l9);
                long l11 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n2, n3, 1);
                long l12 = OS.gdk_gc_new(l11);
                GdkColor gdkColor = new GdkColor();
                gdkColor.pixel = 0;
                OS.gdk_gc_set_foreground(l12, gdkColor);
                OS.gdk_draw_rectangle(l11, l12, 1, 0, 0, n2, n3);
                gdkColor.pixel = 1;
                OS.gdk_gc_set_foreground(l12, gdkColor);
                for (int i = 0; i < n; ++i) {
                    OS.gdk_draw_drawable(l9, l10, lArray2[i], 0, 0, 0, nArray3[i] - nArray3[0], -1, -1);
                    OS.gdk_draw_rectangle(l11, l12, 1, 0, nArray3[i] - nArray3[0], n2, nArray4[i]);
                    OS.g_object_unref(lArray2[i]);
                }
                OS.g_object_unref(l10);
                OS.g_object_unref(l12);
                this.dragSourceImage = Image.gtk_new(display, 1, l9, l11);
            }
        }
        OS.g_list_free(l3);
        return this.dragSourceImage;
    }
}

