/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.CellDisplayConversionUtils;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.TextDecorationEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;

public abstract class AbstractTextPainter
extends BackgroundPainter {
    public static final String EMPTY = "";
    public static final String DOT = "...";
    public static final String NEW_LINE_REGEX = "\\n\\r|\\r\\n|\\n|\\r";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected boolean wordWrapping = false;
    protected boolean wrapText;
    protected final boolean paintBg;
    protected boolean paintFg = true;
    protected int spacing = 5;
    protected int lineSpacing = 0;
    protected boolean calculateByTextLength;
    protected boolean calculateByTextHeight;
    private boolean underline;
    private boolean strikethrough;
    private boolean trimText = true;
    private Color originalBackground;
    private Color originalForeground;
    private Font originalFont;
    private static Map<String, Integer> temporaryMap = new WeakHashMap<String, Integer>();
    private static Map<Font, FontData[]> fontDataCache = new WeakHashMap<Font, FontData[]>();

    public AbstractTextPainter() {
        this(false, true);
    }

    public AbstractTextPainter(boolean wrapText, boolean paintBg) {
        this(wrapText, paintBg, 0);
    }

    public AbstractTextPainter(boolean wrapText, boolean paintBg, int spacing) {
        this(wrapText, paintBg, spacing, false);
    }

    public AbstractTextPainter(boolean wrapText, boolean paintBg, boolean calculate) {
        this(wrapText, paintBg, 0, calculate);
    }

    public AbstractTextPainter(boolean wrapText, boolean paintBg, boolean calculateByTextLength, boolean calculateByTextHeight) {
        this(wrapText, paintBg, 0, calculateByTextLength, calculateByTextHeight);
    }

    public AbstractTextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculate) {
        this(wrapText, paintBg, spacing, calculate, calculate);
    }

    public AbstractTextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculateByTextLength, boolean calculateByTextHeight) {
        this.wrapText = wrapText;
        this.paintBg = paintBg;
        this.spacing = spacing;
        this.calculateByTextLength = calculateByTextLength;
        this.calculateByTextHeight = calculateByTextHeight;
    }

    protected String convertDataType(ILayerCell cell, IConfigRegistry configRegistry) {
        return CellDisplayConversionUtils.convertDataType(cell, configRegistry);
    }

    public void setupGCFromConfig(GC gc, IStyle cellStyle) {
        Color fg = cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        Color bg = cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        Font font = cellStyle.getAttributeValue(CellStyleAttributes.FONT);
        this.originalFont = gc.getFont();
        this.originalForeground = gc.getForeground();
        this.originalBackground = gc.getBackground();
        gc.setAntialias(-1);
        gc.setTextAntialias(-1);
        gc.setFont(font);
        gc.setForeground(fg != null ? fg : GUIHelper.COLOR_LIST_FOREGROUND);
        gc.setBackground(bg != null ? bg : GUIHelper.COLOR_LIST_BACKGROUND);
    }

    public void resetGC(GC gc) {
        gc.setFont(this.originalFont);
        gc.setForeground(this.originalForeground);
        gc.setBackground(this.originalBackground);
    }

    protected boolean renderUnderlined(IStyle cellStyle) {
        TextDecorationEnum decoration = cellStyle.getAttributeValue(CellStyleAttributes.TEXT_DECORATION);
        if (decoration != null) {
            return decoration.equals((Object)TextDecorationEnum.UNDERLINE) || decoration.equals((Object)TextDecorationEnum.UNDERLINE_STRIKETHROUGH);
        }
        return this.underline;
    }

    protected boolean renderStrikethrough(IStyle cellStyle) {
        TextDecorationEnum decoration = cellStyle.getAttributeValue(CellStyleAttributes.TEXT_DECORATION);
        if (decoration != null) {
            return decoration.equals((Object)TextDecorationEnum.STRIKETHROUGH) || decoration.equals((Object)TextDecorationEnum.UNDERLINE_STRIKETHROUGH);
        }
        return this.strikethrough;
    }

    protected int getNumberOfNewLines(String text) {
        String[] lines = text.split(NEW_LINE_REGEX);
        return lines.length;
    }

    protected int getLengthFromCache(GC gc, String text) {
        String originalString = text;
        StringBuilder buffer = new StringBuilder();
        buffer.append(text);
        if (gc.getFont() != null) {
            FontData[] datas = fontDataCache.get(gc.getFont());
            if (datas == null) {
                datas = gc.getFont().getFontData();
                fontDataCache.put(gc.getFont(), datas);
            }
            if (datas != null && datas.length > 0) {
                buffer.append(datas[0].getName());
                buffer.append(",");
                buffer.append(datas[0].getHeight());
                buffer.append(",");
                buffer.append(datas[0].getStyle());
            }
        }
        text = buffer.toString();
        Integer width = temporaryMap.computeIfAbsent(text, t -> gC.textExtent((String)string).x);
        return width;
    }

    protected String getTextToDisplay(ILayerCell cell, GC gc, int availableLength, String text) {
        StringBuilder output = new StringBuilder();
        if (this.isTrimText()) {
            text = text.trim();
        }
        int textLength = this.getLengthFromCache(gc, text);
        if (this.wordWrapping || !this.calculateByTextLength && this.wrapText) {
            String[] lines;
            String[] stringArray = lines = text.split(NEW_LINE_REGEX);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (output.length() > 0) {
                    output.append(LINE_SEPARATOR);
                }
                String[] words = line.split("\\s");
                String computedText = EMPTY;
                String[] stringArray2 = words;
                int n3 = words.length;
                int n4 = 0;
                while (n4 < n3) {
                    String word = stringArray2[n4];
                    computedText = this.computeTextToDisplay(computedText, word, gc, availableLength);
                    ++n4;
                }
                output.append(computedText);
                ++n2;
            }
        } else if (this.calculateByTextLength && this.wrapText) {
            if (availableLength < textLength) {
                String[] lines;
                textLength = availableLength - 2 * this.spacing;
                String[] stringArray = lines = text.split(NEW_LINE_REGEX);
                int n = lines.length;
                int n5 = 0;
                while (n5 < n) {
                    String[] words;
                    String line = stringArray[n5];
                    if (output.length() > 0) {
                        output.append(LINE_SEPARATOR);
                    }
                    String[] stringArray3 = words = line.split("\\s");
                    int n6 = words.length;
                    int word = 0;
                    while (word < n6) {
                        String word2 = stringArray3[word];
                        textLength = Math.max(textLength, this.getLengthFromCache(gc, word2));
                        ++word;
                    }
                    String computedText = EMPTY;
                    String[] stringArray4 = words;
                    int n7 = words.length;
                    n6 = 0;
                    while (n6 < n7) {
                        String word3 = stringArray4[n6];
                        computedText = this.computeTextToDisplay(computedText, word3, gc, textLength);
                        ++n6;
                    }
                    output.append(computedText);
                    ++n5;
                }
            } else {
                output.append(text);
            }
            this.setNewMinLength(cell, textLength + this.calculatePadding(cell, availableLength));
        } else if (this.calculateByTextLength && !this.wrapText) {
            output.append(this.modifyTextToDisplay(text, gc, textLength));
            this.setNewMinLength(cell, textLength + this.calculatePadding(cell, availableLength) + 2 * this.spacing);
        } else if (!this.calculateByTextLength && !this.wrapText) {
            output.append(this.modifyTextToDisplay(text, gc, availableLength + 2 * this.spacing));
        }
        return output.toString();
    }

    private String computeTextToDisplay(String one, String two, GC gc, int availableSpace) {
        String result = one;
        if (one == null || one.length() == 0 || one.endsWith(LINE_SEPARATOR)) {
            result = String.valueOf(result) + this.modifyTextToDisplay(two, gc, availableSpace);
        } else {
            if (one.indexOf(LINE_SEPARATOR) != -1) {
                one = one.substring(one.lastIndexOf(LINE_SEPARATOR) + LINE_SEPARATOR.length());
            }
            if (this.getLengthFromCache(gc, one) == availableSpace || this.getLengthFromCache(gc, String.valueOf(one) + " " + two) >= availableSpace) {
                result = String.valueOf(result) + LINE_SEPARATOR;
                result = String.valueOf(result) + this.modifyTextToDisplay(two, gc, availableSpace);
            } else {
                result = String.valueOf(result) + ' ';
                result = String.valueOf(result) + two;
            }
        }
        return result;
    }

    private String modifyTextToDisplay(String text, GC gc, int availableLength) {
        int textLength = this.getLengthFromCache(gc, text);
        if (textLength > availableLength) {
            String[] lines;
            StringBuilder result = new StringBuilder();
            String[] stringArray = lines = text.split(NEW_LINE_REGEX);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                int lineLength;
                String line = stringArray[n2];
                if (result.length() > 0) {
                    result.append(LINE_SEPARATOR);
                }
                if ((lineLength = this.getLengthFromCache(gc, line)) > availableLength) {
                    if (!this.wordWrapping) {
                        int numExtraChars = 0;
                        int newStringLength = line.length();
                        String trialLabelText = String.valueOf(line) + DOT;
                        int newTextExtent = this.getLengthFromCache(gc, trialLabelText);
                        while (newTextExtent > availableLength + 1 && newStringLength > 0) {
                            double avgWidthPerChar = (double)newTextExtent / (double)trialLabelText.length();
                            newStringLength = line.length() - (numExtraChars += 1 + (int)((double)(newTextExtent - availableLength) / avgWidthPerChar));
                            if (newStringLength <= 0) continue;
                            trialLabelText = String.valueOf(line.substring(0, newStringLength)) + DOT;
                            newTextExtent = this.getLengthFromCache(gc, trialLabelText);
                        }
                        if (numExtraChars > line.length()) {
                            numExtraChars = line.length();
                        }
                        String testString = line;
                        int i = 0;
                        while (i < line.length()) {
                            testString = String.valueOf(line.substring(0, line.length() + i - numExtraChars)) + DOT;
                            textLength = this.getLengthFromCache(gc, testString);
                            if (textLength >= availableLength) {
                                line = line.length() + i - numExtraChars < 1 ? EMPTY : String.valueOf(line.substring(0, line.length() + i - numExtraChars - 1)) + DOT;
                                break;
                            }
                            ++i;
                        }
                    } else {
                        StringBuilder output = new StringBuilder();
                        StringBuilder wrap = new StringBuilder();
                        char[] cArray = line.toCharArray();
                        int n3 = cArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            char c = cArray[n4];
                            wrap.append(c);
                            int length = this.getLengthFromCache(gc, wrap.toString());
                            if (length >= availableLength) {
                                output.append(wrap.substring(0, wrap.length() - 1)).append(LINE_SEPARATOR);
                                wrap = new StringBuilder();
                                wrap.append(c);
                            }
                            ++n4;
                        }
                        line = output.append((CharSequence)wrap).toString();
                    }
                }
                result.append(line);
                ++n2;
            }
            return result.toString();
        }
        return text;
    }

    protected abstract void setNewMinLength(ILayerCell var1, int var2);

    protected abstract int calculatePadding(ILayerCell var1, int var2);

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public void setStrikethrough(boolean strikethrough) {
        this.strikethrough = strikethrough;
    }

    public boolean isCalculateByTextLength() {
        return this.calculateByTextLength;
    }

    public void setCalculateByTextLength(boolean calculateByTextLength) {
        this.calculateByTextLength = calculateByTextLength;
    }

    public boolean isCalculateByTextHeight() {
        return this.calculateByTextHeight;
    }

    public void setCalculateByTextHeight(boolean calculateByTextHeight) {
        this.calculateByTextHeight = calculateByTextHeight;
    }

    public boolean isTrimText() {
        return this.trimText;
    }

    public void setTrimText(boolean trimText) {
        this.trimText = trimText;
    }

    public boolean isWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean wrapText) {
        this.wrapText = wrapText;
    }

    protected void paintDecoration(IStyle cellStyle, GC gc, int x, int y, int length, int fontHeight) {
        boolean ul = this.renderUnderlined(cellStyle);
        boolean st = this.renderStrikethrough(cellStyle);
        if ((ul || st) && length > 0) {
            if (ul) {
                int underlineY = y + fontHeight - gc.getFontMetrics().getDescent() / 2;
                gc.drawLine(x, underlineY, x + length, underlineY);
            }
            if (st) {
                int strikeY = y + fontHeight / 2 + gc.getFontMetrics().getLeading() / 2;
                gc.drawLine(x, strikeY, x + length, strikeY);
            }
        }
    }

    public boolean isWordWrapping() {
        return this.wordWrapping;
    }

    public void setWordWrapping(boolean wordWrapping) {
        this.wordWrapping = wordWrapping;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int spacing) {
        this.lineSpacing = spacing;
    }
}

