/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.freeze;

import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeHelper;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeCommandHandler;
import org.eclipse.nebula.widgets.nattable.freeze.config.DefaultFreezeGridBindings;
import org.eclipse.nebula.widgets.nattable.grid.command.ClientAreaResizeCommand;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentIndexLayer;
import org.eclipse.nebula.widgets.nattable.group.command.ViewportSelectColumnGroupCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.ViewportSelectRowGroupCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.painter.layer.CompositeFreezeLayerPainter;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportSelectColumnCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportSelectRowCommandHandler;
import org.eclipse.swt.graphics.Point;

public class CompositeFreezeLayer
extends CompositeLayer
implements IUniqueIndexLayer {
    private final FreezeLayer freezeLayer;
    private final ViewportLayer viewportLayer;
    private final SelectionLayer selectionLayer;

    public CompositeFreezeLayer(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this(freezeLayer, viewportLayer, selectionLayer, true);
    }

    public CompositeFreezeLayer(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        super(2, 2);
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
        this.setChildLayer("FROZEN_REGION", freezeLayer, 0, 0);
        this.setChildLayer("FROZEN_ROW_REGION", new DimensionallyDependentIndexLayer(viewportLayer.getScrollableLayer(), viewportLayer, freezeLayer), 1, 0);
        this.setChildLayer("FROZEN_COLUMN_REGION", new DimensionallyDependentIndexLayer(viewportLayer.getScrollableLayer(), freezeLayer, viewportLayer), 0, 1);
        this.setChildLayer("NONFROZEN_REGION", viewportLayer, 1, 1);
        this.layerPainter = new CompositeFreezeLayerPainter(this);
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultFreezeGridBindings());
        }
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof RowStructuralChangeEvent && (((RowStructuralChangeEvent)event).getRowDiffs() == null || ((RowStructuralChangeEvent)event).getRowDiffs().isEmpty()) && this.viewportLayer.getMinimumOriginRowPosition() < this.freezeLayer.getRowCount()) {
            this.viewportLayer.setMinimumOriginY(this.freezeLayer.getHeight());
        }
        if (event instanceof ColumnStructuralChangeEvent && (((ColumnStructuralChangeEvent)event).getColumnDiffs() == null || ((ColumnStructuralChangeEvent)event).getColumnDiffs().isEmpty())) {
            if (this.viewportLayer.getMinimumOriginColumnPosition() < this.freezeLayer.getColumnCount()) {
                this.viewportLayer.setMinimumOriginX(this.freezeLayer.getWidth());
            }
        } else if (event instanceof ColumnResizeEvent && this.freezeLayer.getColumnCount() == this.selectionLayer.getColumnCount() && this.viewportLayer.getMinimumOriginColumnPosition() < this.freezeLayer.getColumnCount()) {
            this.viewportLayer.setMinimumOriginX(this.freezeLayer.getWidth());
        }
        super.handleLayerEvent(event);
    }

    public boolean isFrozen() {
        return this.freezeLayer.isFrozen();
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new FreezeCommandHandler(this.freezeLayer, this.viewportLayer, this.selectionLayer));
        DimensionallyDependentIndexLayer frozenRowLayer = (DimensionallyDependentIndexLayer)this.getChildLayerByLayoutCoordinate(1, 0);
        frozenRowLayer.registerCommandHandler(new ViewportSelectRowCommandHandler(frozenRowLayer));
        frozenRowLayer.registerCommandHandler(new ViewportSelectRowGroupCommandHandler(frozenRowLayer));
        DimensionallyDependentIndexLayer frozenColumnLayer = (DimensionallyDependentIndexLayer)this.getChildLayerByLayoutCoordinate(0, 1);
        frozenColumnLayer.registerCommandHandler(new ViewportSelectColumnCommandHandler(frozenColumnLayer));
        frozenColumnLayer.registerCommandHandler(new ViewportSelectColumnGroupCommandHandler(frozenColumnLayer));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ClientAreaResizeCommand) {
            this.viewportLayer.doCommand(command);
        }
        return super.doCommand(command);
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        int columnPosition = this.freezeLayer.getColumnPositionByIndex(columnIndex);
        if (columnPosition >= 0) {
            return columnPosition;
        }
        return this.freezeLayer.getColumnCount() + this.viewportLayer.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        int rowPosition = this.freezeLayer.getRowPositionByIndex(rowIndex);
        if (rowPosition >= 0) {
            return rowPosition;
        }
        return this.freezeLayer.getRowCount() + this.viewportLayer.getRowPositionByIndex(rowIndex);
    }

    @Override
    protected int getLayoutXByColumnPosition(int compositeColumnPosition) {
        if (compositeColumnPosition < 0 || compositeColumnPosition >= this.getColumnCount()) {
            return 1;
        }
        return super.getLayoutXByColumnPosition(compositeColumnPosition);
    }

    @Override
    protected int getLayoutYByRowPosition(int compositeRowPosition) {
        if (compositeRowPosition < 0 || compositeRowPosition >= this.getRowCount()) {
            return 1;
        }
        return super.getLayoutYByRowPosition(compositeRowPosition);
    }

    @Override
    protected Point getLayoutXYByPosition(int compositeColumnPosition, int compositeRowPosition) {
        int layoutX = this.getLayoutXByColumnPosition(compositeColumnPosition);
        int layoutY = this.getLayoutYByRowPosition(compositeRowPosition);
        if (layoutX < 0 || layoutY < 0) {
            return null;
        }
        return new Point(layoutX, layoutY);
    }

    public int[] getColumnBounds(int columnPosition, int startColumn, int endColumn) {
        int columnPositionLayout = this.getLayoutXByColumnPosition(columnPosition);
        int startColumnLayout = this.getLayoutXByColumnPosition(startColumn);
        int endColumnLayout = this.getLayoutXByColumnPosition(endColumn);
        int start = startColumn;
        int end = this.isFrozen() && endColumnLayout == 1 ? endColumn - this.viewportLayer.getScrollableLayer().getColumnPositionByX(this.viewportLayer.getOrigin().getX()) : endColumn;
        ILayer startLayer = null;
        int startX = 0;
        int width = 0;
        if (columnPositionLayout == endColumnLayout) {
            if (endColumnLayout == 0 || startColumn == columnPosition) {
                startX = this.getStartXOfColumnPosition(startColumn);
                int column = startColumn;
                while (column <= endColumn) {
                    width += this.getColumnWidthByPosition(column);
                    ++column;
                }
            } else {
                startLayer = this.getChildLayerByLayoutCoordinate(endColumnLayout, 1);
                end = endColumn - this.viewportLayer.getMinimumOriginColumnPosition();
                startX = this.freezeLayer.getWidth() + startLayer.getStartXOfColumnPosition(start -= this.viewportLayer.getMinimumOriginColumnPosition());
                int column = start;
                while (column <= end) {
                    width += this.viewportLayer.getColumnWidthByPosition(column);
                    ++column;
                }
            }
        } else {
            startLayer = this.getChildLayerByLayoutCoordinate(startColumnLayout, 1);
            startX = this.freezeLayer.getStartXOfColumnPosition(start);
            int freezeWidth = 0;
            int column = start;
            while (column < this.freezeLayer.getColumnCount()) {
                freezeWidth += this.freezeLayer.getColumnWidthByPosition(column);
                ++column;
            }
            int endX = this.freezeLayer.getWidth() + this.viewportLayer.getStartXOfColumnPosition(end) + this.viewportLayer.getColumnWidthByPosition(end);
            width = Math.max(freezeWidth, endX - startX);
        }
        return new int[]{startX, width};
    }

    public int[] getRowBounds(int rowPosition, int startRow, int endRow) {
        int rowPositionLayout = this.getLayoutYByRowPosition(rowPosition);
        int startRowLayout = this.getLayoutYByRowPosition(startRow);
        int endRowLayout = this.getLayoutYByRowPosition(endRow);
        int start = startRow;
        int end = this.isFrozen() && endRowLayout == 1 ? endRow - this.viewportLayer.getScrollableLayer().getRowPositionByY(this.viewportLayer.getOrigin().getY()) : endRow;
        ILayer startLayer = null;
        int startY = 0;
        int height = 0;
        if (rowPositionLayout == endRowLayout) {
            if (endRowLayout == 0 || startRow == rowPosition) {
                startY = this.getStartYOfRowPosition(startRow);
                int row = startRow;
                while (row <= endRow) {
                    height += this.getRowHeightByPosition(row);
                    ++row;
                }
            } else {
                startLayer = this.getChildLayerByLayoutCoordinate(1, endRowLayout);
                end = endRow - this.viewportLayer.getMinimumOriginRowPosition();
                startY = this.freezeLayer.getHeight() + startLayer.getStartYOfRowPosition(start -= this.viewportLayer.getMinimumOriginRowPosition());
                int row = start;
                while (row <= end) {
                    height += this.viewportLayer.getRowHeightByPosition(row);
                    ++row;
                }
            }
        } else {
            startLayer = this.getChildLayerByLayoutCoordinate(1, startRowLayout);
            startY = this.freezeLayer.getStartYOfRowPosition(start);
            int freezeHeight = 0;
            int row = start;
            while (row < this.freezeLayer.getRowCount()) {
                freezeHeight += this.freezeLayer.getRowHeightByPosition(row);
                ++row;
            }
            int endY = this.freezeLayer.getHeight() + this.viewportLayer.getStartYOfRowPosition(end) + this.viewportLayer.getRowHeightByPosition(end);
            height = Math.max(freezeHeight, endY - startY);
        }
        return new int[]{startY, height};
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        PositionCoordinate coord = this.freezeLayer.getTopLeftPosition();
        properties.setProperty(String.valueOf(prefix) + ".freezeTopLeftPosition", String.valueOf(coord.columnPosition) + "," + coord.rowPosition);
        coord = this.freezeLayer.getBottomRightPosition();
        properties.setProperty(String.valueOf(prefix) + ".freezeBottomRightPosition", String.valueOf(coord.columnPosition) + "," + coord.rowPosition);
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String property = properties.getProperty(String.valueOf(prefix) + ".freezeTopLeftPosition");
        PositionCoordinate topLeftPosition = null;
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            String columnPosition = tok.nextToken();
            String rowPosition = tok.nextToken();
            topLeftPosition = new PositionCoordinate(this.freezeLayer, Integer.valueOf(columnPosition), Integer.valueOf(rowPosition));
        }
        property = properties.getProperty(String.valueOf(prefix) + ".freezeBottomRightPosition");
        PositionCoordinate bottomRightPosition = null;
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            String columnPosition = tok.nextToken();
            String rowPosition = tok.nextToken();
            bottomRightPosition = new PositionCoordinate(this.freezeLayer, Integer.valueOf(columnPosition), Integer.valueOf(rowPosition));
        }
        if (topLeftPosition != null && bottomRightPosition != null) {
            if (topLeftPosition.columnPosition == -1 && topLeftPosition.rowPosition == -1 && bottomRightPosition.columnPosition == -1 && bottomRightPosition.rowPosition == -1) {
                FreezeHelper.unfreeze(this.freezeLayer, this.viewportLayer);
            } else {
                FreezeHelper.freeze(this.freezeLayer, this.viewportLayer, topLeftPosition, bottomRightPosition);
            }
        }
        super.loadState(prefix, properties);
    }
}

