/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tickupdate.command;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.tickupdate.ITickUpdateHandler;
import org.eclipse.nebula.widgets.nattable.tickupdate.TickUpdateConfigAttributes;
import org.eclipse.nebula.widgets.nattable.tickupdate.command.TickUpdateCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TickUpdateCommandHandler
extends AbstractLayerCommandHandler<TickUpdateCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(TickUpdateCommandHandler.class);
    private SelectionLayer selectionLayer;
    private IUniqueIndexLayer upperLayer;

    public TickUpdateCommandHandler(SelectionLayer selectionLayer) {
        this(selectionLayer, null);
    }

    public TickUpdateCommandHandler(SelectionLayer selectionLayer, IUniqueIndexLayer upperLayer) {
        this.selectionLayer = selectionLayer;
        this.upperLayer = upperLayer;
    }

    @Override
    public boolean doCommand(TickUpdateCommand command) {
        PositionCoordinate[] selectedPositions = this.selectionLayer.getSelectedCellPositions();
        IConfigRegistry configRegistry = command.getConfigRegistry();
        if (selectedPositions.length > 1) {
            if (EditUtils.allCellsEditable(this.selectionLayer, this.upperLayer, configRegistry) && EditUtils.isEditorSame(this.selectionLayer, this.upperLayer, configRegistry) && EditUtils.isConverterSame(this.selectionLayer, this.upperLayer, configRegistry)) {
                PositionCoordinate[] positionCoordinateArray = selectedPositions;
                int n = selectedPositions.length;
                int n2 = 0;
                while (n2 < n) {
                    PositionCoordinate position = positionCoordinateArray[n2];
                    this.updateSingleCell(command, position);
                    ++n2;
                }
            }
        } else {
            this.updateSingleCell(command, this.selectionLayer.getLastSelectedCellPosition());
        }
        return true;
    }

    private void updateSingleCell(TickUpdateCommand command, PositionCoordinate selectedPosition) {
        if (selectedPosition != null) {
            ILayerCell cell = this.selectionLayer.getCellByPosition(selectedPosition.columnPosition, selectedPosition.rowPosition);
            IConfigRegistry configRegistry = command.getConfigRegistry();
            IEditableRule editableRule = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, DisplayMode.EDIT, (List<String>)cell.getConfigLabels());
            IDataValidator validator = configRegistry.getConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, DisplayMode.EDIT, (List<String>)cell.getConfigLabels());
            if (editableRule.isEditable(cell, configRegistry)) {
                Object newValue = this.getNewCellValue(command, cell);
                try {
                    if (validator == null || validator.validate(cell, configRegistry, newValue)) {
                        this.selectionLayer.doCommand(new UpdateDataCommand(this.selectionLayer, selectedPosition.columnPosition, selectedPosition.rowPosition, newValue));
                    } else {
                        LOG.warn("Tick update failed for cell at {} and value {}. New value is not valid!", (Object)selectedPosition, newValue);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Tick update failed for cell at {} and value {}. {}", new Object[]{selectedPosition, newValue, e.getLocalizedMessage()});
                }
            }
        }
    }

    private Object getNewCellValue(TickUpdateCommand command, ILayerCell cell) {
        ITickUpdateHandler tickUpdateHandler = command.getConfigRegistry().getConfigAttribute(TickUpdateConfigAttributes.UPDATE_HANDLER, DisplayMode.EDIT, (List<String>)cell.getConfigLabels());
        Object dataValue = cell.getDataValue();
        if (tickUpdateHandler != null && tickUpdateHandler.isApplicableFor(dataValue)) {
            if (command.isIncrement()) {
                return tickUpdateHandler.getIncrementedValue(dataValue);
            }
            return tickUpdateHandler.getDecrementedValue(dataValue);
        }
        return dataValue;
    }

    @Override
    public Class<TickUpdateCommand> getCommandClass() {
        return TickUpdateCommand.class;
    }
}

