/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.export.image;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.FileOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.ITableExporter;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageExporter
implements ITableExporter {
    private static final Logger LOG = LoggerFactory.getLogger(ImageExporter.class);
    private static final String DEFAULT_IMAGE_NAME = "table_export.bmp";
    private static final String BMP_FILTER_NAME = "BMP files (*.bmp)";
    private static final String BMP_FILTER_EXT = "*.bmp";
    private static final String JPEG_FILTER_NAME = "JPEG files (*.jpeg)";
    private static final String JPEG_FILTER_EXT = "*.jpeg";
    private static final String JPG_FILTER_NAME = "JPG files (*.jpg)";
    private static final String JPG_FILTER_EXT = "*.jpg";
    private static final String PNG_FILTER_NAME = "PNG files (*.png)";
    private static final String PNG_FILTER_EXT = "*.png";
    private static final String[] DEFAULT_FILTER_NAMES = new String[]{"BMP files (*.bmp)", "JPEG files (*.jpeg)", "JPG files (*.jpg)", "PNG files (*.png)"};
    private static final String[] DEFAULT_FILTER_EXTENSIONS = new String[]{"*.bmp", "*.jpeg", "*.jpg", "*.png"};
    private final IOutputStreamProvider outputStreamProvider;

    public ImageExporter() {
        this(new FileOutputStreamProvider(DEFAULT_IMAGE_NAME, DEFAULT_FILTER_NAMES, DEFAULT_FILTER_EXTENSIONS));
    }

    public ImageExporter(IOutputStreamProvider outputStreamProvider) {
        this.outputStreamProvider = outputStreamProvider;
    }

    @Override
    public Object getResult() {
        return this.outputStreamProvider.getResult();
    }

    @Override
    public void exportTable(Shell shell, ProgressBar progressBar, OutputStream outputStream, ILayer layer, IConfigRegistry configRegistry) throws IOException {
        if (shell == null || layer == null || configRegistry == null) {
            throw new IllegalArgumentException("Shell, layer or configure registry must not be null");
        }
        int width = layer.getWidth();
        int height = layer.getHeight();
        Image image = new Image((Device)shell.getDisplay(), width, height);
        GC gc = new GC((Drawable)image);
        Rectangle layerBounds = new Rectangle(0, 0, width, height);
        layer.getLayerPainter().paintLayer(layer, gc, 0, 0, layerBounds, configRegistry);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{image.getImageData()};
        try {
            FileOutputStreamProvider fileOutputStreamProvider;
            String selectedFilterExt;
            int imageFormat;
            if (this.outputStreamProvider instanceof FileOutputStreamProvider && (imageFormat = this.getImageFormatIndex(selectedFilterExt = DEFAULT_FILTER_EXTENSIONS[(fileOutputStreamProvider = (FileOutputStreamProvider)this.outputStreamProvider).getExtensionFilterIndex()])) >= 0) {
                try {
                    imageLoader.save(outputStream, imageFormat);
                }
                catch (SWTException e) {
                    LOG.error("Error while saving the result image", (Throwable)e);
                }
            }
        }
        finally {
            gc.dispose();
            image.dispose();
        }
    }

    protected int getImageFormatIndex(String selectedFilterExt) {
        int imageFormat = -1;
        if (BMP_FILTER_EXT.equals(selectedFilterExt)) {
            imageFormat = 0;
        } else if (JPEG_FILTER_EXT.equals(selectedFilterExt) || JPG_FILTER_EXT.equals(selectedFilterExt)) {
            imageFormat = 4;
        } else if (PNG_FILTER_EXT.equals(selectedFilterExt)) {
            imageFormat = 5;
        }
        return imageFormat;
    }

    @Override
    public OutputStream getOutputStream(Shell shell) {
        if (shell == null) {
            throw new IllegalArgumentException("Shell must not be null");
        }
        return this.outputStreamProvider.getOutputStream(shell);
    }
}

