/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BorderPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.GridLineCellLayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionConfigAttributes;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class SelectionLayerPainter
extends GridLineCellLayerPainter {
    public SelectionLayerPainter(Color gridColor) {
        super(gridColor);
    }

    public SelectionLayerPainter() {
    }

    public SelectionLayerPainter(Color gridColor, boolean clipLeft, boolean clipTop) {
        super(gridColor, clipLeft, clipTop);
    }

    public SelectionLayerPainter(boolean clipLeft, boolean clipTop) {
        this(GUIHelper.COLOR_GRAY, clipLeft, clipTop);
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        int rowOffset;
        super.paintLayer(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        if (positionRectangle.width <= 0 || positionRectangle.height <= 0) {
            return;
        }
        final int columnOffset = natLayer.getColumnPositionByX(xOffset);
        BorderPainter.BorderCell[][] borderCells = this.getBorderCells(natLayer, xOffset, yOffset, positionRectangle, new ApplyBorderFunction(rowOffset = natLayer.getRowPositionByY(yOffset)){
            private final /* synthetic */ int val$rowOffset;
            {
                this.val$rowOffset = n2;
            }

            @Override
            public boolean applyBorder(ILayerCell cell) {
                return cell.getColumnPosition() >= columnOffset && cell.getRowPosition() >= this.val$rowOffset && (cell.getDisplayMode() == "SELECT" || cell.getDisplayMode() == "SELECT_HOVER");
            }
        });
        if (borderCells != null) {
            int originalLineStyle = gc.getLineStyle();
            int originalLineWidth = gc.getLineWidth();
            Color originalForeground = gc.getForeground();
            BorderStyle borderStyle = this.getBorderStyle(configRegistry);
            BorderPainter.PaintModeEnum paintMode = positionRectangle.width <= 2 && positionRectangle.height <= 2 ? BorderPainter.PaintModeEnum.NO_EXTERNAL_BORDERS : BorderPainter.PaintModeEnum.ALL;
            BorderPainter borderPainter = new BorderPainter(borderCells, borderStyle, paintMode);
            borderPainter.paintBorder(gc);
            gc.setLineStyle(originalLineStyle);
            gc.setLineWidth(originalLineWidth);
            gc.setForeground(originalForeground);
        }
    }

    protected BorderPainter.BorderCell[][] getBorderCells(ILayer natLayer, int xOffset, int yOffset, Rectangle positionRectangle, ApplyBorderFunction function) {
        boolean atLeastOne = false;
        int columnPositionOffset = positionRectangle.x;
        int columnPositionEnd = columnPositionOffset + positionRectangle.width;
        int rectangleWidth = positionRectangle.width;
        if (positionRectangle.width + positionRectangle.x <= natLayer.getColumnCount()) {
            --columnPositionOffset;
            ++columnPositionEnd;
            rectangleWidth += 2;
        }
        int rowPositionOffset = positionRectangle.y;
        int rowPositionEnd = rowPositionOffset + positionRectangle.height;
        int rectangleHeight = positionRectangle.height;
        if (positionRectangle.height + positionRectangle.y <= natLayer.getRowCount()) {
            --rowPositionOffset;
            ++rowPositionEnd;
            rectangleHeight += 2;
        }
        BorderPainter.BorderCell[][] borderCells = new BorderPainter.BorderCell[rectangleHeight][rectangleWidth];
        int columnPosition = columnPositionOffset;
        int ix = 0;
        while (columnPosition < columnPositionEnd) {
            int rowPosition = rowPositionOffset;
            int iy = 0;
            while (rowPosition < rowPositionEnd) {
                BorderPainter.BorderCell borderCell;
                boolean insideBorder = false;
                Rectangle cellBounds = null;
                ILayerCell currentCell = natLayer.getCellByPosition(columnPosition, rowPosition);
                if (currentCell != null) {
                    cellBounds = currentCell.getBounds();
                    if (function.applyBorder(currentCell)) {
                        insideBorder = true;
                        atLeastOne = true;
                    }
                }
                Rectangle fixedBounds = this.fixBoundsInGridLines(cellBounds, xOffset, yOffset);
                borderCells[iy][ix] = borderCell = new BorderPainter.BorderCell(fixedBounds, insideBorder);
                ++rowPosition;
                ++iy;
            }
            ++columnPosition;
            ++ix;
        }
        return atLeastOne ? borderCells : null;
    }

    protected Rectangle fixBoundsInGridLines(Rectangle cellBounds, int xOffset, int yOffset) {
        if (cellBounds == null) {
            return null;
        }
        Rectangle fixedBounds = new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
        if (this.renderGridLines && fixedBounds.x != 0 && fixedBounds.x != xOffset) {
            --fixedBounds.x;
            ++fixedBounds.width;
        }
        if (this.renderGridLines && fixedBounds.y != 0 && fixedBounds.y != yOffset) {
            --fixedBounds.y;
            ++fixedBounds.height;
        }
        return fixedBounds;
    }

    protected boolean isInCurrentLayer(int ix, int iy, int xOffset, int yOffset, Rectangle cellBounds, BorderPainter.BorderCell[][] borderCells) {
        Rectangle prevCellBounds;
        if (ix == 0 && cellBounds.x + cellBounds.width <= xOffset) {
            return false;
        }
        if (iy == 0 && cellBounds.y + cellBounds.height <= yOffset) {
            return false;
        }
        if (ix == 1 && borderCells[iy][ix - 1].isInsideBorder) {
            prevCellBounds = borderCells[iy][ix - 1].bounds;
            if (prevCellBounds.x + prevCellBounds.width > cellBounds.x) {
                borderCells[iy][ix - 1].isInsideBorder = false;
            }
        }
        if (iy == 1 && borderCells[iy - 1][ix].isInsideBorder) {
            prevCellBounds = borderCells[iy - 1][ix].bounds;
            if (prevCellBounds.y + prevCellBounds.height > cellBounds.y) {
                borderCells[iy - 1][ix].isInsideBorder = false;
            }
        }
        if (ix == borderCells[iy].length - 1) {
            prevCellBounds = borderCells[iy][ix - 1].bounds;
            if (prevCellBounds.x + prevCellBounds.width > cellBounds.x) {
                return false;
            }
        }
        if (iy == borderCells.length - 1) {
            prevCellBounds = borderCells[iy - 1][ix].bounds;
            if (prevCellBounds.y + prevCellBounds.height > cellBounds.y) {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    protected void applyBorderStyle(GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle = configRegistry.getConfigAttribute(SelectionConfigAttributes.SELECTION_GRID_LINE_STYLE, "SELECT", new String[0]);
        if (borderStyle == null) {
            IStyle cellStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "selectionAnchorGridLine");
            BorderStyle borderStyle2 = borderStyle = cellStyle != null ? cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE) : null;
        }
        if (borderStyle == null) {
            gc.setLineStyle(6);
            gc.setLineDash(new int[]{1, 1});
            gc.setForeground(GUIHelper.COLOR_BLACK);
        } else {
            gc.setLineStyle(BorderStyle.LineStyleEnum.toSWT(borderStyle.getLineStyle()));
            gc.setLineWidth(borderStyle.getThickness());
            gc.setForeground(borderStyle.getColor());
        }
    }

    protected BorderStyle getBorderStyle(IConfigRegistry configRegistry) {
        BorderStyle borderStyle = configRegistry.getConfigAttribute(SelectionConfigAttributes.SELECTION_GRID_LINE_STYLE, "SELECT", new String[0]);
        if (borderStyle == null) {
            IStyle cellStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "selectionAnchorGridLine");
            BorderStyle borderStyle2 = borderStyle = cellStyle != null ? cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE) : null;
        }
        if (borderStyle == null) {
            borderStyle = new BorderStyle(1, GUIHelper.COLOR_BLACK, BorderStyle.LineStyleEnum.DOTTED, BorderStyle.BorderModeEnum.CENTERED);
        }
        return borderStyle;
    }

    protected static interface ApplyBorderFunction {
        public boolean applyBorder(ILayerCell var1);
    }
}

