/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.dataset.generator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.nebula.widgets.nattable.dataset.generator.DataGenerator;
import org.eclipse.nebula.widgets.nattable.dataset.generator.DataValueGenerator;
import org.eclipse.nebula.widgets.nattable.dataset.generator.GenerateDouble;
import org.eclipse.nebula.widgets.nattable.dataset.generator.GeneratorException;
import org.eclipse.nebula.widgets.nattable.dataset.generator.TableDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.valuegenerator.UppercaseStringValueGenerator;

public class NatTableDataGenerator {
    private int numRows = 0;
    private int numCols = 0;
    private List<ColumnDataType> columnDataTypes;
    private static DataGenerator<DoubleColumnValueBean> doubleGenerator = new DataGenerator();
    private static DataGenerator<StringColumnValueBean> stringGenerator = new DataGenerator();

    public NatTableDataGenerator(int numCols, int numRows) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.initColumnDataTypes();
    }

    public NatTableDataGenerator() {
    }

    private void initColumnDataTypes() {
        this.columnDataTypes = new ArrayList<ColumnDataType>();
        int i = 0;
        while (i < this.numCols) {
            ColumnDataType dataType = ColumnDataType.values()[(int)(Math.random() * (double)ColumnDataType.values().length)];
            this.columnDataTypes.add(dataType);
            ++i;
        }
    }

    public void persistData(String fileName) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
            int i = 0;
            while (i < this.columnDataTypes.size()) {
                ColumnDataType dataType = this.columnDataTypes.get(i);
                out.write(dataType.toString());
                out.write(i == this.columnDataTypes.size() - 1 ? "" : ",");
                ++i;
            }
            out.newLine();
            String text = "Writing to " + fileName;
            int charsWritten = text.length();
            System.out.print(text);
            int i2 = 0;
            while (i2 < this.numRows) {
                int j = 0;
                while (j < this.numCols) {
                    ColumnDataType dataType = this.columnDataTypes.get(j);
                    ColumnValueBean value = null;
                    switch (dataType) {
                        case STRING_DATA: {
                            value = stringGenerator.generate(StringColumnValueBean.class);
                            break;
                        }
                        case DOUBLE_DATA: {
                            value = doubleGenerator.generate(DoubleColumnValueBean.class);
                        }
                    }
                    String stringValue = value == null || value.getValue() == null ? " " : value.getValue().toString();
                    stringValue = "".equals(stringValue) ? " " : stringValue;
                    out.write(stringValue);
                    out.write(j == this.numCols - 1 ? "" : ",");
                    ++j;
                }
                if (i2 % this.numCols == 0) {
                    System.out.print(".");
                    ++charsWritten;
                }
                if (charsWritten > 80) {
                    System.out.println();
                    charsWritten = 0;
                }
                out.newLine();
                ++i2;
            }
            out.close();
            System.out.println("done");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (GeneratorException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void getNumRows(String fileName) {
        try {
            FileReader fro = new FileReader(fileName);
            BufferedReader bro = new BufferedReader(fro);
            String stringFromFile = bro.readLine();
            while (stringFromFile != null) {
                ++this.numRows;
                stringFromFile = bro.readLine();
            }
            bro.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(String.valueOf(fileName) + ", does not exist");
            System.exit(-1);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            System.exit(-1);
        }
        --this.numRows;
    }

    public TableDataProvider loadData(String fileName) {
        Object[][] tableData;
        block21: {
            this.getNumRows(fileName);
            tableData = null;
            FileReader fro = null;
            BufferedReader bro = null;
            try {
                fro = new FileReader(fileName);
                bro = new BufferedReader(fro);
                String stringFromFile = bro.readLine();
                boolean columnDataTypesRead = false;
                List<ColumnDataType> dataTypes = null;
                int curRow = 0;
                System.out.print("Loading data");
                while (stringFromFile != null) {
                    if (!columnDataTypesRead) {
                        columnDataTypesRead = true;
                        dataTypes = this.parseDataTypes(stringFromFile);
                        this.numCols = dataTypes.size();
                        tableData = new Object[this.numCols][this.numRows];
                    } else {
                        if (dataTypes == null || dataTypes.size() == 0) {
                            throw new IllegalStateException("Data description line missing");
                        }
                        this.addRow(tableData, curRow++, dataTypes, stringFromFile);
                    }
                    stringFromFile = bro.readLine();
                    if (curRow % 1000 != 0) continue;
                    System.out.print(".");
                }
                System.out.println("done");
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(String.valueOf(fileName) + ", does not exist");
                System.exit(-1);
                if (bro != null) {
                    try {
                        bro.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                }
                break block21;
            }
            catch (IOException ioexception) {
                try {
                    ioexception.printStackTrace();
                    System.exit(-1);
                    break block21;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (bro != null) {
                        try {
                            bro.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.exit(-1);
                        }
                    }
                }
            }
            if (bro == null) break block21;
            try {
                bro.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        return new TableDataProvider(tableData, this.numCols, this.numRows);
    }

    private void addRow(Object[][] tableData, int curRow, List<ColumnDataType> dataTypes, String stringFromFile) {
        StringTokenizer tokenizer = new StringTokenizer(stringFromFile, ",");
        int i = 0;
        while (i < dataTypes.size()) {
            ColumnDataType dataType = dataTypes.get(i);
            String token = tokenizer.nextToken().trim();
            switch (dataType) {
                case STRING_DATA: {
                    tableData[i][curRow] = token;
                    break;
                }
                case DOUBLE_DATA: {
                    tableData[i][curRow] = Double.valueOf(token);
                }
            }
            ++i;
        }
    }

    private List<ColumnDataType> parseDataTypes(String stringFromFile) {
        ArrayList<ColumnDataType> dataTypes = new ArrayList<ColumnDataType>();
        StringTokenizer tokenizer = new StringTokenizer(stringFromFile, ",");
        int numDataTypes = tokenizer.countTokens();
        int i = 0;
        while (i < numDataTypes) {
            String token = tokenizer.nextToken().trim();
            ColumnDataType dataType = ColumnDataType.valueOf(token);
            dataTypes.add(dataType);
            ++i;
        }
        return dataTypes;
    }

    public static void main(String[] args) {
        NatTableDataGenerator dataGenerator = new NatTableDataGenerator(100, 10000);
        String fileName = "c:/temp/100x10K_tableData.txt";
        dataGenerator.persistData(fileName);
        dataGenerator = new NatTableDataGenerator(100, 100000);
        fileName = "c:/temp/100x100K_tableData.txt";
        dataGenerator.persistData(fileName);
        dataGenerator = new NatTableDataGenerator(100, 1000000);
        fileName = "c:/temp/100x1mil_tableData.txt";
        dataGenerator.persistData(fileName);
    }

    static enum ColumnDataType {
        STRING_DATA,
        DOUBLE_DATA;

    }

    public static class ColumnValueBean<T> {
        private T value;

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }

    public static class DoubleColumnValueBean
    extends ColumnValueBean<Double> {
        @GenerateDouble(range=1000)
        private Double value;

        @Override
        public Double getValue() {
            return this.value;
        }

        @Override
        public void setValue(Double value) {
            this.value = value;
        }
    }

    public static class StringColumnValueBean
    extends ColumnValueBean<String> {
        @DataValueGenerator(value=UppercaseStringValueGenerator.class)
        private String value;

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }
    }
}

