/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists;

import ca.odell.glazedlists.SortedList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyResolver;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.NatColumnTableFormat;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.NatTableComparatorChooser;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlazedListsSortModel<T>
implements ISortModel,
ILayerListener {
    public static final String PERSISTENCE_KEY_GLAZEDLISTS_SORT_MODEL = ".glazedListsSortModel";
    private NatTableComparatorChooser<T> comparatorChooser;
    protected final SortedList<T> sortedList;
    protected final IColumnAccessor<T> columnAccessor;
    protected final IColumnPropertyResolver columnPropertyResolver;
    protected final IConfigRegistry configRegistry;
    protected final ILayer columnHeaderDataLayer;

    public GlazedListsSortModel(SortedList<T> sortedList, IColumnPropertyAccessor<T> columnPropertyAccessor, IConfigRegistry configRegistry, ILayer dataLayer) {
        this(sortedList, (IColumnAccessor<T>)columnPropertyAccessor, (IColumnPropertyResolver)columnPropertyAccessor, configRegistry, dataLayer);
    }

    public GlazedListsSortModel(SortedList<T> sortedList, IColumnAccessor<T> columnAccessor, IColumnPropertyResolver columnPropertyResolver, IConfigRegistry configRegistry, ILayer dataLayer) {
        this.sortedList = sortedList;
        this.columnAccessor = columnAccessor;
        this.columnPropertyResolver = columnPropertyResolver;
        this.configRegistry = configRegistry;
        this.columnHeaderDataLayer = dataLayer;
        this.columnHeaderDataLayer.addLayerListener((ILayerListener)this);
    }

    protected NatTableComparatorChooser<T> getComparatorChooser() {
        if (this.comparatorChooser == null) {
            this.comparatorChooser = new NatTableComparatorChooser<T>(this.sortedList, new NatColumnTableFormat<T>(this.columnAccessor, this.columnPropertyResolver, this.configRegistry, this.columnHeaderDataLayer));
        }
        return this.comparatorChooser;
    }

    public List<Integer> getSortedColumnIndexes() {
        return this.getComparatorChooser().getSortingColumns();
    }

    public int getSortOrder(int columnIndex) {
        return this.getComparatorChooser().getClickSequence(columnIndex);
    }

    public SortDirectionEnum getSortDirection(int columnIndex) {
        return this.getComparatorChooser().getSortDirectionForColumnIndex(columnIndex);
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        return this.getComparatorChooser().isColumnIndexSorted(columnIndex);
    }

    public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
        return this.getComparatorChooser().getComparatorsForColumn(columnIndex);
    }

    public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        this.getComparatorChooser().sort(columnIndex, sortDirection, accumulate);
    }

    public void loadState(String prefix, Properties properties) {
        Object savedObject = properties.get(String.valueOf(prefix) + PERSISTENCE_KEY_GLAZEDLISTS_SORT_MODEL);
        if (savedObject == null) {
            return;
        }
        this.getComparatorChooser().fromString(savedObject.toString());
    }

    public void saveState(String prefix, Properties properties) {
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_GLAZEDLISTS_SORT_MODEL, this.getComparatorChooser().toString());
    }

    public void clear() {
        this.getComparatorChooser().clearComparator();
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof StructuralRefreshEvent && ((StructuralRefreshEvent)event).isHorizontalStructureChanged()) {
            this.comparatorChooser = null;
        }
    }
}

