/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport;

import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ScrollBarHandlerTemplate;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class VerticalScrollBarHandler
extends ScrollBarHandlerTemplate
implements Listener {
    public VerticalScrollBarHandler(ViewportLayer viewportLayer, ScrollBar scrollBar) {
        super(viewportLayer, scrollBar);
    }

    int pageScrollDistance() {
        int viewportHeight;
        int heightOfRowBeingScrolled = this.scrollableLayer.getRowHeightByPosition(this.getScrollablePosition());
        return heightOfRowBeingScrolled > (viewportHeight = this.viewportLayer.getClientAreaHeight()) ? heightOfRowBeingScrolled : viewportHeight;
    }

    int getSpanByPosition(int scrollablePosition) {
        return this.scrollableLayer.getRowHeightByPosition(scrollablePosition);
    }

    int getScrollablePosition() {
        return LayerUtil.convertRowPosition(this.viewportLayer, 0, this.scrollableLayer);
    }

    int getStartPixelOfPosition(int position) {
        return this.scrollableLayer.getStartYOfRowPosition(position);
    }

    int getPositionByPixel(int pixelValue) {
        return this.scrollableLayer.getRowPositionByY(pixelValue);
    }

    int getViewportPixelOffset() {
        return this.scrollableLayer.getStartYOfRowPosition(this.viewportLayer.getMinimumOriginRowPosition());
    }

    void setViewportOrigin(int position) {
        this.viewportLayer.invalidateVerticalStructure();
        this.viewportLayer.setOriginRowPosition(position);
        this.scrollBar.setIncrement(this.viewportLayer.getRowHeightByPosition(0));
    }

    SelectionLayer.MoveDirectionEnum scrollDirectionForEventDetail(int eventDetail) {
        return eventDetail == 0x1000005 || eventDetail == 0x1000001 ? SelectionLayer.MoveDirectionEnum.UP : SelectionLayer.MoveDirectionEnum.DOWN;
    }

    boolean keepScrolling() {
        return !this.viewportLayer.isLastRowCompletelyDisplayed();
    }

    int getViewportWindowSpan() {
        return this.viewportLayer.getClientAreaHeight();
    }

    int getScrollableLayerSpan() {
        return this.scrollableLayer.getHeight();
    }
}

