/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.event;

import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.ISelectionEvent;

public class CellSelectionEvent
extends CellVisualChangeEvent
implements ISelectionEvent {
    private final SelectionLayer selectionLayer;
    private boolean forcingEntireCellIntoViewport = false;
    private boolean withShiftMask = false;
    private boolean withControlMask = false;

    public CellSelectionEvent(SelectionLayer selectionLayer, int columnPosition, int rowPosition, boolean forcingEntireCellIntoViewport, boolean withShiftMask, boolean withControlMask) {
        super(selectionLayer, columnPosition, rowPosition);
        this.selectionLayer = selectionLayer;
        this.forcingEntireCellIntoViewport = forcingEntireCellIntoViewport;
        this.withControlMask = withControlMask;
        this.withShiftMask = withShiftMask;
    }

    protected CellSelectionEvent(CellSelectionEvent event) {
        super(event);
        this.selectionLayer = event.selectionLayer;
        this.forcingEntireCellIntoViewport = event.forcingEntireCellIntoViewport;
        this.withControlMask = event.withControlMask;
        this.withShiftMask = event.withShiftMask;
    }

    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public boolean isForcingEntireCellIntoViewport() {
        return this.forcingEntireCellIntoViewport;
    }

    public CellSelectionEvent cloneEvent() {
        return new CellSelectionEvent(this);
    }

    public boolean isWithShiftMask() {
        return this.withShiftMask;
    }

    public boolean isWithControlMask() {
        return this.withControlMask;
    }

    public boolean convertToLocal(ILayer localLayer) {
        if (this.columnPosition == -1 || this.rowPosition == -1) {
            return true;
        }
        this.columnPosition = localLayer.underlyingToLocalColumnPosition(this.getLayer(), this.columnPosition);
        this.rowPosition = localLayer.underlyingToLocalRowPosition(this.getLayer(), this.rowPosition);
        this.layer = localLayer;
        return this.columnPosition >= 0 && this.rowPosition >= 0 && this.columnPosition < this.layer.getColumnCount() && this.rowPosition < this.layer.getRowCount();
    }
}

